/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PurchaseReservedInstancesOffering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedInstancesOfferingRequest extends Ec2Request implements
        ToCopyableBuilder<PurchaseReservedInstancesOfferingRequest.Builder, PurchaseReservedInstancesOfferingRequest> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(PurchaseReservedInstancesOfferingRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesOfferingId")
            .getter(getter(PurchaseReservedInstancesOfferingRequest::reservedInstancesOfferingId))
            .setter(setter(Builder::reservedInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingId")
                    .unmarshallLocationName("ReservedInstancesOfferingId").build()).build();

    private static final SdkField<ReservedInstanceLimitPrice> LIMIT_PRICE_FIELD = SdkField
            .<ReservedInstanceLimitPrice> builder(MarshallingType.SDK_POJO)
            .memberName("LimitPrice")
            .getter(getter(PurchaseReservedInstancesOfferingRequest::limitPrice))
            .setter(setter(Builder::limitPrice))
            .constructor(ReservedInstanceLimitPrice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitPrice")
                    .unmarshallLocationName("limitPrice").build()).build();

    private static final SdkField<Instant> PURCHASE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("PurchaseTime")
            .getter(getter(PurchaseReservedInstancesOfferingRequest::purchaseTime))
            .setter(setter(Builder::purchaseTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseTime")
                    .unmarshallLocationName("PurchaseTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            RESERVED_INSTANCES_OFFERING_ID_FIELD, LIMIT_PRICE_FIELD, PURCHASE_TIME_FIELD));

    private final Integer instanceCount;

    private final String reservedInstancesOfferingId;

    private final ReservedInstanceLimitPrice limitPrice;

    private final Instant purchaseTime;

    private PurchaseReservedInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceCount = builder.instanceCount;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.limitPrice = builder.limitPrice;
        this.purchaseTime = builder.purchaseTime;
    }

    /**
     * <p>
     * The number of Reserved Instances to purchase.
     * </p>
     * 
     * @return The number of Reserved Instances to purchase.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering to purchase.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering to purchase.
     */
    public String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
     * Instances are not purchased at unexpected prices.
     * </p>
     * 
     * @return Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the
     *         Reserved Instances are not purchased at unexpected prices.
     */
    public ReservedInstanceLimitPrice limitPrice() {
        return limitPrice;
    }

    /**
     * <p>
     * The time at which to purchase the Reserved Instance, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The time at which to purchase the Reserved Instance, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant purchaseTime() {
        return purchaseTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(limitPrice());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstancesOfferingRequest other = (PurchaseReservedInstancesOfferingRequest) obj;
        return Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(reservedInstancesOfferingId(), other.reservedInstancesOfferingId())
                && Objects.equals(limitPrice(), other.limitPrice()) && Objects.equals(purchaseTime(), other.purchaseTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PurchaseReservedInstancesOfferingRequest").add("InstanceCount", instanceCount())
                .add("ReservedInstancesOfferingId", reservedInstancesOfferingId()).add("LimitPrice", limitPrice())
                .add("PurchaseTime", purchaseTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "ReservedInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedInstancesOfferingId()));
        case "LimitPrice":
            return Optional.ofNullable(clazz.cast(limitPrice()));
        case "PurchaseTime":
            return Optional.ofNullable(clazz.cast(purchaseTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedInstancesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedInstancesOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
        /**
         * <p>
         * The number of Reserved Instances to purchase.
         * </p>
         * 
         * @param instanceCount
         *        The number of Reserved Instances to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The ID of the Reserved Instance offering to purchase.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
         * Instances are not purchased at unexpected prices.
         * </p>
         * 
         * @param limitPrice
         *        Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the
         *        Reserved Instances are not purchased at unexpected prices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitPrice(ReservedInstanceLimitPrice limitPrice);

        /**
         * <p>
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
         * Instances are not purchased at unexpected prices.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservedInstanceLimitPrice.Builder} avoiding the
         * need to create one manually via {@link ReservedInstanceLimitPrice#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservedInstanceLimitPrice.Builder#build()} is called immediately
         * and its result is passed to {@link #limitPrice(ReservedInstanceLimitPrice)}.
         * 
         * @param limitPrice
         *        a consumer that will call methods on {@link ReservedInstanceLimitPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limitPrice(ReservedInstanceLimitPrice)
         */
        default Builder limitPrice(Consumer<ReservedInstanceLimitPrice.Builder> limitPrice) {
            return limitPrice(ReservedInstanceLimitPrice.builder().applyMutation(limitPrice).build());
        }

        /**
         * <p>
         * The time at which to purchase the Reserved Instance, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param purchaseTime
         *        The time at which to purchase the Reserved Instance, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseTime(Instant purchaseTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer instanceCount;

        private String reservedInstancesOfferingId;

        private ReservedInstanceLimitPrice limitPrice;

        private Instant purchaseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstancesOfferingRequest model) {
            super(model);
            instanceCount(model.instanceCount);
            reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            limitPrice(model.limitPrice);
            purchaseTime(model.purchaseTime);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final ReservedInstanceLimitPrice.Builder getLimitPrice() {
            return limitPrice != null ? limitPrice.toBuilder() : null;
        }

        @Override
        public final Builder limitPrice(ReservedInstanceLimitPrice limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(ReservedInstanceLimitPrice.BuilderImpl limitPrice) {
            this.limitPrice = limitPrice != null ? limitPrice.build() : null;
        }

        public final Instant getPurchaseTime() {
            return purchaseTime;
        }

        @Override
        public final Builder purchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
            return this;
        }

        public final void setPurchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedInstancesOfferingRequest build() {
            return new PurchaseReservedInstancesOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
