/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficMirrorFilterRuleRequest extends Ec2Request implements
        ToCopyableBuilder<CreateTrafficMirrorFilterRuleRequest.Builder, CreateTrafficMirrorFilterRuleRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterId")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("TrafficMirrorFilterId").build()).build();

    private static final SdkField<String> TRAFFIC_DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficDirection")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::trafficDirectionAsString))
            .setter(setter(Builder::trafficDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDirection")
                    .unmarshallLocationName("TrafficDirection").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleNumber")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("RuleNumber").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleAction")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::ruleActionAsString))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("RuleAction").build()).build();

    private static final SdkField<TrafficMirrorPortRangeRequest> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRangeRequest> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationPortRange")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .constructor(TrafficMirrorPortRangeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("DestinationPortRange").build()).build();

    private static final SdkField<TrafficMirrorPortRangeRequest> SOURCE_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRangeRequest> builder(MarshallingType.SDK_POJO)
            .memberName("SourcePortRange")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .constructor(TrafficMirrorPortRangeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("SourcePortRange").build()).build();

    private static final SdkField<Integer> PROTOCOL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Protocol")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("DestinationCidrBlock").build()).build();

    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCidrBlock")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::sourceCidrBlock))
            .setter(setter(Builder::sourceCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock")
                    .unmarshallLocationName("SourceCidrBlock").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_ID_FIELD, TRAFFIC_DIRECTION_FIELD, RULE_NUMBER_FIELD, RULE_ACTION_FIELD,
            DESTINATION_PORT_RANGE_FIELD, SOURCE_PORT_RANGE_FIELD, PROTOCOL_FIELD, DESTINATION_CIDR_BLOCK_FIELD,
            SOURCE_CIDR_BLOCK_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String trafficMirrorFilterId;

    private final String trafficDirection;

    private final Integer ruleNumber;

    private final String ruleAction;

    private final TrafficMirrorPortRangeRequest destinationPortRange;

    private final TrafficMirrorPortRangeRequest sourcePortRange;

    private final Integer protocol;

    private final String destinationCidrBlock;

    private final String sourceCidrBlock;

    private final String description;

    private final String clientToken;

    private CreateTrafficMirrorFilterRuleRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.trafficDirection = builder.trafficDirection;
        this.ruleNumber = builder.ruleNumber;
        this.ruleAction = builder.ruleAction;
        this.destinationPortRange = builder.destinationPortRange;
        this.sourcePortRange = builder.sourcePortRange;
        this.protocol = builder.protocol;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the filter that this rule is associated with.
     * </p>
     * 
     * @return The ID of the filter that this rule is associated with.
     */
    public String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The type of traffic (<code>ingress</code> | <code>egress</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The type of traffic (<code>ingress</code> | <code>egress</code>).
     * @see TrafficDirection
     */
    public TrafficDirection trafficDirection() {
        return TrafficDirection.fromValue(trafficDirection);
    }

    /**
     * <p>
     * The type of traffic (<code>ingress</code> | <code>egress</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The type of traffic (<code>ingress</code> | <code>egress</code>).
     * @see TrafficDirection
     */
    public String trafficDirectionAsString() {
        return trafficDirection;
    }

    /**
     * <p>
     * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
     * direction. The rules are processed in ascending order by rule number.
     * </p>
     * 
     * @return The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
     *         direction. The rules are processed in ascending order by rule number.
     */
    public Integer ruleNumber() {
        return ruleNumber;
    }

    /**
     * <p>
     * The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
     * @see TrafficMirrorRuleAction
     */
    public TrafficMirrorRuleAction ruleAction() {
        return TrafficMirrorRuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
     * @see TrafficMirrorRuleAction
     */
    public String ruleActionAsString() {
        return ruleAction;
    }

    /**
     * <p>
     * The destination port range.
     * </p>
     * 
     * @return The destination port range.
     */
    public TrafficMirrorPortRangeRequest destinationPortRange() {
        return destinationPortRange;
    }

    /**
     * <p>
     * The source port range.
     * </p>
     * 
     * @return The source port range.
     */
    public TrafficMirrorPortRangeRequest sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The protocol, for example UDP, to assign to the Traffic Mirror rule.
     * </p>
     * <p>
     * For information about the protocol value, see <a
     * href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the
     * Internet Assigned Numbers Authority (IANA) website.
     * </p>
     * 
     * @return The protocol, for example UDP, to assign to the Traffic Mirror rule.</p>
     *         <p>
     *         For information about the protocol value, see <a
     *         href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on
     *         the Internet Assigned Numbers Authority (IANA) website.
     */
    public Integer protocol() {
        return protocol;
    }

    /**
     * <p>
     * The destination CIDR block to assign to the Traffic Mirror rule.
     * </p>
     * 
     * @return The destination CIDR block to assign to the Traffic Mirror rule.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The source CIDR block to assign to the Traffic Mirror rule.
     * </p>
     * 
     * @return The source CIDR block to assign to the Traffic Mirror rule.
     */
    public String sourceCidrBlock() {
        return sourceCidrBlock;
    }

    /**
     * <p>
     * The description of the Traffic Mirror rule.
     * </p>
     * 
     * @return The description of the Traffic Mirror rule.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorFilterRuleRequest)) {
            return false;
        }
        CreateTrafficMirrorFilterRuleRequest other = (CreateTrafficMirrorFilterRuleRequest) obj;
        return Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(trafficDirectionAsString(), other.trafficDirectionAsString())
                && Objects.equals(ruleNumber(), other.ruleNumber())
                && Objects.equals(ruleActionAsString(), other.ruleActionAsString())
                && Objects.equals(destinationPortRange(), other.destinationPortRange())
                && Objects.equals(sourcePortRange(), other.sourcePortRange()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(sourceCidrBlock(), other.sourceCidrBlock())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTrafficMirrorFilterRuleRequest").add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("TrafficDirection", trafficDirectionAsString()).add("RuleNumber", ruleNumber())
                .add("RuleAction", ruleActionAsString()).add("DestinationPortRange", destinationPortRange())
                .add("SourcePortRange", sourcePortRange()).add("Protocol", protocol())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("SourceCidrBlock", sourceCidrBlock())
                .add("Description", description()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "TrafficDirection":
            return Optional.ofNullable(clazz.cast(trafficDirectionAsString()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleActionAsString()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "SourceCidrBlock":
            return Optional.ofNullable(clazz.cast(sourceCidrBlock()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorFilterRuleRequest, T> g) {
        return obj -> g.apply((CreateTrafficMirrorFilterRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficMirrorFilterRuleRequest> {
        /**
         * <p>
         * The ID of the filter that this rule is associated with.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the filter that this rule is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The type of traffic (<code>ingress</code> | <code>egress</code>).
         * </p>
         * 
         * @param trafficDirection
         *        The type of traffic (<code>ingress</code> | <code>egress</code>).
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(String trafficDirection);

        /**
         * <p>
         * The type of traffic (<code>ingress</code> | <code>egress</code>).
         * </p>
         * 
         * @param trafficDirection
         *        The type of traffic (<code>ingress</code> | <code>egress</code>).
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(TrafficDirection trafficDirection);

        /**
         * <p>
         * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
         * direction. The rules are processed in ascending order by rule number.
         * </p>
         * 
         * @param ruleNumber
         *        The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a
         *        given direction. The rules are processed in ascending order by rule number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        /**
         * <p>
         * The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
         * </p>
         * 
         * @param ruleAction
         *        The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
         * </p>
         * 
         * @param ruleAction
         *        The action to take (<code>accept</code> | <code>reject</code>) on the filtered traffic.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(TrafficMirrorRuleAction ruleAction);

        /**
         * <p>
         * The destination port range.
         * </p>
         * 
         * @param destinationPortRange
         *        The destination port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(TrafficMirrorPortRangeRequest destinationPortRange);

        /**
         * <p>
         * The destination port range.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficMirrorPortRangeRequest.Builder} avoiding
         * the need to create one manually via {@link TrafficMirrorPortRangeRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRangeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationPortRange(TrafficMirrorPortRangeRequest)}.
         * 
         * @param destinationPortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPortRange(TrafficMirrorPortRangeRequest)
         */
        default Builder destinationPortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> destinationPortRange) {
            return destinationPortRange(TrafficMirrorPortRangeRequest.builder().applyMutation(destinationPortRange).build());
        }

        /**
         * <p>
         * The source port range.
         * </p>
         * 
         * @param sourcePortRange
         *        The source port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(TrafficMirrorPortRangeRequest sourcePortRange);

        /**
         * <p>
         * The source port range.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficMirrorPortRangeRequest.Builder} avoiding
         * the need to create one manually via {@link TrafficMirrorPortRangeRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRangeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #sourcePortRange(TrafficMirrorPortRangeRequest)}.
         * 
         * @param sourcePortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePortRange(TrafficMirrorPortRangeRequest)
         */
        default Builder sourcePortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> sourcePortRange) {
            return sourcePortRange(TrafficMirrorPortRangeRequest.builder().applyMutation(sourcePortRange).build());
        }

        /**
         * <p>
         * The protocol, for example UDP, to assign to the Traffic Mirror rule.
         * </p>
         * <p>
         * For information about the protocol value, see <a
         * href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the
         * Internet Assigned Numbers Authority (IANA) website.
         * </p>
         * 
         * @param protocol
         *        The protocol, for example UDP, to assign to the Traffic Mirror rule.</p>
         *        <p>
         *        For information about the protocol value, see <a
         *        href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>
         *        on the Internet Assigned Numbers Authority (IANA) website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(Integer protocol);

        /**
         * <p>
         * The destination CIDR block to assign to the Traffic Mirror rule.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block to assign to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The source CIDR block to assign to the Traffic Mirror rule.
         * </p>
         * 
         * @param sourceCidrBlock
         *        The source CIDR block to assign to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCidrBlock(String sourceCidrBlock);

        /**
         * <p>
         * The description of the Traffic Mirror rule.
         * </p>
         * 
         * @param description
         *        The description of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trafficMirrorFilterId;

        private String trafficDirection;

        private Integer ruleNumber;

        private String ruleAction;

        private TrafficMirrorPortRangeRequest destinationPortRange;

        private TrafficMirrorPortRangeRequest sourcePortRange;

        private Integer protocol;

        private String destinationCidrBlock;

        private String sourceCidrBlock;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorFilterRuleRequest model) {
            super(model);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            trafficDirection(model.trafficDirection);
            ruleNumber(model.ruleNumber);
            ruleAction(model.ruleAction);
            destinationPortRange(model.destinationPortRange);
            sourcePortRange(model.sourcePortRange);
            protocol(model.protocol);
            destinationCidrBlock(model.destinationCidrBlock);
            sourceCidrBlock(model.sourceCidrBlock);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final String getTrafficDirection() {
            return trafficDirection;
        }

        @Override
        public final Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        @Override
        public final Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection(trafficDirection == null ? null : trafficDirection.toString());
            return this;
        }

        public final void setTrafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(TrafficMirrorRuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final TrafficMirrorPortRangeRequest.Builder getDestinationPortRange() {
            return destinationPortRange != null ? destinationPortRange.toBuilder() : null;
        }

        @Override
        public final Builder destinationPortRange(TrafficMirrorPortRangeRequest destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final void setDestinationPortRange(TrafficMirrorPortRangeRequest.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        public final TrafficMirrorPortRangeRequest.Builder getSourcePortRange() {
            return sourcePortRange != null ? sourcePortRange.toBuilder() : null;
        }

        @Override
        public final Builder sourcePortRange(TrafficMirrorPortRangeRequest sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final void setSourcePortRange(TrafficMirrorPortRangeRequest.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        public final Integer getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(Integer protocol) {
            this.protocol = protocol;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getSourceCidrBlock() {
            return sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficMirrorFilterRuleRequest build() {
            return new CreateTrafficMirrorFilterRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
