/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the associated IAM roles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedRole implements SdkPojo, Serializable, ToCopyableBuilder<AssociatedRole.Builder, AssociatedRole> {
    private static final SdkField<String> ASSOCIATED_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociatedRoleArn")
            .getter(getter(AssociatedRole::associatedRoleArn))
            .setter(setter(Builder::associatedRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoleArn")
                    .unmarshallLocationName("associatedRoleArn").build()).build();

    private static final SdkField<String> CERTIFICATE_S3_BUCKET_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateS3BucketName")
            .getter(getter(AssociatedRole::certificateS3BucketName))
            .setter(setter(Builder::certificateS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateS3BucketName")
                    .unmarshallLocationName("certificateS3BucketName").build()).build();

    private static final SdkField<String> CERTIFICATE_S3_OBJECT_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateS3ObjectKey")
            .getter(getter(AssociatedRole::certificateS3ObjectKey))
            .setter(setter(Builder::certificateS3ObjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateS3ObjectKey")
                    .unmarshallLocationName("certificateS3ObjectKey").build()).build();

    private static final SdkField<String> ENCRYPTION_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKmsKeyId")
            .getter(getter(AssociatedRole::encryptionKmsKeyId))
            .setter(setter(Builder::encryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKmsKeyId")
                    .unmarshallLocationName("encryptionKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_ROLE_ARN_FIELD,
            CERTIFICATE_S3_BUCKET_NAME_FIELD, CERTIFICATE_S3_OBJECT_KEY_FIELD, ENCRYPTION_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associatedRoleArn;

    private final String certificateS3BucketName;

    private final String certificateS3ObjectKey;

    private final String encryptionKmsKeyId;

    private AssociatedRole(BuilderImpl builder) {
        this.associatedRoleArn = builder.associatedRoleArn;
        this.certificateS3BucketName = builder.certificateS3BucketName;
        this.certificateS3ObjectKey = builder.certificateS3ObjectKey;
        this.encryptionKmsKeyId = builder.encryptionKmsKeyId;
    }

    /**
     * <p>
     * The ARN of the associated IAM role.
     * </p>
     * 
     * @return The ARN of the associated IAM role.
     */
    public String associatedRoleArn() {
        return associatedRoleArn;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
     */
    public String certificateS3BucketName() {
        return certificateS3BucketName;
    }

    /**
     * <p>
     * The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle is
     * stored. The object key is formated as follows: <code>certificate_arn</code>/<code>role_arn</code>.
     * </p>
     * 
     * @return The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key
     *         bundle is stored. The object key is formated as follows: <code>certificate_arn</code>/
     *         <code>role_arn</code>.
     */
    public String certificateS3ObjectKey() {
        return certificateS3ObjectKey;
    }

    /**
     * <p>
     * The ID of the KMS customer master key (CMK) used to encrypt the private key.
     * </p>
     * 
     * @return The ID of the KMS customer master key (CMK) used to encrypt the private key.
     */
    public String encryptionKmsKeyId() {
        return encryptionKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatedRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateS3ObjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedRole)) {
            return false;
        }
        AssociatedRole other = (AssociatedRole) obj;
        return Objects.equals(associatedRoleArn(), other.associatedRoleArn())
                && Objects.equals(certificateS3BucketName(), other.certificateS3BucketName())
                && Objects.equals(certificateS3ObjectKey(), other.certificateS3ObjectKey())
                && Objects.equals(encryptionKmsKeyId(), other.encryptionKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociatedRole").add("AssociatedRoleArn", associatedRoleArn())
                .add("CertificateS3BucketName", certificateS3BucketName())
                .add("CertificateS3ObjectKey", certificateS3ObjectKey()).add("EncryptionKmsKeyId", encryptionKmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedRoleArn":
            return Optional.ofNullable(clazz.cast(associatedRoleArn()));
        case "CertificateS3BucketName":
            return Optional.ofNullable(clazz.cast(certificateS3BucketName()));
        case "CertificateS3ObjectKey":
            return Optional.ofNullable(clazz.cast(certificateS3ObjectKey()));
        case "EncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(encryptionKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedRole, T> g) {
        return obj -> g.apply((AssociatedRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedRole> {
        /**
         * <p>
         * The ARN of the associated IAM role.
         * </p>
         * 
         * @param associatedRoleArn
         *        The ARN of the associated IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoleArn(String associatedRoleArn);

        /**
         * <p>
         * The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
         * </p>
         * 
         * @param certificateS3BucketName
         *        The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateS3BucketName(String certificateS3BucketName);

        /**
         * <p>
         * The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle
         * is stored. The object key is formated as follows: <code>certificate_arn</code>/<code>role_arn</code>.
         * </p>
         * 
         * @param certificateS3ObjectKey
         *        The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key
         *        bundle is stored. The object key is formated as follows: <code>certificate_arn</code>/
         *        <code>role_arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateS3ObjectKey(String certificateS3ObjectKey);

        /**
         * <p>
         * The ID of the KMS customer master key (CMK) used to encrypt the private key.
         * </p>
         * 
         * @param encryptionKmsKeyId
         *        The ID of the KMS customer master key (CMK) used to encrypt the private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKmsKeyId(String encryptionKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String associatedRoleArn;

        private String certificateS3BucketName;

        private String certificateS3ObjectKey;

        private String encryptionKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedRole model) {
            associatedRoleArn(model.associatedRoleArn);
            certificateS3BucketName(model.certificateS3BucketName);
            certificateS3ObjectKey(model.certificateS3ObjectKey);
            encryptionKmsKeyId(model.encryptionKmsKeyId);
        }

        public final String getAssociatedRoleArn() {
            return associatedRoleArn;
        }

        @Override
        public final Builder associatedRoleArn(String associatedRoleArn) {
            this.associatedRoleArn = associatedRoleArn;
            return this;
        }

        public final void setAssociatedRoleArn(String associatedRoleArn) {
            this.associatedRoleArn = associatedRoleArn;
        }

        public final String getCertificateS3BucketName() {
            return certificateS3BucketName;
        }

        @Override
        public final Builder certificateS3BucketName(String certificateS3BucketName) {
            this.certificateS3BucketName = certificateS3BucketName;
            return this;
        }

        public final void setCertificateS3BucketName(String certificateS3BucketName) {
            this.certificateS3BucketName = certificateS3BucketName;
        }

        public final String getCertificateS3ObjectKey() {
            return certificateS3ObjectKey;
        }

        @Override
        public final Builder certificateS3ObjectKey(String certificateS3ObjectKey) {
            this.certificateS3ObjectKey = certificateS3ObjectKey;
            return this;
        }

        public final void setCertificateS3ObjectKey(String certificateS3ObjectKey) {
            this.certificateS3ObjectKey = certificateS3ObjectKey;
        }

        public final String getEncryptionKmsKeyId() {
            return encryptionKmsKeyId;
        }

        @Override
        public final Builder encryptionKmsKeyId(String encryptionKmsKeyId) {
            this.encryptionKmsKeyId = encryptionKmsKeyId;
            return this;
        }

        public final void setEncryptionKmsKeyId(String encryptionKmsKeyId) {
            this.encryptionKmsKeyId = encryptionKmsKeyId;
        }

        @Override
        public AssociatedRole build() {
            return new AssociatedRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
