/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRoute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocalGatewayRouteResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateLocalGatewayRouteResponse> {
    private static final SdkField<LocalGatewayRoute> ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Route").getter(CreateLocalGatewayRouteResponse.getter(CreateLocalGatewayRouteResponse::route)).setter(CreateLocalGatewayRouteResponse.setter(Builder::route)).constructor(LocalGatewayRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Route").unmarshallLocationName("route").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_FIELD));
    private final LocalGatewayRoute route;

    private CreateLocalGatewayRouteResponse(BuilderImpl builder) {
        super(builder);
        this.route = builder.route;
    }

    public LocalGatewayRoute route() {
        return this.route;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.route());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocalGatewayRouteResponse)) {
            return false;
        }
        CreateLocalGatewayRouteResponse other = (CreateLocalGatewayRouteResponse)((Object)obj);
        return Objects.equals(this.route(), other.route());
    }

    public String toString() {
        return ToString.builder((String)"CreateLocalGatewayRouteResponse").add("Route", (Object)this.route()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Route": {
                return Optional.ofNullable(clazz.cast(this.route()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocalGatewayRouteResponse, T> g) {
        return obj -> g.apply((CreateLocalGatewayRouteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private LocalGatewayRoute route;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocalGatewayRouteResponse model) {
            super(model);
            this.route(model.route);
        }

        public final LocalGatewayRoute.Builder getRoute() {
            return this.route != null ? this.route.toBuilder() : null;
        }

        @Override
        public final Builder route(LocalGatewayRoute route) {
            this.route = route;
            return this;
        }

        public final void setRoute(LocalGatewayRoute.BuilderImpl route) {
            this.route = route != null ? route.build() : null;
        }

        @Override
        public CreateLocalGatewayRouteResponse build() {
            return new CreateLocalGatewayRouteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocalGatewayRouteResponse> {
        public Builder route(LocalGatewayRoute var1);

        default public Builder route(Consumer<LocalGatewayRoute.Builder> route) {
            return this.route((LocalGatewayRoute)((LocalGatewayRoute.Builder)LocalGatewayRoute.builder().applyMutation(route)).build());
        }
    }
}

