/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instances to which the volume is attached.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeStatusAttachmentStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeStatusAttachmentStatus.Builder, VolumeStatusAttachmentStatus> {
    private static final SdkField<String> IO_PERFORMANCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IoPerformance")
            .getter(getter(VolumeStatusAttachmentStatus::ioPerformance))
            .setter(setter(Builder::ioPerformance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IoPerformance")
                    .unmarshallLocationName("ioPerformance").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(VolumeStatusAttachmentStatus::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IO_PERFORMANCE_FIELD,
            INSTANCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ioPerformance;

    private final String instanceId;

    private VolumeStatusAttachmentStatus(BuilderImpl builder) {
        this.ioPerformance = builder.ioPerformance;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The maximum IOPS supported by the attached instance.
     * </p>
     * 
     * @return The maximum IOPS supported by the attached instance.
     */
    public String ioPerformance() {
        return ioPerformance;
    }

    /**
     * <p>
     * The ID of the attached instance.
     * </p>
     * 
     * @return The ID of the attached instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ioPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusAttachmentStatus)) {
            return false;
        }
        VolumeStatusAttachmentStatus other = (VolumeStatusAttachmentStatus) obj;
        return Objects.equals(ioPerformance(), other.ioPerformance()) && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VolumeStatusAttachmentStatus").add("IoPerformance", ioPerformance())
                .add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IoPerformance":
            return Optional.ofNullable(clazz.cast(ioPerformance()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusAttachmentStatus, T> g) {
        return obj -> g.apply((VolumeStatusAttachmentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeStatusAttachmentStatus> {
        /**
         * <p>
         * The maximum IOPS supported by the attached instance.
         * </p>
         * 
         * @param ioPerformance
         *        The maximum IOPS supported by the attached instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ioPerformance(String ioPerformance);

        /**
         * <p>
         * The ID of the attached instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the attached instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl implements Builder {
        private String ioPerformance;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusAttachmentStatus model) {
            ioPerformance(model.ioPerformance);
            instanceId(model.instanceId);
        }

        public final String getIoPerformance() {
            return ioPerformance;
        }

        @Override
        public final Builder ioPerformance(String ioPerformance) {
            this.ioPerformance = ioPerformance;
            return this;
        }

        public final void setIoPerformance(String ioPerformance) {
            this.ioPerformance = ioPerformance;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public VolumeStatusAttachmentStatus build() {
            return new VolumeStatusAttachmentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
