/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceNetworkAclAssociationResponse extends Ec2Response implements
        ToCopyableBuilder<ReplaceNetworkAclAssociationResponse.Builder, ReplaceNetworkAclAssociationResponse> {
    private static final SdkField<String> NEW_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewAssociationId")
            .getter(getter(ReplaceNetworkAclAssociationResponse::newAssociationId))
            .setter(setter(Builder::newAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewAssociationId")
                    .unmarshallLocationName("newAssociationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_ASSOCIATION_ID_FIELD));

    private final String newAssociationId;

    private ReplaceNetworkAclAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.newAssociationId = builder.newAssociationId;
    }

    /**
     * <p>
     * The ID of the new association.
     * </p>
     * 
     * @return The ID of the new association.
     */
    public String newAssociationId() {
        return newAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(newAssociationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclAssociationResponse)) {
            return false;
        }
        ReplaceNetworkAclAssociationResponse other = (ReplaceNetworkAclAssociationResponse) obj;
        return Objects.equals(newAssociationId(), other.newAssociationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplaceNetworkAclAssociationResponse").add("NewAssociationId", newAssociationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NewAssociationId":
            return Optional.ofNullable(clazz.cast(newAssociationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceNetworkAclAssociationResponse, T> g) {
        return obj -> g.apply((ReplaceNetworkAclAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ReplaceNetworkAclAssociationResponse> {
        /**
         * <p>
         * The ID of the new association.
         * </p>
         * 
         * @param newAssociationId
         *        The ID of the new association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newAssociationId(String newAssociationId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String newAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclAssociationResponse model) {
            super(model);
            newAssociationId(model.newAssociationId);
        }

        public final String getNewAssociationId() {
            return newAssociationId;
        }

        @Override
        public final Builder newAssociationId(String newAssociationId) {
            this.newAssociationId = newAssociationId;
            return this;
        }

        public final void setNewAssociationId(String newAssociationId) {
            this.newAssociationId = newAssociationId;
        }

        @Override
        public ReplaceNetworkAclAssociationResponse build() {
            return new ReplaceNetworkAclAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
