/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recurring charge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecurringCharge implements SdkPojo, Serializable, ToCopyableBuilder<RecurringCharge.Builder, RecurringCharge> {
    private static final SdkField<Double> AMOUNT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("Amount")
            .getter(getter(RecurringCharge::amount))
            .setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount")
                    .unmarshallLocationName("amount").build()).build();

    private static final SdkField<String> FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Frequency")
            .getter(getter(RecurringCharge::frequencyAsString))
            .setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency")
                    .unmarshallLocationName("frequency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AMOUNT_FIELD, FREQUENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double amount;

    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.amount = builder.amount;
        this.frequency = builder.frequency;
    }

    /**
     * <p>
     * The amount of the recurring charge.
     * </p>
     * 
     * @return The amount of the recurring charge.
     */
    public Double amount() {
        return amount;
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link RecurringChargeFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency of the recurring charge.
     * @see RecurringChargeFrequency
     */
    public RecurringChargeFrequency frequency() {
        return RecurringChargeFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link RecurringChargeFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency of the recurring charge.
     * @see RecurringChargeFrequency
     */
    public String frequencyAsString() {
        return frequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(frequencyAsString(), other.frequencyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecurringCharge").add("Amount", amount()).add("Frequency", frequencyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecurringCharge, T> g) {
        return obj -> g.apply((RecurringCharge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecurringCharge> {
        /**
         * <p>
         * The amount of the recurring charge.
         * </p>
         * 
         * @param amount
         *        The amount of the recurring charge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The frequency of the recurring charge.
         * </p>
         * 
         * @param frequency
         *        The frequency of the recurring charge.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The frequency of the recurring charge.
         * </p>
         * 
         * @param frequency
         *        The frequency of the recurring charge.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(RecurringChargeFrequency frequency);
    }

    static final class BuilderImpl implements Builder {
        private Double amount;

        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            amount(model.amount);
            frequency(model.frequency);
        }

        public final Double getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public RecurringCharge build() {
            return new RecurringCharge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
