/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the client connection logging options for the Client VPN endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionLogOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionLogOptions.Builder, ConnectionLogOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(ConnectionLogOptions::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> CLOUDWATCH_LOG_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CloudwatchLogGroup")
            .getter(getter(ConnectionLogOptions::cloudwatchLogGroup))
            .setter(setter(Builder::cloudwatchLogGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogGroup")
                    .unmarshallLocationName("CloudwatchLogGroup").build()).build();

    private static final SdkField<String> CLOUDWATCH_LOG_STREAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CloudwatchLogStream")
            .getter(getter(ConnectionLogOptions::cloudwatchLogStream))
            .setter(setter(Builder::cloudwatchLogStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogStream")
                    .unmarshallLocationName("CloudwatchLogStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            CLOUDWATCH_LOG_GROUP_FIELD, CLOUDWATCH_LOG_STREAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String cloudwatchLogGroup;

    private final String cloudwatchLogStream;

    private ConnectionLogOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.cloudwatchLogGroup = builder.cloudwatchLogGroup;
        this.cloudwatchLogStream = builder.cloudwatchLogStream;
    }

    /**
     * <p>
     * Indicates whether connection logging is enabled.
     * </p>
     * 
     * @return Indicates whether connection logging is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the CloudWatch Logs log group. Required if connection logging is enabled.
     * </p>
     * 
     * @return The name of the CloudWatch Logs log group. Required if connection logging is enabled.
     */
    public String cloudwatchLogGroup() {
        return cloudwatchLogGroup;
    }

    /**
     * <p>
     * The name of the CloudWatch Logs log stream to which the connection data is published.
     * </p>
     * 
     * @return The name of the CloudWatch Logs log stream to which the connection data is published.
     */
    public String cloudwatchLogStream() {
        return cloudwatchLogStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogStream());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionLogOptions)) {
            return false;
        }
        ConnectionLogOptions other = (ConnectionLogOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(cloudwatchLogGroup(), other.cloudwatchLogGroup())
                && Objects.equals(cloudwatchLogStream(), other.cloudwatchLogStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConnectionLogOptions").add("Enabled", enabled()).add("CloudwatchLogGroup", cloudwatchLogGroup())
                .add("CloudwatchLogStream", cloudwatchLogStream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "CloudwatchLogGroup":
            return Optional.ofNullable(clazz.cast(cloudwatchLogGroup()));
        case "CloudwatchLogStream":
            return Optional.ofNullable(clazz.cast(cloudwatchLogStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionLogOptions, T> g) {
        return obj -> g.apply((ConnectionLogOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionLogOptions> {
        /**
         * <p>
         * Indicates whether connection logging is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether connection logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the CloudWatch Logs log group. Required if connection logging is enabled.
         * </p>
         * 
         * @param cloudwatchLogGroup
         *        The name of the CloudWatch Logs log group. Required if connection logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogGroup(String cloudwatchLogGroup);

        /**
         * <p>
         * The name of the CloudWatch Logs log stream to which the connection data is published.
         * </p>
         * 
         * @param cloudwatchLogStream
         *        The name of the CloudWatch Logs log stream to which the connection data is published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogStream(String cloudwatchLogStream);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String cloudwatchLogGroup;

        private String cloudwatchLogStream;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionLogOptions model) {
            enabled(model.enabled);
            cloudwatchLogGroup(model.cloudwatchLogGroup);
            cloudwatchLogStream(model.cloudwatchLogStream);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getCloudwatchLogGroup() {
            return cloudwatchLogGroup;
        }

        @Override
        public final Builder cloudwatchLogGroup(String cloudwatchLogGroup) {
            this.cloudwatchLogGroup = cloudwatchLogGroup;
            return this;
        }

        public final void setCloudwatchLogGroup(String cloudwatchLogGroup) {
            this.cloudwatchLogGroup = cloudwatchLogGroup;
        }

        public final String getCloudwatchLogStream() {
            return cloudwatchLogStream;
        }

        @Override
        public final Builder cloudwatchLogStream(String cloudwatchLogStream) {
            this.cloudwatchLogStream = cloudwatchLogStream;
            return this;
        }

        public final void setCloudwatchLogStream(String cloudwatchLogStream) {
            this.cloudwatchLogStream = cloudwatchLogStream;
        }

        @Override
        public ConnectionLogOptions build() {
            return new ConnectionLogOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
