/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for a transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayRequestOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayRequestOptions.Builder, TransitGatewayRequestOptions> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AmazonSideAsn")
            .getter(getter(TransitGatewayRequestOptions::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn")
                    .unmarshallLocationName("AmazonSideAsn").build()).build();

    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoAcceptSharedAttachments")
            .getter(getter(TransitGatewayRequestOptions::autoAcceptSharedAttachmentsAsString))
            .setter(setter(Builder::autoAcceptSharedAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments")
                    .unmarshallLocationName("AutoAcceptSharedAttachments").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTableAssociation")
            .getter(getter(TransitGatewayRequestOptions::defaultRouteTableAssociationAsString))
            .setter(setter(Builder::defaultRouteTableAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation")
                    .unmarshallLocationName("DefaultRouteTableAssociation").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTablePropagation")
            .getter(getter(TransitGatewayRequestOptions::defaultRouteTablePropagationAsString))
            .setter(setter(Builder::defaultRouteTablePropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation")
                    .unmarshallLocationName("DefaultRouteTablePropagation").build()).build();

    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnEcmpSupport")
            .getter(getter(TransitGatewayRequestOptions::vpnEcmpSupportAsString))
            .setter(setter(Builder::vpnEcmpSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport")
                    .unmarshallLocationName("VpnEcmpSupport").build()).build();

    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DnsSupport")
            .getter(getter(TransitGatewayRequestOptions::dnsSupportAsString))
            .setter(setter(Builder::dnsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport")
                    .unmarshallLocationName("DnsSupport").build()).build();

    private static final SdkField<String> MULTICAST_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MulticastSupport")
            .getter(getter(TransitGatewayRequestOptions::multicastSupportAsString))
            .setter(setter(Builder::multicastSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastSupport")
                    .unmarshallLocationName("MulticastSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD,
            AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD,
            VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD, MULTICAST_SUPPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long amazonSideAsn;

    private final String autoAcceptSharedAttachments;

    private final String defaultRouteTableAssociation;

    private final String defaultRouteTablePropagation;

    private final String vpnEcmpSupport;

    private final String dnsSupport;

    private final String multicastSupport;

    private TransitGatewayRequestOptions(BuilderImpl builder) {
        this.amazonSideAsn = builder.amazonSideAsn;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
        this.multicastSupport = builder.multicastSupport;
    }

    /**
     * <p>
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for
     * 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is <code>64512</code>.
     * </p>
     * 
     * @return A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
     *         65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is <code>64512</code>.
     */
    public Long amazonSideAsn() {
        return amazonSideAsn;
    }

    /**
     * <p>
     * Enable or disable automatic acceptance of attachment requests. Disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Enable or disable automatic acceptance of attachment requests. Disabled by default.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(autoAcceptSharedAttachments);
    }

    /**
     * <p>
     * Enable or disable automatic acceptance of attachment requests. Disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Enable or disable automatic acceptance of attachment requests. Disabled by default.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public String autoAcceptSharedAttachmentsAsString() {
        return autoAcceptSharedAttachments;
    }

    /**
     * <p>
     * Enable or disable automatic association with the default association route table. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic association with the default association route table. Enabled by default.
     * @see DefaultRouteTableAssociationValue
     */
    public DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(defaultRouteTableAssociation);
    }

    /**
     * <p>
     * Enable or disable automatic association with the default association route table. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic association with the default association route table. Enabled by default.
     * @see DefaultRouteTableAssociationValue
     */
    public String defaultRouteTableAssociationAsString() {
        return defaultRouteTableAssociation;
    }

    /**
     * <p>
     * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic propagation of routes to the default propagation route table. Enabled by
     *         default.
     * @see DefaultRouteTablePropagationValue
     */
    public DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(defaultRouteTablePropagation);
    }

    /**
     * <p>
     * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Enable or disable automatic propagation of routes to the default propagation route table. Enabled by
     *         default.
     * @see DefaultRouteTablePropagationValue
     */
    public String defaultRouteTablePropagationAsString() {
        return defaultRouteTablePropagation;
    }

    /**
     * <p>
     * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
     * @see VpnEcmpSupportValue
     */
    public VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(vpnEcmpSupport);
    }

    /**
     * <p>
     * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
     * @see VpnEcmpSupportValue
     */
    public String vpnEcmpSupportAsString() {
        return vpnEcmpSupport;
    }

    /**
     * <p>
     * Enable or disable DNS support. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Enable or disable DNS support. Enabled by default.
     * @see DnsSupportValue
     */
    public DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(dnsSupport);
    }

    /**
     * <p>
     * Enable or disable DNS support. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Enable or disable DNS support. Enabled by default.
     * @see DnsSupportValue
     */
    public String dnsSupportAsString() {
        return dnsSupport;
    }

    /**
     * <p>
     * Indicates whether multicast is enabled on the transit gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multicastSupport}
     * will return {@link MulticastSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #multicastSupportAsString}.
     * </p>
     * 
     * @return Indicates whether multicast is enabled on the transit gateway
     * @see MulticastSupportValue
     */
    public MulticastSupportValue multicastSupport() {
        return MulticastSupportValue.fromValue(multicastSupport);
    }

    /**
     * <p>
     * Indicates whether multicast is enabled on the transit gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multicastSupport}
     * will return {@link MulticastSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #multicastSupportAsString}.
     * </p>
     * 
     * @return Indicates whether multicast is enabled on the transit gateway
     * @see MulticastSupportValue
     */
    public String multicastSupportAsString() {
        return multicastSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multicastSupportAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRequestOptions)) {
            return false;
        }
        TransitGatewayRequestOptions other = (TransitGatewayRequestOptions) obj;
        return Objects.equals(amazonSideAsn(), other.amazonSideAsn())
                && Objects.equals(autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString())
                && Objects.equals(defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString())
                && Objects.equals(defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString())
                && Objects.equals(vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString())
                && Objects.equals(dnsSupportAsString(), other.dnsSupportAsString())
                && Objects.equals(multicastSupportAsString(), other.multicastSupportAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayRequestOptions").add("AmazonSideAsn", amazonSideAsn())
                .add("AutoAcceptSharedAttachments", autoAcceptSharedAttachmentsAsString())
                .add("DefaultRouteTableAssociation", defaultRouteTableAssociationAsString())
                .add("DefaultRouteTablePropagation", defaultRouteTablePropagationAsString())
                .add("VpnEcmpSupport", vpnEcmpSupportAsString()).add("DnsSupport", dnsSupportAsString())
                .add("MulticastSupport", multicastSupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        case "AutoAcceptSharedAttachments":
            return Optional.ofNullable(clazz.cast(autoAcceptSharedAttachmentsAsString()));
        case "DefaultRouteTableAssociation":
            return Optional.ofNullable(clazz.cast(defaultRouteTableAssociationAsString()));
        case "DefaultRouteTablePropagation":
            return Optional.ofNullable(clazz.cast(defaultRouteTablePropagationAsString()));
        case "VpnEcmpSupport":
            return Optional.ofNullable(clazz.cast(vpnEcmpSupportAsString()));
        case "DnsSupport":
            return Optional.ofNullable(clazz.cast(dnsSupportAsString()));
        case "MulticastSupport":
            return Optional.ofNullable(clazz.cast(multicastSupportAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRequestOptions, T> g) {
        return obj -> g.apply((TransitGatewayRequestOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayRequestOptions> {
        /**
         * <p>
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534
         * for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is <code>64512</code>.
         * </p>
         * 
         * @param amazonSideAsn
         *        A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
         *        65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is <code>64512</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);

        /**
         * <p>
         * Enable or disable automatic acceptance of attachment requests. Disabled by default.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Enable or disable automatic acceptance of attachment requests. Disabled by default.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments);

        /**
         * <p>
         * Enable or disable automatic acceptance of attachment requests. Disabled by default.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Enable or disable automatic acceptance of attachment requests. Disabled by default.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments);

        /**
         * <p>
         * Enable or disable automatic association with the default association route table. Enabled by default.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Enable or disable automatic association with the default association route table. Enabled by default.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(String defaultRouteTableAssociation);

        /**
         * <p>
         * Enable or disable automatic association with the default association route table. Enabled by default.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Enable or disable automatic association with the default association route table. Enabled by default.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation);

        /**
         * <p>
         * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Enable or disable automatic propagation of routes to the default propagation route table. Enabled by
         *        default.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(String defaultRouteTablePropagation);

        /**
         * <p>
         * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Enable or disable automatic propagation of routes to the default propagation route table. Enabled by
         *        default.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation);

        /**
         * <p>
         * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(String vpnEcmpSupport);

        /**
         * <p>
         * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport);

        /**
         * <p>
         * Enable or disable DNS support. Enabled by default.
         * </p>
         * 
         * @param dnsSupport
         *        Enable or disable DNS support. Enabled by default.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(String dnsSupport);

        /**
         * <p>
         * Enable or disable DNS support. Enabled by default.
         * </p>
         * 
         * @param dnsSupport
         *        Enable or disable DNS support. Enabled by default.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(DnsSupportValue dnsSupport);

        /**
         * <p>
         * Indicates whether multicast is enabled on the transit gateway
         * </p>
         * 
         * @param multicastSupport
         *        Indicates whether multicast is enabled on the transit gateway
         * @see MulticastSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MulticastSupportValue
         */
        Builder multicastSupport(String multicastSupport);

        /**
         * <p>
         * Indicates whether multicast is enabled on the transit gateway
         * </p>
         * 
         * @param multicastSupport
         *        Indicates whether multicast is enabled on the transit gateway
         * @see MulticastSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MulticastSupportValue
         */
        Builder multicastSupport(MulticastSupportValue multicastSupport);
    }

    static final class BuilderImpl implements Builder {
        private Long amazonSideAsn;

        private String autoAcceptSharedAttachments;

        private String defaultRouteTableAssociation;

        private String defaultRouteTablePropagation;

        private String vpnEcmpSupport;

        private String dnsSupport;

        private String multicastSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRequestOptions model) {
            amazonSideAsn(model.amazonSideAsn);
            autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            vpnEcmpSupport(model.vpnEcmpSupport);
            dnsSupport(model.dnsSupport);
            multicastSupport(model.multicastSupport);
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final String getAutoAcceptSharedAttachments() {
            return autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments == null ? null : autoAcceptSharedAttachments.toString());
            return this;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        public final String getDefaultRouteTableAssociation() {
            return defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation == null ? null : defaultRouteTableAssociation
                    .toString());
            return this;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        public final String getDefaultRouteTablePropagation() {
            return defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation == null ? null : defaultRouteTablePropagation
                    .toString());
            return this;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        public final String getVpnEcmpSupport() {
            return vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport == null ? null : vpnEcmpSupport.toString());
            return this;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        public final String getDnsSupport() {
            return dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport == null ? null : dnsSupport.toString());
            return this;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        public final String getMulticastSupport() {
            return multicastSupport;
        }

        @Override
        public final Builder multicastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
            return this;
        }

        @Override
        public final Builder multicastSupport(MulticastSupportValue multicastSupport) {
            this.multicastSupport(multicastSupport == null ? null : multicastSupport.toString());
            return this;
        }

        public final void setMulticastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
        }

        @Override
        public TransitGatewayRequestOptions build() {
            return new TransitGatewayRequestOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
