/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class NetworkInterfaceIpv6AddressesListCopier {
    static List<NetworkInterfaceIpv6Address> copy(Collection<NetworkInterfaceIpv6Address> networkInterfaceIpv6AddressesListParam) {
        if (networkInterfaceIpv6AddressesListParam == null
                || networkInterfaceIpv6AddressesListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<NetworkInterfaceIpv6Address> networkInterfaceIpv6AddressesListParamCopy = new ArrayList<>(
                networkInterfaceIpv6AddressesListParam);
        return Collections.unmodifiableList(networkInterfaceIpv6AddressesListParamCopy);
    }

    static List<NetworkInterfaceIpv6Address> copyFromBuilder(
            Collection<? extends NetworkInterfaceIpv6Address.Builder> networkInterfaceIpv6AddressesListParam) {
        if (networkInterfaceIpv6AddressesListParam == null
                || networkInterfaceIpv6AddressesListParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(networkInterfaceIpv6AddressesListParam.stream().map(NetworkInterfaceIpv6Address.Builder::build)
                .collect(toList()));
    }
}
