/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a managed prefix list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedPrefixList implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedPrefixList.Builder, ManagedPrefixList> {
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(ManagedPrefixList::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AddressFamily")
            .getter(getter(ManagedPrefixList::addressFamily))
            .setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily")
                    .unmarshallLocationName("addressFamily").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(ManagedPrefixList::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateMessage")
            .getter(getter(ManagedPrefixList::stateMessage))
            .setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage")
                    .unmarshallLocationName("stateMessage").build()).build();

    private static final SdkField<String> PREFIX_LIST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListArn")
            .getter(getter(ManagedPrefixList::prefixListArn))
            .setter(setter(Builder::prefixListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListArn")
                    .unmarshallLocationName("prefixListArn").build()).build();

    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListName")
            .getter(getter(ManagedPrefixList::prefixListName))
            .setter(setter(Builder::prefixListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName")
                    .unmarshallLocationName("prefixListName").build()).build();

    private static final SdkField<Integer> MAX_ENTRIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxEntries")
            .getter(getter(ManagedPrefixList::maxEntries))
            .setter(setter(Builder::maxEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEntries")
                    .unmarshallLocationName("maxEntries").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("Version")
            .getter(getter(ManagedPrefixList::version))
            .setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version")
                    .unmarshallLocationName("version").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ManagedPrefixList::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(ManagedPrefixList::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_ID_FIELD,
            ADDRESS_FAMILY_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, PREFIX_LIST_ARN_FIELD, PREFIX_LIST_NAME_FIELD,
            MAX_ENTRIES_FIELD, VERSION_FIELD, TAGS_FIELD, OWNER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefixListId;

    private final String addressFamily;

    private final String state;

    private final String stateMessage;

    private final String prefixListArn;

    private final String prefixListName;

    private final Integer maxEntries;

    private final Long version;

    private final List<Tag> tags;

    private final String ownerId;

    private ManagedPrefixList(BuilderImpl builder) {
        this.prefixListId = builder.prefixListId;
        this.addressFamily = builder.addressFamily;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.prefixListArn = builder.prefixListArn;
        this.prefixListName = builder.prefixListName;
        this.maxEntries = builder.maxEntries;
        this.version = builder.version;
        this.tags = builder.tags;
        this.ownerId = builder.ownerId;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The IP address version.
     * </p>
     * 
     * @return The IP address version.
     */
    public String addressFamily() {
        return addressFamily;
    }

    /**
     * <p>
     * The state of the prefix list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PrefixListState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the prefix list.
     * @see PrefixListState
     */
    public PrefixListState state() {
        return PrefixListState.fromValue(state);
    }

    /**
     * <p>
     * The state of the prefix list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PrefixListState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the prefix list.
     * @see PrefixListState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The state message.
     * </p>
     * 
     * @return The state message.
     */
    public String stateMessage() {
        return stateMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the prefix list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the prefix list.
     */
    public String prefixListArn() {
        return prefixListArn;
    }

    /**
     * <p>
     * The name of the prefix list.
     * </p>
     * 
     * @return The name of the prefix list.
     */
    public String prefixListName() {
        return prefixListName;
    }

    /**
     * <p>
     * The maximum number of entries for the prefix list.
     * </p>
     * 
     * @return The maximum number of entries for the prefix list.
     */
    public Integer maxEntries() {
        return maxEntries;
    }

    /**
     * <p>
     * The version of the prefix list.
     * </p>
     * 
     * @return The version of the prefix list.
     */
    public Long version() {
        return version;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the prefix list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the prefix list.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the owner of the prefix list.
     * </p>
     * 
     * @return The ID of the owner of the prefix list.
     */
    public String ownerId() {
        return ownerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamily());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListArn());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListName());
        hashCode = 31 * hashCode + Objects.hashCode(maxEntries());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedPrefixList)) {
            return false;
        }
        ManagedPrefixList other = (ManagedPrefixList) obj;
        return Objects.equals(prefixListId(), other.prefixListId()) && Objects.equals(addressFamily(), other.addressFamily())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateMessage(), other.stateMessage())
                && Objects.equals(prefixListArn(), other.prefixListArn())
                && Objects.equals(prefixListName(), other.prefixListName()) && Objects.equals(maxEntries(), other.maxEntries())
                && Objects.equals(version(), other.version()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(ownerId(), other.ownerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ManagedPrefixList").add("PrefixListId", prefixListId()).add("AddressFamily", addressFamily())
                .add("State", stateAsString()).add("StateMessage", stateMessage()).add("PrefixListArn", prefixListArn())
                .add("PrefixListName", prefixListName()).add("MaxEntries", maxEntries()).add("Version", version())
                .add("Tags", hasTags() ? tags() : null).add("OwnerId", ownerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "AddressFamily":
            return Optional.ofNullable(clazz.cast(addressFamily()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        case "PrefixListArn":
            return Optional.ofNullable(clazz.cast(prefixListArn()));
        case "PrefixListName":
            return Optional.ofNullable(clazz.cast(prefixListName()));
        case "MaxEntries":
            return Optional.ofNullable(clazz.cast(maxEntries()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedPrefixList, T> g) {
        return obj -> g.apply((ManagedPrefixList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedPrefixList> {
        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The IP address version.
         * </p>
         * 
         * @param addressFamily
         *        The IP address version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * The state of the prefix list.
         * </p>
         * 
         * @param state
         *        The state of the prefix list.
         * @see PrefixListState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefixListState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the prefix list.
         * </p>
         * 
         * @param state
         *        The state of the prefix list.
         * @see PrefixListState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefixListState
         */
        Builder state(PrefixListState state);

        /**
         * <p>
         * The state message.
         * </p>
         * 
         * @param stateMessage
         *        The state message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the prefix list.
         * </p>
         * 
         * @param prefixListArn
         *        The Amazon Resource Name (ARN) for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListArn(String prefixListArn);

        /**
         * <p>
         * The name of the prefix list.
         * </p>
         * 
         * @param prefixListName
         *        The name of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListName(String prefixListName);

        /**
         * <p>
         * The maximum number of entries for the prefix list.
         * </p>
         * 
         * @param maxEntries
         *        The maximum number of entries for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxEntries(Integer maxEntries);

        /**
         * <p>
         * The version of the prefix list.
         * </p>
         * 
         * @param version
         *        The version of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The tags for the prefix list.
         * </p>
         * 
         * @param tags
         *        The tags for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the prefix list.
         * </p>
         * 
         * @param tags
         *        The tags for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the prefix list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the owner of the prefix list.
         * </p>
         * 
         * @param ownerId
         *        The ID of the owner of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);
    }

    static final class BuilderImpl implements Builder {
        private String prefixListId;

        private String addressFamily;

        private String state;

        private String stateMessage;

        private String prefixListArn;

        private String prefixListName;

        private Integer maxEntries;

        private Long version;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedPrefixList model) {
            prefixListId(model.prefixListId);
            addressFamily(model.addressFamily);
            state(model.state);
            stateMessage(model.stateMessage);
            prefixListArn(model.prefixListArn);
            prefixListName(model.prefixListName);
            maxEntries(model.maxEntries);
            version(model.version);
            tags(model.tags);
            ownerId(model.ownerId);
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PrefixListState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final String getPrefixListArn() {
            return prefixListArn;
        }

        @Override
        public final Builder prefixListArn(String prefixListArn) {
            this.prefixListArn = prefixListArn;
            return this;
        }

        public final void setPrefixListArn(String prefixListArn) {
            this.prefixListArn = prefixListArn;
        }

        public final String getPrefixListName() {
            return prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        public final Integer getMaxEntries() {
            return maxEntries;
        }

        @Override
        public final Builder maxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public final void setMaxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public ManagedPrefixList build() {
            return new ManagedPrefixList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
