/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayPeeringAttachmentRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTransitGatewayPeeringAttachmentRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::transitGatewayId)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("TransitGatewayId").build()}).build();
    private static final SdkField<String> PEER_TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerTransitGatewayId").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::peerTransitGatewayId)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::peerTransitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerTransitGatewayId").unmarshallLocationName("PeerTransitGatewayId").build()}).build();
    private static final SdkField<String> PEER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAccountId").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::peerAccountId)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::peerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAccountId").unmarshallLocationName("PeerAccountId").build()}).build();
    private static final SdkField<String> PEER_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerRegion").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::peerRegion)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::peerRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerRegion").unmarshallLocationName("PeerRegion").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::tagSpecifications)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD, PEER_TRANSIT_GATEWAY_ID_FIELD, PEER_ACCOUNT_ID_FIELD, PEER_REGION_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String transitGatewayId;
    private final String peerTransitGatewayId;
    private final String peerAccountId;
    private final String peerRegion;
    private final List<TagSpecification> tagSpecifications;

    private CreateTransitGatewayPeeringAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayId = builder.transitGatewayId;
        this.peerTransitGatewayId = builder.peerTransitGatewayId;
        this.peerAccountId = builder.peerAccountId;
        this.peerRegion = builder.peerRegion;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public String transitGatewayId() {
        return this.transitGatewayId;
    }

    public String peerTransitGatewayId() {
        return this.peerTransitGatewayId;
    }

    public String peerAccountId() {
        return this.peerAccountId;
    }

    public String peerRegion() {
        return this.peerRegion;
    }

    public boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerTransitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayPeeringAttachmentRequest)) {
            return false;
        }
        CreateTransitGatewayPeeringAttachmentRequest other = (CreateTransitGatewayPeeringAttachmentRequest)((Object)obj);
        return Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.peerTransitGatewayId(), other.peerTransitGatewayId()) && Objects.equals(this.peerAccountId(), other.peerAccountId()) && Objects.equals(this.peerRegion(), other.peerRegion()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"CreateTransitGatewayPeeringAttachmentRequest").add("TransitGatewayId", (Object)this.transitGatewayId()).add("PeerTransitGatewayId", (Object)this.peerTransitGatewayId()).add("PeerAccountId", (Object)this.peerAccountId()).add("PeerRegion", (Object)this.peerRegion()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "PeerTransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.peerTransitGatewayId()));
            }
            case "PeerAccountId": {
                return Optional.ofNullable(clazz.cast(this.peerAccountId()));
            }
            case "PeerRegion": {
                return Optional.ofNullable(clazz.cast(this.peerRegion()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayPeeringAttachmentRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayPeeringAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayId;
        private String peerTransitGatewayId;
        private String peerAccountId;
        private String peerRegion;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayPeeringAttachmentRequest model) {
            super(model);
            this.transitGatewayId(model.transitGatewayId);
            this.peerTransitGatewayId(model.peerTransitGatewayId);
            this.peerAccountId(model.peerAccountId);
            this.peerRegion(model.peerRegion);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getPeerTransitGatewayId() {
            return this.peerTransitGatewayId;
        }

        @Override
        public final Builder peerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
            return this;
        }

        public final void setPeerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
        }

        public final String getPeerAccountId() {
            return this.peerAccountId;
        }

        @Override
        public final Builder peerAccountId(String peerAccountId) {
            this.peerAccountId = peerAccountId;
            return this;
        }

        public final void setPeerAccountId(String peerAccountId) {
            this.peerAccountId = peerAccountId;
        }

        public final String getPeerRegion() {
            return this.peerRegion;
        }

        @Override
        public final Builder peerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
            return this;
        }

        public final void setPeerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            if (this.tagSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(TagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayPeeringAttachmentRequest build() {
            return new CreateTransitGatewayPeeringAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayPeeringAttachmentRequest> {
        public Builder transitGatewayId(String var1);

        public Builder peerTransitGatewayId(String var1);

        public Builder peerAccountId(String var1);

        public Builder peerRegion(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

