/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDhcpOptionsResponse extends Ec2Response implements
        ToCopyableBuilder<CreateDhcpOptionsResponse.Builder, CreateDhcpOptionsResponse> {
    private static final SdkField<DhcpOptions> DHCP_OPTIONS_FIELD = SdkField
            .<DhcpOptions> builder(MarshallingType.SDK_POJO)
            .memberName("DhcpOptions")
            .getter(getter(CreateDhcpOptionsResponse::dhcpOptions))
            .setter(setter(Builder::dhcpOptions))
            .constructor(DhcpOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptions")
                    .unmarshallLocationName("dhcpOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_OPTIONS_FIELD));

    private final DhcpOptions dhcpOptions;

    private CreateDhcpOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.dhcpOptions = builder.dhcpOptions;
    }

    /**
     * <p>
     * A set of DHCP options.
     * </p>
     * 
     * @return A set of DHCP options.
     */
    public DhcpOptions dhcpOptions() {
        return dhcpOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsResponse)) {
            return false;
        }
        CreateDhcpOptionsResponse other = (CreateDhcpOptionsResponse) obj;
        return Objects.equals(dhcpOptions(), other.dhcpOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDhcpOptionsResponse").add("DhcpOptions", dhcpOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpOptions":
            return Optional.ofNullable(clazz.cast(dhcpOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDhcpOptionsResponse, T> g) {
        return obj -> g.apply((CreateDhcpOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateDhcpOptionsResponse> {
        /**
         * <p>
         * A set of DHCP options.
         * </p>
         * 
         * @param dhcpOptions
         *        A set of DHCP options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(DhcpOptions dhcpOptions);

        /**
         * <p>
         * A set of DHCP options.
         * </p>
         * This is a convenience that creates an instance of the {@link DhcpOptions.Builder} avoiding the need to create
         * one manually via {@link DhcpOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DhcpOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #dhcpOptions(DhcpOptions)}.
         * 
         * @param dhcpOptions
         *        a consumer that will call methods on {@link DhcpOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpOptions(DhcpOptions)
         */
        default Builder dhcpOptions(Consumer<DhcpOptions.Builder> dhcpOptions) {
            return dhcpOptions(DhcpOptions.builder().applyMutation(dhcpOptions).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private DhcpOptions dhcpOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsResponse model) {
            super(model);
            dhcpOptions(model.dhcpOptions);
        }

        public final DhcpOptions.Builder getDhcpOptions() {
            return dhcpOptions != null ? dhcpOptions.toBuilder() : null;
        }

        @Override
        public final Builder dhcpOptions(DhcpOptions dhcpOptions) {
            this.dhcpOptions = dhcpOptions;
            return this;
        }

        public final void setDhcpOptions(DhcpOptions.BuilderImpl dhcpOptions) {
            this.dhcpOptions = dhcpOptions != null ? dhcpOptions.build() : null;
        }

        @Override
        public CreateDhcpOptionsResponse build() {
            return new CreateDhcpOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
