/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the instance's Capacity Reservation targeting preferences. The action returns the
 * <code>capacityReservationPreference</code> response element if the instance is configured to run in On-Demand
 * capacity, or if it is configured in run in any <code>open</code> Capacity Reservation that has matching attributes
 * (instance type, platform, Availability Zone). The action returns the <code>capacityReservationTarget</code> response
 * element if the instance explicily targets a specific Capacity Reservation or Capacity Reservation group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationSpecificationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationSpecificationResponse.Builder, CapacityReservationSpecificationResponse> {
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationPreference")
            .getter(getter(CapacityReservationSpecificationResponse::capacityReservationPreferenceAsString))
            .setter(setter(Builder::capacityReservationPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference")
                    .unmarshallLocationName("capacityReservationPreference").build()).build();

    private static final SdkField<CapacityReservationTargetResponse> CAPACITY_RESERVATION_TARGET_FIELD = SdkField
            .<CapacityReservationTargetResponse> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationTarget")
            .getter(getter(CapacityReservationSpecificationResponse::capacityReservationTarget))
            .setter(setter(Builder::capacityReservationTarget))
            .constructor(CapacityReservationTargetResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationTarget")
                    .unmarshallLocationName("capacityReservationTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_PREFERENCE_FIELD, CAPACITY_RESERVATION_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacityReservationPreference;

    private final CapacityReservationTargetResponse capacityReservationTarget;

    private CapacityReservationSpecificationResponse(BuilderImpl builder) {
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.capacityReservationTarget = builder.capacityReservationTarget;
    }

    /**
     * <p>
     * Describes the instance's Capacity Reservation preferences. Possible preferences include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     * attributes (instance type, platform, Availability Zone).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance
     * runs in On-Demand capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     *         attributes (instance type, platform, Availability Zone).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
     *         instance runs in On-Demand capacity.
     *         </p>
     *         </li>
     * @see CapacityReservationPreference
     */
    public CapacityReservationPreference capacityReservationPreference() {
        return CapacityReservationPreference.fromValue(capacityReservationPreference);
    }

    /**
     * <p>
     * Describes the instance's Capacity Reservation preferences. Possible preferences include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     * attributes (instance type, platform, Availability Zone).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance
     * runs in On-Demand capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     *         attributes (instance type, platform, Availability Zone).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
     *         instance runs in On-Demand capacity.
     *         </p>
     *         </li>
     * @see CapacityReservationPreference
     */
    public String capacityReservationPreferenceAsString() {
        return capacityReservationPreference;
    }

    /**
     * <p>
     * Information about the targeted Capacity Reservation or Capacity Reservation group.
     * </p>
     * 
     * @return Information about the targeted Capacity Reservation or Capacity Reservation group.
     */
    public CapacityReservationTargetResponse capacityReservationTarget() {
        return capacityReservationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationTarget());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationSpecificationResponse)) {
            return false;
        }
        CapacityReservationSpecificationResponse other = (CapacityReservationSpecificationResponse) obj;
        return Objects.equals(capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString())
                && Objects.equals(capacityReservationTarget(), other.capacityReservationTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CapacityReservationSpecificationResponse")
                .add("CapacityReservationPreference", capacityReservationPreferenceAsString())
                .add("CapacityReservationTarget", capacityReservationTarget()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationPreference":
            return Optional.ofNullable(clazz.cast(capacityReservationPreferenceAsString()));
        case "CapacityReservationTarget":
            return Optional.ofNullable(clazz.cast(capacityReservationTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationSpecificationResponse, T> g) {
        return obj -> g.apply((CapacityReservationSpecificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationSpecificationResponse> {
        /**
         * <p>
         * Describes the instance's Capacity Reservation preferences. Possible preferences include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
         * attributes (instance type, platform, Availability Zone).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
         * instance runs in On-Demand capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has
         *        matching attributes (instance type, platform, Availability Zone).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available.
         *        The instance runs in On-Demand capacity.
         *        </p>
         *        </li>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(String capacityReservationPreference);

        /**
         * <p>
         * Describes the instance's Capacity Reservation preferences. Possible preferences include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
         * attributes (instance type, platform, Availability Zone).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
         * instance runs in On-Demand capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has
         *        matching attributes (instance type, platform, Availability Zone).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available.
         *        The instance runs in On-Demand capacity.
         *        </p>
         *        </li>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference);

        /**
         * <p>
         * Information about the targeted Capacity Reservation or Capacity Reservation group.
         * </p>
         * 
         * @param capacityReservationTarget
         *        Information about the targeted Capacity Reservation or Capacity Reservation group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationTarget(CapacityReservationTargetResponse capacityReservationTarget);

        /**
         * <p>
         * Information about the targeted Capacity Reservation or Capacity Reservation group.
         * </p>
         * This is a convenience that creates an instance of the {@link CapacityReservationTargetResponse.Builder}
         * avoiding the need to create one manually via {@link CapacityReservationTargetResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacityReservationTargetResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityReservationTarget(CapacityReservationTargetResponse)}
         * .
         * 
         * @param capacityReservationTarget
         *        a consumer that will call methods on {@link CapacityReservationTargetResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationTarget(CapacityReservationTargetResponse)
         */
        default Builder capacityReservationTarget(Consumer<CapacityReservationTargetResponse.Builder> capacityReservationTarget) {
            return capacityReservationTarget(CapacityReservationTargetResponse.builder().applyMutation(capacityReservationTarget)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationPreference;

        private CapacityReservationTargetResponse capacityReservationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationSpecificationResponse model) {
            capacityReservationPreference(model.capacityReservationPreference);
            capacityReservationTarget(model.capacityReservationTarget);
        }

        public final String getCapacityReservationPreference() {
            return capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference
                    .toString());
            return this;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        public final CapacityReservationTargetResponse.Builder getCapacityReservationTarget() {
            return capacityReservationTarget != null ? capacityReservationTarget.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationTarget(CapacityReservationTargetResponse capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget;
            return this;
        }

        public final void setCapacityReservationTarget(CapacityReservationTargetResponse.BuilderImpl capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget != null ? capacityReservationTarget.build() : null;
        }

        @Override
        public CapacityReservationSpecificationResponse build() {
            return new CapacityReservationSpecificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
