/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a running instance in a Spot Fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveInstance implements SdkPojo, Serializable, ToCopyableBuilder<ActiveInstance.Builder, ActiveInstance> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ActiveInstance::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ActiveInstance::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotInstanceRequestId")
            .getter(getter(ActiveInstance::spotInstanceRequestId))
            .setter(setter(Builder::spotInstanceRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId")
                    .unmarshallLocationName("spotInstanceRequestId").build()).build();

    private static final SdkField<String> INSTANCE_HEALTH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceHealth")
            .getter(getter(ActiveInstance::instanceHealthAsString))
            .setter(setter(Builder::instanceHealth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceHealth")
                    .unmarshallLocationName("instanceHealth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INSTANCE_TYPE_FIELD, SPOT_INSTANCE_REQUEST_ID_FIELD, INSTANCE_HEALTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String instanceType;

    private final String spotInstanceRequestId;

    private final String instanceHealth;

    private ActiveInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.instanceHealth = builder.instanceHealth;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the Spot Instance request.
     * </p>
     * 
     * @return The ID of the Spot Instance request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * The health status of the instance. If the status of either the instance status check or the system status check
     * is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the health
     * status is <code>healthy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceHealth}
     * will return {@link InstanceHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceHealthAsString}.
     * </p>
     * 
     * @return The health status of the instance. If the status of either the instance status check or the system status
     *         check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise,
     *         the health status is <code>healthy</code>.
     * @see InstanceHealthStatus
     */
    public InstanceHealthStatus instanceHealth() {
        return InstanceHealthStatus.fromValue(instanceHealth);
    }

    /**
     * <p>
     * The health status of the instance. If the status of either the instance status check or the system status check
     * is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the health
     * status is <code>healthy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceHealth}
     * will return {@link InstanceHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceHealthAsString}.
     * </p>
     * 
     * @return The health status of the instance. If the status of either the instance status check or the system status
     *         check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise,
     *         the health status is <code>healthy</code>.
     * @see InstanceHealthStatus
     */
    public String instanceHealthAsString() {
        return instanceHealth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceHealthAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveInstance)) {
            return false;
        }
        ActiveInstance other = (ActiveInstance) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(spotInstanceRequestId(), other.spotInstanceRequestId())
                && Objects.equals(instanceHealthAsString(), other.instanceHealthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActiveInstance").add("InstanceId", instanceId()).add("InstanceType", instanceType())
                .add("SpotInstanceRequestId", spotInstanceRequestId()).add("InstanceHealth", instanceHealthAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "SpotInstanceRequestId":
            return Optional.ofNullable(clazz.cast(spotInstanceRequestId()));
        case "InstanceHealth":
            return Optional.ofNullable(clazz.cast(instanceHealthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveInstance, T> g) {
        return obj -> g.apply((ActiveInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveInstance> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the Spot Instance request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        The ID of the Spot Instance request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * The health status of the instance. If the status of either the instance status check or the system status
         * check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the
         * health status is <code>healthy</code>.
         * </p>
         * 
         * @param instanceHealth
         *        The health status of the instance. If the status of either the instance status check or the system
         *        status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>.
         *        Otherwise, the health status is <code>healthy</code>.
         * @see InstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthStatus
         */
        Builder instanceHealth(String instanceHealth);

        /**
         * <p>
         * The health status of the instance. If the status of either the instance status check or the system status
         * check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the
         * health status is <code>healthy</code>.
         * </p>
         * 
         * @param instanceHealth
         *        The health status of the instance. If the status of either the instance status check or the system
         *        status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>.
         *        Otherwise, the health status is <code>healthy</code>.
         * @see InstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthStatus
         */
        Builder instanceHealth(InstanceHealthStatus instanceHealth);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String instanceType;

        private String spotInstanceRequestId;

        private String instanceHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveInstance model) {
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            spotInstanceRequestId(model.spotInstanceRequestId);
            instanceHealth(model.instanceHealth);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getInstanceHealth() {
            return instanceHealth;
        }

        @Override
        public final Builder instanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
            return this;
        }

        @Override
        public final Builder instanceHealth(InstanceHealthStatus instanceHealth) {
            this.instanceHealth(instanceHealth == null ? null : instanceHealth.toString());
            return this;
        }

        public final void setInstanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
        }

        @Override
        public ActiveInstance build() {
            return new ActiveInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
