/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceFamilyCreditSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceFamilyCreditSpecification> {
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(InstanceFamilyCreditSpecification.getter(InstanceFamilyCreditSpecification::instanceFamilyAsString)).setter(InstanceFamilyCreditSpecification.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("instanceFamily").build()}).build();
    private static final SdkField<String> CPU_CREDITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CpuCredits").getter(InstanceFamilyCreditSpecification.getter(InstanceFamilyCreditSpecification::cpuCredits)).setter(InstanceFamilyCreditSpecification.setter(Builder::cpuCredits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuCredits").unmarshallLocationName("cpuCredits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FAMILY_FIELD, CPU_CREDITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceFamily;
    private final String cpuCredits;

    private InstanceFamilyCreditSpecification(BuilderImpl builder) {
        this.instanceFamily = builder.instanceFamily;
        this.cpuCredits = builder.cpuCredits;
    }

    public UnlimitedSupportedInstanceFamily instanceFamily() {
        return UnlimitedSupportedInstanceFamily.fromValue(this.instanceFamily);
    }

    public String instanceFamilyAsString() {
        return this.instanceFamily;
    }

    public String cpuCredits() {
        return this.cpuCredits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCredits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFamilyCreditSpecification)) {
            return false;
        }
        InstanceFamilyCreditSpecification other = (InstanceFamilyCreditSpecification)obj;
        return Objects.equals(this.instanceFamilyAsString(), other.instanceFamilyAsString()) && Objects.equals(this.cpuCredits(), other.cpuCredits());
    }

    public String toString() {
        return ToString.builder((String)"InstanceFamilyCreditSpecification").add("InstanceFamily", (Object)this.instanceFamilyAsString()).add("CpuCredits", (Object)this.cpuCredits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamilyAsString()));
            }
            case "CpuCredits": {
                return Optional.ofNullable(clazz.cast(this.cpuCredits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFamilyCreditSpecification, T> g) {
        return obj -> g.apply((InstanceFamilyCreditSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceFamily;
        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFamilyCreditSpecification model) {
            this.instanceFamily(model.instanceFamily);
            this.cpuCredits(model.cpuCredits);
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public final Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily) {
            this.instanceFamily(instanceFamily == null ? null : instanceFamily.toString());
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getCpuCredits() {
            return this.cpuCredits;
        }

        @Override
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        public InstanceFamilyCreditSpecification build() {
            return new InstanceFamilyCreditSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceFamilyCreditSpecification> {
        public Builder instanceFamily(String var1);

        public Builder instanceFamily(UnlimitedSupportedInstanceFamily var1);

        public Builder cpuCredits(String var1);
    }
}

