/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInterfacePermissionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeNetworkInterfacePermissionsResponse> {
    private static final SdkField<List<NetworkInterfacePermission>> NETWORK_INTERFACE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfacePermissions").getter(DescribeNetworkInterfacePermissionsResponse.getter(DescribeNetworkInterfacePermissionsResponse::networkInterfacePermissions)).setter(DescribeNetworkInterfacePermissionsResponse.setter(Builder::networkInterfacePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePermissions").unmarshallLocationName("networkInterfacePermissions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterfacePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNetworkInterfacePermissionsResponse.getter(DescribeNetworkInterfacePermissionsResponse::nextToken)).setter(DescribeNetworkInterfacePermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<NetworkInterfacePermission> networkInterfacePermissions;
    private final String nextToken;

    private DescribeNetworkInterfacePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfacePermissions = builder.networkInterfacePermissions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasNetworkInterfacePermissions() {
        return this.networkInterfacePermissions != null && !(this.networkInterfacePermissions instanceof SdkAutoConstructList);
    }

    public List<NetworkInterfacePermission> networkInterfacePermissions() {
        return this.networkInterfacePermissions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfacePermissions() ? this.networkInterfacePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacePermissionsResponse)) {
            return false;
        }
        DescribeNetworkInterfacePermissionsResponse other = (DescribeNetworkInterfacePermissionsResponse)((Object)obj);
        return this.hasNetworkInterfacePermissions() == other.hasNetworkInterfacePermissions() && Objects.equals(this.networkInterfacePermissions(), other.networkInterfacePermissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNetworkInterfacePermissionsResponse").add("NetworkInterfacePermissions", this.hasNetworkInterfacePermissions() ? this.networkInterfacePermissions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfacePermissions": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacePermissions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInterfacePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeNetworkInterfacePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<NetworkInterfacePermission> networkInterfacePermissions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacePermissionsResponse model) {
            super(model);
            this.networkInterfacePermissions(model.networkInterfacePermissions);
            this.nextToken(model.nextToken);
        }

        public final Collection<NetworkInterfacePermission.Builder> getNetworkInterfacePermissions() {
            if (this.networkInterfacePermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfacePermissions != null ? (Collection)this.networkInterfacePermissions.stream().map(NetworkInterfacePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copy(networkInterfacePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissions(NetworkInterfacePermission ... networkInterfacePermissions) {
            this.networkInterfacePermissions(Arrays.asList(networkInterfacePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissions(Consumer<NetworkInterfacePermission.Builder> ... networkInterfacePermissions) {
            this.networkInterfacePermissions(Stream.of(networkInterfacePermissions).map(c -> (NetworkInterfacePermission)((NetworkInterfacePermission.Builder)NetworkInterfacePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfacePermissions(Collection<NetworkInterfacePermission.BuilderImpl> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copyFromBuilder(networkInterfacePermissions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNetworkInterfacePermissionsResponse build() {
            return new DescribeNetworkInterfacePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInterfacePermissionsResponse> {
        public Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> var1);

        public Builder networkInterfacePermissions(NetworkInterfacePermission ... var1);

        public Builder networkInterfacePermissions(Consumer<NetworkInterfacePermission.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

