/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateVersion.Builder, LaunchTemplateVersion> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchTemplateVersion::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId")
                    .unmarshallLocationName("launchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchTemplateVersion::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("launchTemplateName").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(LaunchTemplateVersion::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber")
                    .unmarshallLocationName("versionNumber").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchTemplateVersion::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription")
                    .unmarshallLocationName("versionDescription").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LaunchTemplateVersion::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchTemplateVersion::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy")
                    .unmarshallLocationName("createdBy").build()).build();

    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LaunchTemplateVersion::defaultVersion))
            .setter(setter(Builder::defaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersion")
                    .unmarshallLocationName("defaultVersion").build()).build();

    private static final SdkField<ResponseLaunchTemplateData> LAUNCH_TEMPLATE_DATA_FIELD = SdkField
            .<ResponseLaunchTemplateData> builder(MarshallingType.SDK_POJO)
            .getter(getter(LaunchTemplateVersion::launchTemplateData))
            .setter(setter(Builder::launchTemplateData))
            .constructor(ResponseLaunchTemplateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData")
                    .unmarshallLocationName("launchTemplateData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, VERSION_NUMBER_FIELD, VERSION_DESCRIPTION_FIELD, CREATE_TIME_FIELD, CREATED_BY_FIELD,
            DEFAULT_VERSION_FIELD, LAUNCH_TEMPLATE_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final Long versionNumber;

    private final String versionDescription;

    private final Instant createTime;

    private final String createdBy;

    private final Boolean defaultVersion;

    private final ResponseLaunchTemplateData launchTemplateData;

    private LaunchTemplateVersion(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.versionNumber = builder.versionNumber;
        this.versionDescription = builder.versionDescription;
        this.createTime = builder.createTime;
        this.createdBy = builder.createdBy;
        this.defaultVersion = builder.defaultVersion;
        this.launchTemplateData = builder.launchTemplateData;
    }

    /**
     * <p>
     * The ID of the launch template.
     * </p>
     * 
     * @return The ID of the launch template.
     */
    public String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template.
     * </p>
     * 
     * @return The name of the launch template.
     */
    public String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The description for the version.
     * </p>
     * 
     * @return The description for the version.
     */
    public String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The time the version was created.
     * </p>
     * 
     * @return The time the version was created.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The principal that created the version.
     * </p>
     * 
     * @return The principal that created the version.
     */
    public String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Indicates whether the version is the default version.
     * </p>
     * 
     * @return Indicates whether the version is the default version.
     */
    public Boolean defaultVersion() {
        return defaultVersion;
    }

    /**
     * <p>
     * Information about the launch template.
     * </p>
     * 
     * @return Information about the launch template.
     */
    public ResponseLaunchTemplateData launchTemplateData() {
        return launchTemplateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateVersion)) {
            return false;
        }
        LaunchTemplateVersion other = (LaunchTemplateVersion) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(defaultVersion(), other.defaultVersion())
                && Objects.equals(launchTemplateData(), other.launchTemplateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LaunchTemplateVersion").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("VersionNumber", versionNumber())
                .add("VersionDescription", versionDescription()).add("CreateTime", createTime()).add("CreatedBy", createdBy())
                .add("DefaultVersion", defaultVersion()).add("LaunchTemplateData", launchTemplateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "DefaultVersion":
            return Optional.ofNullable(clazz.cast(defaultVersion()));
        case "LaunchTemplateData":
            return Optional.ofNullable(clazz.cast(launchTemplateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateVersion, T> g) {
        return obj -> g.apply((LaunchTemplateVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateVersion> {
        /**
         * <p>
         * The ID of the launch template.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param versionNumber
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The description for the version.
         * </p>
         * 
         * @param versionDescription
         *        The description for the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The time the version was created.
         * </p>
         * 
         * @param createTime
         *        The time the version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The principal that created the version.
         * </p>
         * 
         * @param createdBy
         *        The principal that created the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Indicates whether the version is the default version.
         * </p>
         * 
         * @param defaultVersion
         *        Indicates whether the version is the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(Boolean defaultVersion);

        /**
         * <p>
         * Information about the launch template.
         * </p>
         * 
         * @param launchTemplateData
         *        Information about the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateData(ResponseLaunchTemplateData launchTemplateData);

        /**
         * <p>
         * Information about the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link ResponseLaunchTemplateData.Builder} avoiding the
         * need to create one manually via {@link ResponseLaunchTemplateData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseLaunchTemplateData.Builder#build()} is called immediately
         * and its result is passed to {@link #launchTemplateData(ResponseLaunchTemplateData)}.
         * 
         * @param launchTemplateData
         *        a consumer that will call methods on {@link ResponseLaunchTemplateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateData(ResponseLaunchTemplateData)
         */
        default Builder launchTemplateData(Consumer<ResponseLaunchTemplateData.Builder> launchTemplateData) {
            return launchTemplateData(ResponseLaunchTemplateData.builder().applyMutation(launchTemplateData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private Long versionNumber;

        private String versionDescription;

        private Instant createTime;

        private String createdBy;

        private Boolean defaultVersion;

        private ResponseLaunchTemplateData launchTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateVersion model) {
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            versionNumber(model.versionNumber);
            versionDescription(model.versionDescription);
            createTime(model.createTime);
            createdBy(model.createdBy);
            defaultVersion(model.defaultVersion);
            launchTemplateData(model.launchTemplateData);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Boolean getDefaultVersion() {
            return defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public final ResponseLaunchTemplateData.Builder getLaunchTemplateData() {
            return launchTemplateData != null ? launchTemplateData.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateData(ResponseLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final void setLaunchTemplateData(ResponseLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public LaunchTemplateVersion build() {
            return new LaunchTemplateVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
