/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFpgaImageRequest extends Ec2Request implements
        ToCopyableBuilder<CreateFpgaImageRequest.Builder, CreateFpgaImageRequest> {
    private static final SdkField<StorageLocation> INPUT_STORAGE_LOCATION_FIELD = SdkField
            .<StorageLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFpgaImageRequest::inputStorageLocation))
            .setter(setter(Builder::inputStorageLocation))
            .constructor(StorageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputStorageLocation")
                    .unmarshallLocationName("InputStorageLocation").build()).build();

    private static final SdkField<StorageLocation> LOGS_STORAGE_LOCATION_FIELD = SdkField
            .<StorageLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFpgaImageRequest::logsStorageLocation))
            .setter(setter(Builder::logsStorageLocation))
            .constructor(StorageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsStorageLocation")
                    .unmarshallLocationName("LogsStorageLocation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFpgaImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFpgaImageRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFpgaImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateFpgaImageRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_STORAGE_LOCATION_FIELD,
            LOGS_STORAGE_LOCATION_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CLIENT_TOKEN_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final StorageLocation inputStorageLocation;

    private final StorageLocation logsStorageLocation;

    private final String description;

    private final String name;

    private final String clientToken;

    private final List<TagSpecification> tagSpecifications;

    private CreateFpgaImageRequest(BuilderImpl builder) {
        super(builder);
        this.inputStorageLocation = builder.inputStorageLocation;
        this.logsStorageLocation = builder.logsStorageLocation;
        this.description = builder.description;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
     * </p>
     * 
     * @return The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
     */
    public StorageLocation inputStorageLocation() {
        return inputStorageLocation;
    }

    /**
     * <p>
     * The location in Amazon S3 for the output logs.
     * </p>
     * 
     * @return The location in Amazon S3 for the output logs.
     */
    public StorageLocation logsStorageLocation() {
        return logsStorageLocation;
    }

    /**
     * <p>
     * A description for the AFI.
     * </p>
     * 
     * @return A description for the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A name for the AFI.
     * </p>
     * 
     * @return A name for the AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the FPGA image during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply to the FPGA image during creation.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(logsStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFpgaImageRequest)) {
            return false;
        }
        CreateFpgaImageRequest other = (CreateFpgaImageRequest) obj;
        return Objects.equals(inputStorageLocation(), other.inputStorageLocation())
                && Objects.equals(logsStorageLocation(), other.logsStorageLocation())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFpgaImageRequest").add("InputStorageLocation", inputStorageLocation())
                .add("LogsStorageLocation", logsStorageLocation()).add("Description", description()).add("Name", name())
                .add("ClientToken", clientToken()).add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputStorageLocation":
            return Optional.ofNullable(clazz.cast(inputStorageLocation()));
        case "LogsStorageLocation":
            return Optional.ofNullable(clazz.cast(logsStorageLocation()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFpgaImageRequest, T> g) {
        return obj -> g.apply((CreateFpgaImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateFpgaImageRequest> {
        /**
         * <p>
         * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * </p>
         * 
         * @param inputStorageLocation
         *        The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStorageLocation(StorageLocation inputStorageLocation);

        /**
         * <p>
         * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageLocation.Builder} avoiding the need to
         * create one manually via {@link StorageLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #inputStorageLocation(StorageLocation)}.
         * 
         * @param inputStorageLocation
         *        a consumer that will call methods on {@link StorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputStorageLocation(StorageLocation)
         */
        default Builder inputStorageLocation(Consumer<StorageLocation.Builder> inputStorageLocation) {
            return inputStorageLocation(StorageLocation.builder().applyMutation(inputStorageLocation).build());
        }

        /**
         * <p>
         * The location in Amazon S3 for the output logs.
         * </p>
         * 
         * @param logsStorageLocation
         *        The location in Amazon S3 for the output logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsStorageLocation(StorageLocation logsStorageLocation);

        /**
         * <p>
         * The location in Amazon S3 for the output logs.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageLocation.Builder} avoiding the need to
         * create one manually via {@link StorageLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #logsStorageLocation(StorageLocation)}.
         * 
         * @param logsStorageLocation
         *        a consumer that will call methods on {@link StorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsStorageLocation(StorageLocation)
         */
        default Builder logsStorageLocation(Consumer<StorageLocation.Builder> logsStorageLocation) {
            return logsStorageLocation(StorageLocation.builder().applyMutation(logsStorageLocation).build());
        }

        /**
         * <p>
         * A description for the AFI.
         * </p>
         * 
         * @param description
         *        A description for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the AFI.
         * </p>
         * 
         * @param name
         *        A name for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to apply to the FPGA image during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the FPGA image during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the FPGA image during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the FPGA image during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the FPGA image during creation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private StorageLocation inputStorageLocation;

        private StorageLocation logsStorageLocation;

        private String description;

        private String name;

        private String clientToken;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFpgaImageRequest model) {
            super(model);
            inputStorageLocation(model.inputStorageLocation);
            logsStorageLocation(model.logsStorageLocation);
            description(model.description);
            name(model.name);
            clientToken(model.clientToken);
            tagSpecifications(model.tagSpecifications);
        }

        public final StorageLocation.Builder getInputStorageLocation() {
            return inputStorageLocation != null ? inputStorageLocation.toBuilder() : null;
        }

        @Override
        public final Builder inputStorageLocation(StorageLocation inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation;
            return this;
        }

        public final void setInputStorageLocation(StorageLocation.BuilderImpl inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation != null ? inputStorageLocation.build() : null;
        }

        public final StorageLocation.Builder getLogsStorageLocation() {
            return logsStorageLocation != null ? logsStorageLocation.toBuilder() : null;
        }

        @Override
        public final Builder logsStorageLocation(StorageLocation logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation;
            return this;
        }

        public final void setLogsStorageLocation(StorageLocation.BuilderImpl logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation != null ? logsStorageLocation.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFpgaImageRequest build() {
            return new CreateFpgaImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
