/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcTenancyRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcTenancyRequest.Builder, ModifyVpcTenancyRequest> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpcTenancyRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpcTenancyRequest::instanceTenancyAsString))
            .setter(setter(Builder::instanceTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy")
                    .unmarshallLocationName("InstanceTenancy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            INSTANCE_TENANCY_FIELD));

    private final String vpcId;

    private final String instanceTenancy;

    private ModifyVpcTenancyRequest(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.instanceTenancy = builder.instanceTenancy;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The instance tenancy attribute for the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link VpcTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The instance tenancy attribute for the VPC.
     * @see VpcTenancy
     */
    public VpcTenancy instanceTenancy() {
        return VpcTenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The instance tenancy attribute for the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link VpcTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The instance tenancy attribute for the VPC.
     * @see VpcTenancy
     */
    public String instanceTenancyAsString() {
        return instanceTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcTenancyRequest)) {
            return false;
        }
        ModifyVpcTenancyRequest other = (ModifyVpcTenancyRequest) obj;
        return Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(instanceTenancyAsString(), other.instanceTenancyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyVpcTenancyRequest").add("VpcId", vpcId())
                .add("InstanceTenancy", instanceTenancyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "InstanceTenancy":
            return Optional.ofNullable(clazz.cast(instanceTenancyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcTenancyRequest, T> g) {
        return obj -> g.apply((ModifyVpcTenancyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpcTenancyRequest> {
        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The instance tenancy attribute for the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The instance tenancy attribute for the VPC.
         * @see VpcTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcTenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The instance tenancy attribute for the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The instance tenancy attribute for the VPC.
         * @see VpcTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcTenancy
         */
        Builder instanceTenancy(VpcTenancy instanceTenancy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpcId;

        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcTenancyRequest model) {
            super(model);
            vpcId(model.vpcId);
            instanceTenancy(model.instanceTenancy);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(VpcTenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcTenancyRequest build() {
            return new ModifyVpcTenancyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
