/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the disk container object for an import image task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageDiskContainer implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageDiskContainer.Builder, ImageDiskContainer> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImageDiskContainer::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImageDiskContainer::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName")
                    .unmarshallLocationName("DeviceName").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImageDiskContainer::format))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("Format").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImageDiskContainer::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImageDiskContainer::url))
            .setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").unmarshallLocationName("Url")
                    .build()).build();

    private static final SdkField<UserBucket> USER_BUCKET_FIELD = SdkField
            .<UserBucket> builder(MarshallingType.SDK_POJO)
            .getter(getter(ImageDiskContainer::userBucket))
            .setter(setter(Builder::userBucket))
            .constructor(UserBucket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBucket")
                    .unmarshallLocationName("UserBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DEVICE_NAME_FIELD, FORMAT_FIELD, SNAPSHOT_ID_FIELD, URL_FIELD, USER_BUCKET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String deviceName;

    private final String format;

    private final String snapshotId;

    private final String url;

    private final UserBucket userBucket;

    private ImageDiskContainer(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.format = builder.format;
        this.snapshotId = builder.snapshotId;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    /**
     * <p>
     * The description of the disk image.
     * </p>
     * 
     * @return The description of the disk image.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The block device mapping for the disk.
     * </p>
     * 
     * @return The block device mapping for the disk.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The format of the disk image being imported.
     * </p>
     * <p>
     * Valid values: <code>OVA</code> | <code>VHD</code> | <code>VHDX</code> |<code>VMDK</code>
     * </p>
     * 
     * @return The format of the disk image being imported.</p>
     *         <p>
     *         Valid values: <code>OVA</code> | <code>VHD</code> | <code>VHDX</code> |<code>VMDK</code>
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The ID of the EBS snapshot to be used for importing the snapshot.
     * </p>
     * 
     * @return The ID of the EBS snapshot to be used for importing the snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an
     * Amazon S3 URL (s3://..)
     * </p>
     * 
     * @return The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..)
     *         or an Amazon S3 URL (s3://..)
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The S3 bucket for the disk image.
     * </p>
     * 
     * @return The S3 bucket for the disk image.
     */
    public UserBucket userBucket() {
        return userBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(userBucket());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDiskContainer)) {
            return false;
        }
        ImageDiskContainer other = (ImageDiskContainer) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(format(), other.format()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(url(), other.url()) && Objects.equals(userBucket(), other.userBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImageDiskContainer").add("Description", description()).add("DeviceName", deviceName())
                .add("Format", format()).add("SnapshotId", snapshotId()).add("Url", url()).add("UserBucket", userBucket())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "UserBucket":
            return Optional.ofNullable(clazz.cast(userBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageDiskContainer, T> g) {
        return obj -> g.apply((ImageDiskContainer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageDiskContainer> {
        /**
         * <p>
         * The description of the disk image.
         * </p>
         * 
         * @param description
         *        The description of the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The block device mapping for the disk.
         * </p>
         * 
         * @param deviceName
         *        The block device mapping for the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The format of the disk image being imported.
         * </p>
         * <p>
         * Valid values: <code>OVA</code> | <code>VHD</code> | <code>VHDX</code> |<code>VMDK</code>
         * </p>
         * 
         * @param format
         *        The format of the disk image being imported.</p>
         *        <p>
         *        Valid values: <code>OVA</code> | <code>VHD</code> | <code>VHDX</code> |<code>VMDK</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The ID of the EBS snapshot to be used for importing the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the EBS snapshot to be used for importing the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or
         * an Amazon S3 URL (s3://..)
         * </p>
         * 
         * @param url
         *        The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL
         *        (https://..) or an Amazon S3 URL (s3://..)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * 
         * @param userBucket
         *        The S3 bucket for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBucket(UserBucket userBucket);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * This is a convenience that creates an instance of the {@link UserBucket.Builder} avoiding the need to create
         * one manually via {@link UserBucket#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserBucket.Builder#build()} is called immediately and its result
         * is passed to {@link #userBucket(UserBucket)}.
         * 
         * @param userBucket
         *        a consumer that will call methods on {@link UserBucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userBucket(UserBucket)
         */
        default Builder userBucket(Consumer<UserBucket.Builder> userBucket) {
            return userBucket(UserBucket.builder().applyMutation(userBucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String deviceName;

        private String format;

        private String snapshotId;

        private String url;

        private UserBucket userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDiskContainer model) {
            description(model.description);
            deviceName(model.deviceName);
            format(model.format);
            snapshotId(model.snapshotId);
            url(model.url);
            userBucket(model.userBucket);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucket.Builder getUserBucket() {
            return userBucket != null ? userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucket.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        @Override
        public ImageDiskContainer build() {
            return new ImageDiskContainer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
