/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySubnetAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifySubnetAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::assignIpv6AddressOnCreation)).setter(ModifySubnetAttributeRequest.setter(Builder::assignIpv6AddressOnCreation)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignIpv6AddressOnCreation").unmarshallLocationName("AssignIpv6AddressOnCreation").build()}).build();
    private static final SdkField<AttributeBooleanValue> MAP_PUBLIC_IP_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::mapPublicIpOnLaunch)).setter(ModifySubnetAttributeRequest.setter(Builder::mapPublicIpOnLaunch)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapPublicIpOnLaunch").unmarshallLocationName("MapPublicIpOnLaunch").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::subnetId)).setter(ModifySubnetAttributeRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<AttributeBooleanValue> MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::mapCustomerOwnedIpOnLaunch)).setter(ModifySubnetAttributeRequest.setter(Builder::mapCustomerOwnedIpOnLaunch)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapCustomerOwnedIpOnLaunch").unmarshallLocationName("MapCustomerOwnedIpOnLaunch").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifySubnetAttributeRequest.getter(ModifySubnetAttributeRequest::customerOwnedIpv4Pool)).setter(ModifySubnetAttributeRequest.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").unmarshallLocationName("CustomerOwnedIpv4Pool").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD, MAP_PUBLIC_IP_ON_LAUNCH_FIELD, SUBNET_ID_FIELD, MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD));
    private final AttributeBooleanValue assignIpv6AddressOnCreation;
    private final AttributeBooleanValue mapPublicIpOnLaunch;
    private final String subnetId;
    private final AttributeBooleanValue mapCustomerOwnedIpOnLaunch;
    private final String customerOwnedIpv4Pool;

    private ModifySubnetAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.subnetId = builder.subnetId;
        this.mapCustomerOwnedIpOnLaunch = builder.mapCustomerOwnedIpOnLaunch;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
    }

    public AttributeBooleanValue assignIpv6AddressOnCreation() {
        return this.assignIpv6AddressOnCreation;
    }

    public AttributeBooleanValue mapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public AttributeBooleanValue mapCustomerOwnedIpOnLaunch() {
        return this.mapCustomerOwnedIpOnLaunch;
    }

    public String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapCustomerOwnedIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySubnetAttributeRequest)) {
            return false;
        }
        ModifySubnetAttributeRequest other = (ModifySubnetAttributeRequest)((Object)obj);
        return Objects.equals(this.assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation()) && Objects.equals(this.mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.mapCustomerOwnedIpOnLaunch(), other.mapCustomerOwnedIpOnLaunch()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool());
    }

    public String toString() {
        return ToString.builder((String)"ModifySubnetAttributeRequest").add("AssignIpv6AddressOnCreation", (Object)this.assignIpv6AddressOnCreation()).add("MapPublicIpOnLaunch", (Object)this.mapPublicIpOnLaunch()).add("SubnetId", (Object)this.subnetId()).add("MapCustomerOwnedIpOnLaunch", (Object)this.mapCustomerOwnedIpOnLaunch()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignIpv6AddressOnCreation": {
                return Optional.ofNullable(clazz.cast(this.assignIpv6AddressOnCreation()));
            }
            case "MapPublicIpOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.mapPublicIpOnLaunch()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "MapCustomerOwnedIpOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.mapCustomerOwnedIpOnLaunch()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySubnetAttributeRequest, T> g) {
        return obj -> g.apply((ModifySubnetAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private AttributeBooleanValue assignIpv6AddressOnCreation;
        private AttributeBooleanValue mapPublicIpOnLaunch;
        private String subnetId;
        private AttributeBooleanValue mapCustomerOwnedIpOnLaunch;
        private String customerOwnedIpv4Pool;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySubnetAttributeRequest model) {
            super(model);
            this.assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            this.mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            this.subnetId(model.subnetId);
            this.mapCustomerOwnedIpOnLaunch(model.mapCustomerOwnedIpOnLaunch);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
        }

        public final AttributeBooleanValue.Builder getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation != null ? this.assignIpv6AddressOnCreation.toBuilder() : null;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(AttributeBooleanValue assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(AttributeBooleanValue.BuilderImpl assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation != null ? assignIpv6AddressOnCreation.build() : null;
        }

        public final AttributeBooleanValue.Builder getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.toBuilder() : null;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(AttributeBooleanValue mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(AttributeBooleanValue.BuilderImpl mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch != null ? mapPublicIpOnLaunch.build() : null;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final AttributeBooleanValue.Builder getMapCustomerOwnedIpOnLaunch() {
            return this.mapCustomerOwnedIpOnLaunch != null ? this.mapCustomerOwnedIpOnLaunch.toBuilder() : null;
        }

        @Override
        public final Builder mapCustomerOwnedIpOnLaunch(AttributeBooleanValue mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch;
            return this;
        }

        public final void setMapCustomerOwnedIpOnLaunch(AttributeBooleanValue.BuilderImpl mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch != null ? mapCustomerOwnedIpOnLaunch.build() : null;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySubnetAttributeRequest build() {
            return new ModifySubnetAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySubnetAttributeRequest> {
        public Builder assignIpv6AddressOnCreation(AttributeBooleanValue var1);

        default public Builder assignIpv6AddressOnCreation(Consumer<AttributeBooleanValue.Builder> assignIpv6AddressOnCreation) {
            return this.assignIpv6AddressOnCreation((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(assignIpv6AddressOnCreation)).build());
        }

        public Builder mapPublicIpOnLaunch(AttributeBooleanValue var1);

        default public Builder mapPublicIpOnLaunch(Consumer<AttributeBooleanValue.Builder> mapPublicIpOnLaunch) {
            return this.mapPublicIpOnLaunch((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(mapPublicIpOnLaunch)).build());
        }

        public Builder subnetId(String var1);

        public Builder mapCustomerOwnedIpOnLaunch(AttributeBooleanValue var1);

        default public Builder mapCustomerOwnedIpOnLaunch(Consumer<AttributeBooleanValue.Builder> mapCustomerOwnedIpOnLaunch) {
            return this.mapCustomerOwnedIpOnLaunch((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(mapCustomerOwnedIpOnLaunch)).build());
        }

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

