/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySpotFleetRequestRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifySpotFleetRequestRequest> {
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::excessCapacityTerminationPolicyAsString)).setter(ModifySpotFleetRequestRequest.setter(Builder::excessCapacityTerminationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy").unmarshallLocationName("excessCapacityTerminationPolicy").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::spotFleetRequestId)).setter(ModifySpotFleetRequestRequest.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::targetCapacity)).setter(ModifySpotFleetRequestRequest.setter(Builder::targetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity").unmarshallLocationName("targetCapacity").build()}).build();
    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::onDemandTargetCapacity)).setter(ModifySpotFleetRequestRequest.setter(Builder::onDemandTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity").unmarshallLocationName("OnDemandTargetCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, SPOT_FLEET_REQUEST_ID_FIELD, TARGET_CAPACITY_FIELD, ON_DEMAND_TARGET_CAPACITY_FIELD));
    private final String excessCapacityTerminationPolicy;
    private final String spotFleetRequestId;
    private final Integer targetCapacity;
    private final Integer onDemandTargetCapacity;

    private ModifySpotFleetRequestRequest(BuilderImpl builder) {
        super(builder);
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.targetCapacity = builder.targetCapacity;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
    }

    public ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Integer targetCapacity() {
        return this.targetCapacity;
    }

    public Integer onDemandTargetCapacity() {
        return this.onDemandTargetCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandTargetCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySpotFleetRequestRequest)) {
            return false;
        }
        ModifySpotFleetRequestRequest other = (ModifySpotFleetRequestRequest)((Object)obj);
        return Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId()) && Objects.equals(this.targetCapacity(), other.targetCapacity()) && Objects.equals(this.onDemandTargetCapacity(), other.onDemandTargetCapacity());
    }

    public String toString() {
        return ToString.builder((String)"ModifySpotFleetRequestRequest").add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).add("TargetCapacity", (Object)this.targetCapacity()).add("OnDemandTargetCapacity", (Object)this.onDemandTargetCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
            case "TargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetCapacity()));
            }
            case "OnDemandTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.onDemandTargetCapacity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySpotFleetRequestRequest, T> g) {
        return obj -> g.apply((ModifySpotFleetRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String excessCapacityTerminationPolicy;
        private String spotFleetRequestId;
        private Integer targetCapacity;
        private Integer onDemandTargetCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySpotFleetRequestRequest model) {
            super(model);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.targetCapacity(model.targetCapacity);
            this.onDemandTargetCapacity(model.onDemandTargetCapacity);
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final Integer getTargetCapacity() {
            return this.targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        public final Integer getOnDemandTargetCapacity() {
            return this.onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySpotFleetRequestRequest build() {
            return new ModifySpotFleetRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySpotFleetRequestRequest> {
        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy var1);

        public Builder spotFleetRequestId(String var1);

        public Builder targetCapacity(Integer var1);

        public Builder onDemandTargetCapacity(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

