/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.OperationType;
import software.amazon.awssdk.services.ec2.model.SnapshotAttributeName;
import software.amazon.awssdk.services.ec2.model.UserIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySnapshotAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifySnapshotAttributeRequest.getter(ModifySnapshotAttributeRequest::attributeAsString)).setter(ModifySnapshotAttributeRequest.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").unmarshallLocationName("Attribute").build()}).build();
    private static final SdkField<CreateVolumePermissionModifications> CREATE_VOLUME_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifySnapshotAttributeRequest.getter(ModifySnapshotAttributeRequest::createVolumePermission)).setter(ModifySnapshotAttributeRequest.setter(Builder::createVolumePermission)).constructor(CreateVolumePermissionModifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateVolumePermission").unmarshallLocationName("CreateVolumePermission").build()}).build();
    private static final SdkField<List<String>> GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifySnapshotAttributeRequest.getter(ModifySnapshotAttributeRequest::groupNames)).setter(ModifySnapshotAttributeRequest.setter(Builder::groupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").unmarshallLocationName("UserGroup").build(), ListTrait.builder().memberLocationName("GroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("GroupName").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifySnapshotAttributeRequest.getter(ModifySnapshotAttributeRequest::operationTypeAsString)).setter(ModifySnapshotAttributeRequest.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType").unmarshallLocationName("OperationType").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifySnapshotAttributeRequest.getter(ModifySnapshotAttributeRequest::snapshotId)).setter(ModifySnapshotAttributeRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build();
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifySnapshotAttributeRequest.getter(ModifySnapshotAttributeRequest::userIds)).setter(ModifySnapshotAttributeRequest.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("UserId").build(), ListTrait.builder().memberLocationName("UserId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("UserId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, CREATE_VOLUME_PERMISSION_FIELD, GROUP_NAMES_FIELD, OPERATION_TYPE_FIELD, SNAPSHOT_ID_FIELD, USER_IDS_FIELD));
    private final String attribute;
    private final CreateVolumePermissionModifications createVolumePermission;
    private final List<String> groupNames;
    private final String operationType;
    private final String snapshotId;
    private final List<String> userIds;

    private ModifySnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.createVolumePermission = builder.createVolumePermission;
        this.groupNames = builder.groupNames;
        this.operationType = builder.operationType;
        this.snapshotId = builder.snapshotId;
        this.userIds = builder.userIds;
    }

    public SnapshotAttributeName attribute() {
        return SnapshotAttributeName.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    public CreateVolumePermissionModifications createVolumePermission() {
        return this.createVolumePermission;
    }

    public boolean hasGroupNames() {
        return this.groupNames != null && !(this.groupNames instanceof SdkAutoConstructList);
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public String operationTypeAsString() {
        return this.operationType;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public List<String> userIds() {
        return this.userIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createVolumePermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotAttributeRequest)) {
            return false;
        }
        ModifySnapshotAttributeRequest other = (ModifySnapshotAttributeRequest)((Object)obj);
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.createVolumePermission(), other.createVolumePermission()) && Objects.equals(this.groupNames(), other.groupNames()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.userIds(), other.userIds());
    }

    public String toString() {
        return ToString.builder((String)"ModifySnapshotAttributeRequest").add("Attribute", (Object)this.attributeAsString()).add("CreateVolumePermission", (Object)this.createVolumePermission()).add("GroupNames", this.groupNames()).add("OperationType", (Object)this.operationTypeAsString()).add("SnapshotId", (Object)this.snapshotId()).add("UserIds", this.userIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "CreateVolumePermission": {
                return Optional.ofNullable(clazz.cast(this.createVolumePermission()));
            }
            case "GroupNames": {
                return Optional.ofNullable(clazz.cast(this.groupNames()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotAttributeRequest, T> g) {
        return obj -> g.apply((ModifySnapshotAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String attribute;
        private CreateVolumePermissionModifications createVolumePermission;
        private List<String> groupNames = DefaultSdkAutoConstructList.getInstance();
        private String operationType;
        private String snapshotId;
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotAttributeRequest model) {
            super(model);
            this.attribute(model.attribute);
            this.createVolumePermission(model.createVolumePermission);
            this.groupNames(model.groupNames);
            this.operationType(model.operationType);
            this.snapshotId(model.snapshotId);
            this.userIds(model.userIds);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final CreateVolumePermissionModifications.Builder getCreateVolumePermission() {
            return this.createVolumePermission != null ? this.createVolumePermission.toBuilder() : null;
        }

        @Override
        public final Builder createVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
            this.createVolumePermission = createVolumePermission;
            return this;
        }

        public final void setCreateVolumePermission(CreateVolumePermissionModifications.BuilderImpl createVolumePermission) {
            this.createVolumePermission = createVolumePermission != null ? createVolumePermission.build() : null;
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Collection<String> getUserIds() {
            return this.userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotAttributeRequest build() {
            return new ModifySnapshotAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(SnapshotAttributeName var1);

        public Builder createVolumePermission(CreateVolumePermissionModifications var1);

        default public Builder createVolumePermission(Consumer<CreateVolumePermissionModifications.Builder> createVolumePermission) {
            return this.createVolumePermission((CreateVolumePermissionModifications)((CreateVolumePermissionModifications.Builder)CreateVolumePermissionModifications.builder().applyMutation(createVolumePermission)).build());
        }

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder snapshotId(String var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

