/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopySnapshotRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::description)).setter(CopySnapshotRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::destinationRegion)).setter(CopySnapshotRequest.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").unmarshallLocationName("destinationRegion").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CopySnapshotRequest.getter(CopySnapshotRequest::encrypted)).setter(CopySnapshotRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::kmsKeyId)).setter(CopySnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("kmsKeyId").build()}).build();
    private static final SdkField<String> PRESIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::presignedUrl)).setter(CopySnapshotRequest.setter(Builder::presignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresignedUrl").unmarshallLocationName("presignedUrl").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceRegion)).setter(CopySnapshotRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").unmarshallLocationName("SourceRegion").build()}).build();
    private static final SdkField<String> SOURCE_SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceSnapshotId)).setter(CopySnapshotRequest.setter(Builder::sourceSnapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotId").unmarshallLocationName("SourceSnapshotId").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CopySnapshotRequest.getter(CopySnapshotRequest::tagSpecifications)).setter(CopySnapshotRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DESTINATION_REGION_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, PRESIGNED_URL_FIELD, SOURCE_REGION_FIELD, SOURCE_SNAPSHOT_ID_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String description;
    private final String destinationRegion;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String presignedUrl;
    private final String sourceRegion;
    private final String sourceSnapshotId;
    private final List<TagSpecification> tagSpecifications;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.destinationRegion = builder.destinationRegion;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.presignedUrl = builder.presignedUrl;
        this.sourceRegion = builder.sourceRegion;
        this.sourceSnapshotId = builder.sourceSnapshotId;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public String description() {
        return this.description;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String presignedUrl() {
        return this.presignedUrl;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.presignedUrl(), other.presignedUrl()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceSnapshotId(), other.sourceSnapshotId()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"CopySnapshotRequest").add("Description", (Object)this.description()).add("DestinationRegion", (Object)this.destinationRegion()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PresignedUrl", (Object)this.presignedUrl()).add("SourceRegion", (Object)this.sourceRegion()).add("SourceSnapshotId", (Object)this.sourceSnapshotId()).add("TagSpecifications", this.tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PresignedUrl": {
                return Optional.ofNullable(clazz.cast(this.presignedUrl()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "SourceSnapshotId": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotId()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotRequest, T> g) {
        return obj -> g.apply((CopySnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String description;
        private String destinationRegion;
        private Boolean encrypted;
        private String kmsKeyId;
        private String presignedUrl;
        private String sourceRegion;
        private String sourceSnapshotId;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            this.description(model.description);
            this.destinationRegion(model.destinationRegion);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.presignedUrl(model.presignedUrl);
            this.sourceRegion(model.sourceRegion);
            this.sourceSnapshotId(model.sourceSnapshotId);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPresignedUrl() {
            return this.presignedUrl;
        }

        @Override
        public final Builder presignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
            return this;
        }

        public final void setPresignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceSnapshotId() {
            return this.sourceSnapshotId;
        }

        @Override
        public final Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public final void setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(TagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder description(String var1);

        public Builder destinationRegion(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder presignedUrl(String var1);

        public Builder sourceRegion(String var1);

        public Builder sourceSnapshotId(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

