/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cost associated with the Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationValue.Builder, ReservationValue> {
    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationValue::hourlyPrice))
            .setter(setter(Builder::hourlyPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice")
                    .unmarshallLocationName("hourlyPrice").build()).build();

    private static final SdkField<String> REMAINING_TOTAL_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationValue::remainingTotalValue))
            .setter(setter(Builder::remainingTotalValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingTotalValue")
                    .unmarshallLocationName("remainingTotalValue").build()).build();

    private static final SdkField<String> REMAINING_UPFRONT_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationValue::remainingUpfrontValue))
            .setter(setter(Builder::remainingUpfrontValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingUpfrontValue")
                    .unmarshallLocationName("remainingUpfrontValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURLY_PRICE_FIELD,
            REMAINING_TOTAL_VALUE_FIELD, REMAINING_UPFRONT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hourlyPrice;

    private final String remainingTotalValue;

    private final String remainingUpfrontValue;

    private ReservationValue(BuilderImpl builder) {
        this.hourlyPrice = builder.hourlyPrice;
        this.remainingTotalValue = builder.remainingTotalValue;
        this.remainingUpfrontValue = builder.remainingUpfrontValue;
    }

    /**
     * <p>
     * The hourly rate of the reservation.
     * </p>
     * 
     * @return The hourly rate of the reservation.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours remaining).
     * </p>
     * 
     * @return The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours
     *         remaining).
     */
    public String remainingTotalValue() {
        return remainingTotalValue;
    }

    /**
     * <p>
     * The remaining upfront cost of the reservation.
     * </p>
     * 
     * @return The remaining upfront cost of the reservation.
     */
    public String remainingUpfrontValue() {
        return remainingUpfrontValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(remainingTotalValue());
        hashCode = 31 * hashCode + Objects.hashCode(remainingUpfrontValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationValue)) {
            return false;
        }
        ReservationValue other = (ReservationValue) obj;
        return Objects.equals(hourlyPrice(), other.hourlyPrice())
                && Objects.equals(remainingTotalValue(), other.remainingTotalValue())
                && Objects.equals(remainingUpfrontValue(), other.remainingUpfrontValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservationValue").add("HourlyPrice", hourlyPrice())
                .add("RemainingTotalValue", remainingTotalValue()).add("RemainingUpfrontValue", remainingUpfrontValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HourlyPrice":
            return Optional.ofNullable(clazz.cast(hourlyPrice()));
        case "RemainingTotalValue":
            return Optional.ofNullable(clazz.cast(remainingTotalValue()));
        case "RemainingUpfrontValue":
            return Optional.ofNullable(clazz.cast(remainingUpfrontValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationValue, T> g) {
        return obj -> g.apply((ReservationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationValue> {
        /**
         * <p>
         * The hourly rate of the reservation.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly rate of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours remaining).
         * </p>
         * 
         * @param remainingTotalValue
         *        The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours
         *        remaining).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingTotalValue(String remainingTotalValue);

        /**
         * <p>
         * The remaining upfront cost of the reservation.
         * </p>
         * 
         * @param remainingUpfrontValue
         *        The remaining upfront cost of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingUpfrontValue(String remainingUpfrontValue);
    }

    static final class BuilderImpl implements Builder {
        private String hourlyPrice;

        private String remainingTotalValue;

        private String remainingUpfrontValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationValue model) {
            hourlyPrice(model.hourlyPrice);
            remainingTotalValue(model.remainingTotalValue);
            remainingUpfrontValue(model.remainingUpfrontValue);
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getRemainingTotalValue() {
            return remainingTotalValue;
        }

        @Override
        public final Builder remainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
            return this;
        }

        public final void setRemainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
        }

        public final String getRemainingUpfrontValue() {
            return remainingUpfrontValue;
        }

        @Override
        public final Builder remainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
            return this;
        }

        public final void setRemainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
        }

        @Override
        public ReservationValue build() {
            return new ReservationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
