/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionByoipCidrRequest extends Ec2Request implements
        ToCopyableBuilder<ProvisionByoipCidrRequest.Builder, ProvisionByoipCidrRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionByoipCidrRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<CidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField
            .<CidrAuthorizationContext> builder(MarshallingType.SDK_POJO)
            .getter(getter(ProvisionByoipCidrRequest::cidrAuthorizationContext))
            .setter(setter(Builder::cidrAuthorizationContext))
            .constructor(CidrAuthorizationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext")
                    .unmarshallLocationName("CidrAuthorizationContext").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ADVERTISABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ProvisionByoipCidrRequest::publiclyAdvertisable))
            .setter(setter(Builder::publiclyAdvertisable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAdvertisable")
                    .unmarshallLocationName("PubliclyAdvertisable").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionByoipCidrRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<TagSpecification>> POOL_TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(ProvisionByoipCidrRequest::poolTagSpecifications))
            .setter(setter(Builder::poolTagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolTagSpecification")
                    .unmarshallLocationName("PoolTagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            CIDR_AUTHORIZATION_CONTEXT_FIELD, PUBLICLY_ADVERTISABLE_FIELD, DESCRIPTION_FIELD, POOL_TAG_SPECIFICATIONS_FIELD));

    private final String cidr;

    private final CidrAuthorizationContext cidrAuthorizationContext;

    private final Boolean publiclyAdvertisable;

    private final String description;

    private final List<TagSpecification> poolTagSpecifications;

    private ProvisionByoipCidrRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
        this.publiclyAdvertisable = builder.publiclyAdvertisable;
        this.description = builder.description;
        this.poolTagSpecifications = builder.poolTagSpecifications;
    }

    /**
     * <p>
     * The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can specify is
     * /24. The most specific IPv6 prefix you can specify is /56. The address range cannot overlap with another address
     * range that you've brought to this or another Region.
     * </p>
     * 
     * @return The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can
     *         specify is /24. The most specific IPv6 prefix you can specify is /56. The address range cannot overlap
     *         with another address range that you've brought to this or another Region.
     */
    public String cidr() {
        return cidr;
    }

    /**
     * <p>
     * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
     * BYOIP.
     * </p>
     * 
     * @return A signed document that proves that you are authorized to bring the specified IP address range to Amazon
     *         using BYOIP.
     */
    public CidrAuthorizationContext cidrAuthorizationContext() {
        return cidrAuthorizationContext;
    }

    /**
     * <p>
     * (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.
     * </p>
     * <p>
     * Default: true
     * </p>
     * 
     * @return (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.</p>
     *         <p>
     *         Default: true
     */
    public Boolean publiclyAdvertisable() {
        return publiclyAdvertisable;
    }

    /**
     * <p>
     * A description for the address range and the address pool.
     * </p>
     * 
     * @return A description for the address range and the address pool.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the PoolTagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPoolTagSpecifications() {
        return poolTagSpecifications != null && !(poolTagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the address pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPoolTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply to the address pool.
     */
    public List<TagSpecification> poolTagSpecifications() {
        return poolTagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(cidrAuthorizationContext());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAdvertisable());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(poolTagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionByoipCidrRequest)) {
            return false;
        }
        ProvisionByoipCidrRequest other = (ProvisionByoipCidrRequest) obj;
        return Objects.equals(cidr(), other.cidr())
                && Objects.equals(cidrAuthorizationContext(), other.cidrAuthorizationContext())
                && Objects.equals(publiclyAdvertisable(), other.publiclyAdvertisable())
                && Objects.equals(description(), other.description())
                && Objects.equals(poolTagSpecifications(), other.poolTagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisionByoipCidrRequest").add("Cidr", cidr())
                .add("CidrAuthorizationContext", cidrAuthorizationContext()).add("PubliclyAdvertisable", publiclyAdvertisable())
                .add("Description", description()).add("PoolTagSpecifications", poolTagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "CidrAuthorizationContext":
            return Optional.ofNullable(clazz.cast(cidrAuthorizationContext()));
        case "PubliclyAdvertisable":
            return Optional.ofNullable(clazz.cast(publiclyAdvertisable()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PoolTagSpecifications":
            return Optional.ofNullable(clazz.cast(poolTagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionByoipCidrRequest, T> g) {
        return obj -> g.apply((ProvisionByoipCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionByoipCidrRequest> {
        /**
         * <p>
         * The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can specify
         * is /24. The most specific IPv6 prefix you can specify is /56. The address range cannot overlap with another
         * address range that you've brought to this or another Region.
         * </p>
         * 
         * @param cidr
         *        The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can
         *        specify is /24. The most specific IPv6 prefix you can specify is /56. The address range cannot overlap
         *        with another address range that you've brought to this or another Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
         * BYOIP.
         * </p>
         * 
         * @param cidrAuthorizationContext
         *        A signed document that proves that you are authorized to bring the specified IP address range to
         *        Amazon using BYOIP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
         * BYOIP.
         * </p>
         * This is a convenience that creates an instance of the {@link CidrAuthorizationContext.Builder} avoiding the
         * need to create one manually via {@link CidrAuthorizationContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link CidrAuthorizationContext.Builder#build()} is called immediately
         * and its result is passed to {@link #cidrAuthorizationContext(CidrAuthorizationContext)}.
         * 
         * @param cidrAuthorizationContext
         *        a consumer that will call methods on {@link CidrAuthorizationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrAuthorizationContext(CidrAuthorizationContext)
         */
        default Builder cidrAuthorizationContext(Consumer<CidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return cidrAuthorizationContext(CidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext).build());
        }

        /**
         * <p>
         * (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.
         * </p>
         * <p>
         * Default: true
         * </p>
         * 
         * @param publiclyAdvertisable
         *        (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.</p>
         *        <p>
         *        Default: true
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAdvertisable(Boolean publiclyAdvertisable);

        /**
         * <p>
         * A description for the address range and the address pool.
         * </p>
         * 
         * @param description
         *        A description for the address range and the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags to apply to the address pool.
         * </p>
         * 
         * @param poolTagSpecifications
         *        The tags to apply to the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolTagSpecifications(Collection<TagSpecification> poolTagSpecifications);

        /**
         * <p>
         * The tags to apply to the address pool.
         * </p>
         * 
         * @param poolTagSpecifications
         *        The tags to apply to the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolTagSpecifications(TagSpecification... poolTagSpecifications);

        /**
         * <p>
         * The tags to apply to the address pool.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #poolTagSpecifications(List<TagSpecification>)}.
         * 
         * @param poolTagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #poolTagSpecifications(List<TagSpecification>)
         */
        Builder poolTagSpecifications(Consumer<TagSpecification.Builder>... poolTagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidr;

        private CidrAuthorizationContext cidrAuthorizationContext;

        private Boolean publiclyAdvertisable;

        private String description;

        private List<TagSpecification> poolTagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionByoipCidrRequest model) {
            super(model);
            cidr(model.cidr);
            cidrAuthorizationContext(model.cidrAuthorizationContext);
            publiclyAdvertisable(model.publiclyAdvertisable);
            description(model.description);
            poolTagSpecifications(model.poolTagSpecifications);
        }

        public final String getCidr() {
            return cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public final CidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return cidrAuthorizationContext != null ? cidrAuthorizationContext.toBuilder() : null;
        }

        @Override
        public final Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        public final void setCidrAuthorizationContext(CidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        public final Boolean getPubliclyAdvertisable() {
            return publiclyAdvertisable;
        }

        @Override
        public final Builder publiclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        public final void setPubliclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<TagSpecification.Builder> getPoolTagSpecifications() {
            return poolTagSpecifications != null ? poolTagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder poolTagSpecifications(Collection<TagSpecification> poolTagSpecifications) {
            this.poolTagSpecifications = TagSpecificationListCopier.copy(poolTagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolTagSpecifications(TagSpecification... poolTagSpecifications) {
            poolTagSpecifications(Arrays.asList(poolTagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolTagSpecifications(Consumer<TagSpecification.Builder>... poolTagSpecifications) {
            poolTagSpecifications(Stream.of(poolTagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPoolTagSpecifications(Collection<TagSpecification.BuilderImpl> poolTagSpecifications) {
            this.poolTagSpecifications = TagSpecificationListCopier.copyFromBuilder(poolTagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionByoipCidrRequest build() {
            return new ProvisionByoipCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
