/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeInstanceAttributeRequest.Builder, DescribeInstanceAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstanceAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("attribute").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstanceAttributeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            INSTANCE_ID_FIELD));

    private final String attribute;

    private final String instanceId;

    private DescribeInstanceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The instance attribute.
     * </p>
     * <p>
     * Note: The <code>enaSupport</code> attribute is not supported at this time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link InstanceAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The instance attribute.</p>
     *         <p>
     *         Note: The <code>enaSupport</code> attribute is not supported at this time.
     * @see InstanceAttributeName
     */
    public InstanceAttributeName attribute() {
        return InstanceAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The instance attribute.
     * </p>
     * <p>
     * Note: The <code>enaSupport</code> attribute is not supported at this time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link InstanceAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The instance attribute.</p>
     *         <p>
     *         Note: The <code>enaSupport</code> attribute is not supported at this time.
     * @see InstanceAttributeName
     */
    public String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAttributeRequest)) {
            return false;
        }
        DescribeInstanceAttributeRequest other = (DescribeInstanceAttributeRequest) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceAttributeRequest").add("Attribute", attributeAsString())
                .add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceAttributeRequest, T> g) {
        return obj -> g.apply((DescribeInstanceAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceAttributeRequest> {
        /**
         * <p>
         * The instance attribute.
         * </p>
         * <p>
         * Note: The <code>enaSupport</code> attribute is not supported at this time.
         * </p>
         * 
         * @param attribute
         *        The instance attribute.</p>
         *        <p>
         *        Note: The <code>enaSupport</code> attribute is not supported at this time.
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The instance attribute.
         * </p>
         * <p>
         * Note: The <code>enaSupport</code> attribute is not supported at this time.
         * </p>
         * 
         * @param attribute
         *        The instance attribute.</p>
         *        <p>
         *        Note: The <code>enaSupport</code> attribute is not supported at this time.
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(InstanceAttributeName attribute);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String attribute;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAttributeRequest model) {
            super(model);
            attribute(model.attribute);
            instanceId(model.instanceId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceAttributeRequest build() {
            return new DescribeInstanceAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
