/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTransitGatewayMulticastDomainResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteTransitGatewayMulticastDomainResponse.Builder, DeleteTransitGatewayMulticastDomainResponse> {
    private static final SdkField<TransitGatewayMulticastDomain> TRANSIT_GATEWAY_MULTICAST_DOMAIN_FIELD = SdkField
            .<TransitGatewayMulticastDomain> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteTransitGatewayMulticastDomainResponse::transitGatewayMulticastDomain))
            .setter(setter(Builder::transitGatewayMulticastDomain))
            .constructor(TransitGatewayMulticastDomain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomain")
                    .unmarshallLocationName("transitGatewayMulticastDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_MULTICAST_DOMAIN_FIELD));

    private final TransitGatewayMulticastDomain transitGatewayMulticastDomain;

    private DeleteTransitGatewayMulticastDomainResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMulticastDomain = builder.transitGatewayMulticastDomain;
    }

    /**
     * <p>
     * Information about the deleted transit gateway multicast domain.
     * </p>
     * 
     * @return Information about the deleted transit gateway multicast domain.
     */
    public TransitGatewayMulticastDomain transitGatewayMulticastDomain() {
        return transitGatewayMulticastDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTransitGatewayMulticastDomainResponse)) {
            return false;
        }
        DeleteTransitGatewayMulticastDomainResponse other = (DeleteTransitGatewayMulticastDomainResponse) obj;
        return Objects.equals(transitGatewayMulticastDomain(), other.transitGatewayMulticastDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteTransitGatewayMulticastDomainResponse")
                .add("TransitGatewayMulticastDomain", transitGatewayMulticastDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMulticastDomain":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTransitGatewayMulticastDomainResponse, T> g) {
        return obj -> g.apply((DeleteTransitGatewayMulticastDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTransitGatewayMulticastDomainResponse> {
        /**
         * <p>
         * Information about the deleted transit gateway multicast domain.
         * </p>
         * 
         * @param transitGatewayMulticastDomain
         *        Information about the deleted transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomain(TransitGatewayMulticastDomain transitGatewayMulticastDomain);

        /**
         * <p>
         * Information about the deleted transit gateway multicast domain.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayMulticastDomain.Builder} avoiding
         * the need to create one manually via {@link TransitGatewayMulticastDomain#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayMulticastDomain.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayMulticastDomain(TransitGatewayMulticastDomain)}
         * .
         * 
         * @param transitGatewayMulticastDomain
         *        a consumer that will call methods on {@link TransitGatewayMulticastDomain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayMulticastDomain(TransitGatewayMulticastDomain)
         */
        default Builder transitGatewayMulticastDomain(
                Consumer<TransitGatewayMulticastDomain.Builder> transitGatewayMulticastDomain) {
            return transitGatewayMulticastDomain(TransitGatewayMulticastDomain.builder()
                    .applyMutation(transitGatewayMulticastDomain).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayMulticastDomain transitGatewayMulticastDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTransitGatewayMulticastDomainResponse model) {
            super(model);
            transitGatewayMulticastDomain(model.transitGatewayMulticastDomain);
        }

        public final TransitGatewayMulticastDomain.Builder getTransitGatewayMulticastDomain() {
            return transitGatewayMulticastDomain != null ? transitGatewayMulticastDomain.toBuilder() : null;
        }

        @Override
        public final Builder transitGatewayMulticastDomain(TransitGatewayMulticastDomain transitGatewayMulticastDomain) {
            this.transitGatewayMulticastDomain = transitGatewayMulticastDomain;
            return this;
        }

        public final void setTransitGatewayMulticastDomain(TransitGatewayMulticastDomain.BuilderImpl transitGatewayMulticastDomain) {
            this.transitGatewayMulticastDomain = transitGatewayMulticastDomain != null ? transitGatewayMulticastDomain.build()
                    : null;
        }

        @Override
        public DeleteTransitGatewayMulticastDomainResponse build() {
            return new DeleteTransitGatewayMulticastDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
