/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.VolumeStatusDetails;
import software.amazon.awssdk.services.ec2.model.VolumeStatusDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeStatusInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeStatusInfo> {
    private static final SdkField<List<VolumeStatusDetails>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VolumeStatusInfo.getter(VolumeStatusInfo::details)).setter(VolumeStatusInfo.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").unmarshallLocationName("details").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeStatusInfo.getter(VolumeStatusInfo::statusAsString)).setter(VolumeStatusInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<VolumeStatusDetails> details;
    private final String status;

    private VolumeStatusInfo(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    public boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public List<VolumeStatusDetails> details() {
        return this.details;
    }

    public VolumeStatusInfoStatus status() {
        return VolumeStatusInfoStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusInfo)) {
            return false;
        }
        VolumeStatusInfo other = (VolumeStatusInfo)obj;
        return Objects.equals(this.details(), other.details()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"VolumeStatusInfo").add("Details", this.details()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusInfo, T> g) {
        return obj -> g.apply((VolumeStatusInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<VolumeStatusDetails> details = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusInfo model) {
            this.details(model.details);
            this.status(model.status);
        }

        public final Collection<VolumeStatusDetails.Builder> getDetails() {
            return this.details != null ? (Collection)this.details.stream().map(VolumeStatusDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<VolumeStatusDetails> details) {
            this.details = VolumeStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(VolumeStatusDetails ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<VolumeStatusDetails.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (VolumeStatusDetails)((VolumeStatusDetails.Builder)VolumeStatusDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<VolumeStatusDetails.BuilderImpl> details) {
            this.details = VolumeStatusDetailsListCopier.copyFromBuilder(details);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VolumeStatusInfoStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public VolumeStatusInfo build() {
            return new VolumeStatusInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeStatusInfo> {
        public Builder details(Collection<VolumeStatusDetails> var1);

        public Builder details(VolumeStatusDetails ... var1);

        public Builder details(Consumer<VolumeStatusDetails.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(VolumeStatusInfoStatus var1);
    }
}

