/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficMirrorFilterRuleResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateTrafficMirrorFilterRuleResponse> {
    private static final SdkField<TrafficMirrorFilterRule> TRAFFIC_MIRROR_FILTER_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrafficMirrorFilterRuleResponse.getter(CreateTrafficMirrorFilterRuleResponse::trafficMirrorFilterRule)).setter(CreateTrafficMirrorFilterRuleResponse.setter(Builder::trafficMirrorFilterRule)).constructor(TrafficMirrorFilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRule").unmarshallLocationName("trafficMirrorFilterRule").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrafficMirrorFilterRuleResponse.getter(CreateTrafficMirrorFilterRuleResponse::clientToken)).setter(CreateTrafficMirrorFilterRuleResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_RULE_FIELD, CLIENT_TOKEN_FIELD));
    private final TrafficMirrorFilterRule trafficMirrorFilterRule;
    private final String clientToken;

    private CreateTrafficMirrorFilterRuleResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterRule = builder.trafficMirrorFilterRule;
        this.clientToken = builder.clientToken;
    }

    public TrafficMirrorFilterRule trafficMirrorFilterRule() {
        return this.trafficMirrorFilterRule;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorFilterRuleResponse)) {
            return false;
        }
        CreateTrafficMirrorFilterRuleResponse other = (CreateTrafficMirrorFilterRuleResponse)((Object)obj);
        return Objects.equals(this.trafficMirrorFilterRule(), other.trafficMirrorFilterRule()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateTrafficMirrorFilterRuleResponse").add("TrafficMirrorFilterRule", (Object)this.trafficMirrorFilterRule()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterRule": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterRule()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorFilterRuleResponse, T> g) {
        return obj -> g.apply((CreateTrafficMirrorFilterRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private TrafficMirrorFilterRule trafficMirrorFilterRule;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorFilterRuleResponse model) {
            super(model);
            this.trafficMirrorFilterRule(model.trafficMirrorFilterRule);
            this.clientToken(model.clientToken);
        }

        public final TrafficMirrorFilterRule.Builder getTrafficMirrorFilterRule() {
            return this.trafficMirrorFilterRule != null ? this.trafficMirrorFilterRule.toBuilder() : null;
        }

        @Override
        public final Builder trafficMirrorFilterRule(TrafficMirrorFilterRule trafficMirrorFilterRule) {
            this.trafficMirrorFilterRule = trafficMirrorFilterRule;
            return this;
        }

        public final void setTrafficMirrorFilterRule(TrafficMirrorFilterRule.BuilderImpl trafficMirrorFilterRule) {
            this.trafficMirrorFilterRule = trafficMirrorFilterRule != null ? trafficMirrorFilterRule.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateTrafficMirrorFilterRuleResponse build() {
            return new CreateTrafficMirrorFilterRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficMirrorFilterRuleResponse> {
        public Builder trafficMirrorFilterRule(TrafficMirrorFilterRule var1);

        default public Builder trafficMirrorFilterRule(Consumer<TrafficMirrorFilterRule.Builder> trafficMirrorFilterRule) {
            return this.trafficMirrorFilterRule((TrafficMirrorFilterRule)((TrafficMirrorFilterRule.Builder)TrafficMirrorFilterRule.builder().applyMutation(trafficMirrorFilterRule)).build());
        }

        public Builder clientToken(String var1);
    }
}

