/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdFormat> {
    private static final SdkField<Instant> DEADLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(IdFormat.getter(IdFormat::deadline)).setter(IdFormat.setter(Builder::deadline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deadline").unmarshallLocationName("deadline").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IdFormat.getter(IdFormat::resource)).setter(IdFormat.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").unmarshallLocationName("resource").build()}).build();
    private static final SdkField<Boolean> USE_LONG_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(IdFormat.getter(IdFormat::useLongIds)).setter(IdFormat.setter(Builder::useLongIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLongIds").unmarshallLocationName("useLongIds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEADLINE_FIELD, RESOURCE_FIELD, USE_LONG_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant deadline;
    private final String resource;
    private final Boolean useLongIds;

    private IdFormat(BuilderImpl builder) {
        this.deadline = builder.deadline;
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    public Instant deadline() {
        return this.deadline;
    }

    public String resource() {
        return this.resource;
    }

    public Boolean useLongIds() {
        return this.useLongIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deadline());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLongIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdFormat)) {
            return false;
        }
        IdFormat other = (IdFormat)obj;
        return Objects.equals(this.deadline(), other.deadline()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.useLongIds(), other.useLongIds());
    }

    public String toString() {
        return ToString.builder((String)"IdFormat").add("Deadline", (Object)this.deadline()).add("Resource", (Object)this.resource()).add("UseLongIds", (Object)this.useLongIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deadline": {
                return Optional.ofNullable(clazz.cast(this.deadline()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "UseLongIds": {
                return Optional.ofNullable(clazz.cast(this.useLongIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdFormat, T> g) {
        return obj -> g.apply((IdFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant deadline;
        private String resource;
        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(IdFormat model) {
            this.deadline(model.deadline);
            this.resource(model.resource);
            this.useLongIds(model.useLongIds);
        }

        public final Instant getDeadline() {
            return this.deadline;
        }

        @Override
        public final Builder deadline(Instant deadline) {
            this.deadline = deadline;
            return this;
        }

        public final void setDeadline(Instant deadline) {
            this.deadline = deadline;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Boolean getUseLongIds() {
            return this.useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        public IdFormat build() {
            return new IdFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdFormat> {
        public Builder deadline(Instant var1);

        public Builder resource(String var1);

        public Builder useLongIds(Boolean var1);
    }
}

