/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomerGatewayRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateCustomerGatewayRequest> {
    private static final SdkField<Integer> BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateCustomerGatewayRequest.getter(CreateCustomerGatewayRequest::bgpAsn)).setter(CreateCustomerGatewayRequest.setter(Builder::bgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpAsn").unmarshallLocationName("BgpAsn").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomerGatewayRequest.getter(CreateCustomerGatewayRequest::publicIp)).setter(CreateCustomerGatewayRequest.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").unmarshallLocationName("IpAddress").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomerGatewayRequest.getter(CreateCustomerGatewayRequest::certificateArn)).setter(CreateCustomerGatewayRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").unmarshallLocationName("CertificateArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomerGatewayRequest.getter(CreateCustomerGatewayRequest::typeAsString)).setter(CreateCustomerGatewayRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomerGatewayRequest.getter(CreateCustomerGatewayRequest::deviceName)).setter(CreateCustomerGatewayRequest.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").unmarshallLocationName("DeviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BGP_ASN_FIELD, PUBLIC_IP_FIELD, CERTIFICATE_ARN_FIELD, TYPE_FIELD, DEVICE_NAME_FIELD));
    private final Integer bgpAsn;
    private final String publicIp;
    private final String certificateArn;
    private final String type;
    private final String deviceName;

    private CreateCustomerGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.bgpAsn = builder.bgpAsn;
        this.publicIp = builder.publicIp;
        this.certificateArn = builder.certificateArn;
        this.type = builder.type;
        this.deviceName = builder.deviceName;
    }

    public Integer bgpAsn() {
        return this.bgpAsn;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public GatewayType type() {
        return GatewayType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String deviceName() {
        return this.deviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayRequest)) {
            return false;
        }
        CreateCustomerGatewayRequest other = (CreateCustomerGatewayRequest)((Object)obj);
        return Objects.equals(this.bgpAsn(), other.bgpAsn()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.deviceName(), other.deviceName());
    }

    public String toString() {
        return ToString.builder((String)"CreateCustomerGatewayRequest").add("BgpAsn", (Object)this.bgpAsn()).add("PublicIp", (Object)this.publicIp()).add("CertificateArn", (Object)this.certificateArn()).add("Type", (Object)this.typeAsString()).add("DeviceName", (Object)this.deviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BgpAsn": {
                return Optional.ofNullable(clazz.cast(this.bgpAsn()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomerGatewayRequest, T> g) {
        return obj -> g.apply((CreateCustomerGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Integer bgpAsn;
        private String publicIp;
        private String certificateArn;
        private String type;
        private String deviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomerGatewayRequest model) {
            super(model);
            this.bgpAsn(model.bgpAsn);
            this.publicIp(model.publicIp);
            this.certificateArn(model.certificateArn);
            this.type(model.type);
            this.deviceName(model.deviceName);
        }

        public final Integer getBgpAsn() {
            return this.bgpAsn;
        }

        @Override
        public final Builder bgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomerGatewayRequest build() {
            return new CreateCustomerGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomerGatewayRequest> {
        public Builder bgpAsn(Integer var1);

        public Builder publicIp(String var1);

        public Builder certificateArn(String var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder deviceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

