/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteQueuedReservedInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteQueuedReservedInstancesResponse.Builder, DeleteQueuedReservedInstancesResponse> {
    private static final SdkField<List<SuccessfulQueuedPurchaseDeletion>> SUCCESSFUL_QUEUED_PURCHASE_DELETIONS_FIELD = SdkField
            .<List<SuccessfulQueuedPurchaseDeletion>> builder(MarshallingType.LIST)
            .getter(getter(DeleteQueuedReservedInstancesResponse::successfulQueuedPurchaseDeletions))
            .setter(setter(Builder::successfulQueuedPurchaseDeletions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SuccessfulQueuedPurchaseDeletionSet")
                    .unmarshallLocationName("successfulQueuedPurchaseDeletionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SuccessfulQueuedPurchaseDeletion> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulQueuedPurchaseDeletion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<FailedQueuedPurchaseDeletion>> FAILED_QUEUED_PURCHASE_DELETIONS_FIELD = SdkField
            .<List<FailedQueuedPurchaseDeletion>> builder(MarshallingType.LIST)
            .getter(getter(DeleteQueuedReservedInstancesResponse::failedQueuedPurchaseDeletions))
            .setter(setter(Builder::failedQueuedPurchaseDeletions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedQueuedPurchaseDeletionSet")
                    .unmarshallLocationName("failedQueuedPurchaseDeletionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FailedQueuedPurchaseDeletion> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedQueuedPurchaseDeletion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFUL_QUEUED_PURCHASE_DELETIONS_FIELD, FAILED_QUEUED_PURCHASE_DELETIONS_FIELD));

    private final List<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions;

    private final List<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions;

    private DeleteQueuedReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.successfulQueuedPurchaseDeletions = builder.successfulQueuedPurchaseDeletions;
        this.failedQueuedPurchaseDeletions = builder.failedQueuedPurchaseDeletions;
    }

    /**
     * Returns true if the SuccessfulQueuedPurchaseDeletions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasSuccessfulQueuedPurchaseDeletions() {
        return successfulQueuedPurchaseDeletions != null && !(successfulQueuedPurchaseDeletions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the queued purchases that were successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulQueuedPurchaseDeletions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the queued purchases that were successfully deleted.
     */
    public List<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions() {
        return successfulQueuedPurchaseDeletions;
    }

    /**
     * Returns true if the FailedQueuedPurchaseDeletions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasFailedQueuedPurchaseDeletions() {
        return failedQueuedPurchaseDeletions != null && !(failedQueuedPurchaseDeletions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the queued purchases that could not be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedQueuedPurchaseDeletions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the queued purchases that could not be deleted.
     */
    public List<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions() {
        return failedQueuedPurchaseDeletions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(successfulQueuedPurchaseDeletions());
        hashCode = 31 * hashCode + Objects.hashCode(failedQueuedPurchaseDeletions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueuedReservedInstancesResponse)) {
            return false;
        }
        DeleteQueuedReservedInstancesResponse other = (DeleteQueuedReservedInstancesResponse) obj;
        return Objects.equals(successfulQueuedPurchaseDeletions(), other.successfulQueuedPurchaseDeletions())
                && Objects.equals(failedQueuedPurchaseDeletions(), other.failedQueuedPurchaseDeletions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteQueuedReservedInstancesResponse")
                .add("SuccessfulQueuedPurchaseDeletions", successfulQueuedPurchaseDeletions())
                .add("FailedQueuedPurchaseDeletions", failedQueuedPurchaseDeletions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulQueuedPurchaseDeletions":
            return Optional.ofNullable(clazz.cast(successfulQueuedPurchaseDeletions()));
        case "FailedQueuedPurchaseDeletions":
            return Optional.ofNullable(clazz.cast(failedQueuedPurchaseDeletions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteQueuedReservedInstancesResponse, T> g) {
        return obj -> g.apply((DeleteQueuedReservedInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteQueuedReservedInstancesResponse> {
        /**
         * <p>
         * Information about the queued purchases that were successfully deleted.
         * </p>
         * 
         * @param successfulQueuedPurchaseDeletions
         *        Information about the queued purchases that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulQueuedPurchaseDeletions(Collection<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions);

        /**
         * <p>
         * Information about the queued purchases that were successfully deleted.
         * </p>
         * 
         * @param successfulQueuedPurchaseDeletions
         *        Information about the queued purchases that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulQueuedPurchaseDeletions(SuccessfulQueuedPurchaseDeletion... successfulQueuedPurchaseDeletions);

        /**
         * <p>
         * Information about the queued purchases that were successfully deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SuccessfulQueuedPurchaseDeletion>.Builder}
         * avoiding the need to create one manually via {@link List<SuccessfulQueuedPurchaseDeletion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SuccessfulQueuedPurchaseDeletion>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #successfulQueuedPurchaseDeletions(List<SuccessfulQueuedPurchaseDeletion>)}.
         * 
         * @param successfulQueuedPurchaseDeletions
         *        a consumer that will call methods on {@link List<SuccessfulQueuedPurchaseDeletion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulQueuedPurchaseDeletions(List<SuccessfulQueuedPurchaseDeletion>)
         */
        Builder successfulQueuedPurchaseDeletions(
                Consumer<SuccessfulQueuedPurchaseDeletion.Builder>... successfulQueuedPurchaseDeletions);

        /**
         * <p>
         * Information about the queued purchases that could not be deleted.
         * </p>
         * 
         * @param failedQueuedPurchaseDeletions
         *        Information about the queued purchases that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedQueuedPurchaseDeletions(Collection<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions);

        /**
         * <p>
         * Information about the queued purchases that could not be deleted.
         * </p>
         * 
         * @param failedQueuedPurchaseDeletions
         *        Information about the queued purchases that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedQueuedPurchaseDeletions(FailedQueuedPurchaseDeletion... failedQueuedPurchaseDeletions);

        /**
         * <p>
         * Information about the queued purchases that could not be deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedQueuedPurchaseDeletion>.Builder}
         * avoiding the need to create one manually via {@link List<FailedQueuedPurchaseDeletion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedQueuedPurchaseDeletion>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #failedQueuedPurchaseDeletions(List<FailedQueuedPurchaseDeletion>)}.
         * 
         * @param failedQueuedPurchaseDeletions
         *        a consumer that will call methods on {@link List<FailedQueuedPurchaseDeletion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedQueuedPurchaseDeletions(List<FailedQueuedPurchaseDeletion>)
         */
        Builder failedQueuedPurchaseDeletions(Consumer<FailedQueuedPurchaseDeletion.Builder>... failedQueuedPurchaseDeletions);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions = DefaultSdkAutoConstructList
                .getInstance();

        private List<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueuedReservedInstancesResponse model) {
            super(model);
            successfulQueuedPurchaseDeletions(model.successfulQueuedPurchaseDeletions);
            failedQueuedPurchaseDeletions(model.failedQueuedPurchaseDeletions);
        }

        public final Collection<SuccessfulQueuedPurchaseDeletion.Builder> getSuccessfulQueuedPurchaseDeletions() {
            return successfulQueuedPurchaseDeletions != null ? successfulQueuedPurchaseDeletions.stream()
                    .map(SuccessfulQueuedPurchaseDeletion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulQueuedPurchaseDeletions(
                Collection<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions) {
            this.successfulQueuedPurchaseDeletions = SuccessfulQueuedPurchaseDeletionSetCopier
                    .copy(successfulQueuedPurchaseDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulQueuedPurchaseDeletions(
                SuccessfulQueuedPurchaseDeletion... successfulQueuedPurchaseDeletions) {
            successfulQueuedPurchaseDeletions(Arrays.asList(successfulQueuedPurchaseDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulQueuedPurchaseDeletions(
                Consumer<SuccessfulQueuedPurchaseDeletion.Builder>... successfulQueuedPurchaseDeletions) {
            successfulQueuedPurchaseDeletions(Stream.of(successfulQueuedPurchaseDeletions)
                    .map(c -> SuccessfulQueuedPurchaseDeletion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulQueuedPurchaseDeletions(
                Collection<SuccessfulQueuedPurchaseDeletion.BuilderImpl> successfulQueuedPurchaseDeletions) {
            this.successfulQueuedPurchaseDeletions = SuccessfulQueuedPurchaseDeletionSetCopier
                    .copyFromBuilder(successfulQueuedPurchaseDeletions);
        }

        public final Collection<FailedQueuedPurchaseDeletion.Builder> getFailedQueuedPurchaseDeletions() {
            return failedQueuedPurchaseDeletions != null ? failedQueuedPurchaseDeletions.stream()
                    .map(FailedQueuedPurchaseDeletion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedQueuedPurchaseDeletions(Collection<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions) {
            this.failedQueuedPurchaseDeletions = FailedQueuedPurchaseDeletionSetCopier.copy(failedQueuedPurchaseDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedQueuedPurchaseDeletions(FailedQueuedPurchaseDeletion... failedQueuedPurchaseDeletions) {
            failedQueuedPurchaseDeletions(Arrays.asList(failedQueuedPurchaseDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedQueuedPurchaseDeletions(
                Consumer<FailedQueuedPurchaseDeletion.Builder>... failedQueuedPurchaseDeletions) {
            failedQueuedPurchaseDeletions(Stream.of(failedQueuedPurchaseDeletions)
                    .map(c -> FailedQueuedPurchaseDeletion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedQueuedPurchaseDeletions(
                Collection<FailedQueuedPurchaseDeletion.BuilderImpl> failedQueuedPurchaseDeletions) {
            this.failedQueuedPurchaseDeletions = FailedQueuedPurchaseDeletionSetCopier
                    .copyFromBuilder(failedQueuedPurchaseDeletions);
        }

        @Override
        public DeleteQueuedReservedInstancesResponse build() {
            return new DeleteQueuedReservedInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
