/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AttachVpnGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachVpnGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<AttachVpnGatewayResponse.Builder, AttachVpnGatewayResponse> {
    private static final SdkField<VpcAttachment> VPC_ATTACHMENT_FIELD = SdkField
            .<VpcAttachment> builder(MarshallingType.SDK_POJO)
            .getter(getter(AttachVpnGatewayResponse::vpcAttachment))
            .setter(setter(Builder::vpcAttachment))
            .constructor(VpcAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment")
                    .unmarshallLocationName("attachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ATTACHMENT_FIELD));

    private final VpcAttachment vpcAttachment;

    private AttachVpnGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.vpcAttachment = builder.vpcAttachment;
    }

    /**
     * <p>
     * Information about the attachment.
     * </p>
     * 
     * @return Information about the attachment.
     */
    public VpcAttachment vpcAttachment() {
        return vpcAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcAttachment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVpnGatewayResponse)) {
            return false;
        }
        AttachVpnGatewayResponse other = (AttachVpnGatewayResponse) obj;
        return Objects.equals(vpcAttachment(), other.vpcAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttachVpnGatewayResponse").add("VpcAttachment", vpcAttachment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcAttachment":
            return Optional.ofNullable(clazz.cast(vpcAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachVpnGatewayResponse, T> g) {
        return obj -> g.apply((AttachVpnGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AttachVpnGatewayResponse> {
        /**
         * <p>
         * Information about the attachment.
         * </p>
         * 
         * @param vpcAttachment
         *        Information about the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachment(VpcAttachment vpcAttachment);

        /**
         * <p>
         * Information about the attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcAttachment.Builder} avoiding the need to
         * create one manually via {@link VpcAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcAttachment.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcAttachment(VpcAttachment)}.
         * 
         * @param vpcAttachment
         *        a consumer that will call methods on {@link VpcAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcAttachment(VpcAttachment)
         */
        default Builder vpcAttachment(Consumer<VpcAttachment.Builder> vpcAttachment) {
            return vpcAttachment(VpcAttachment.builder().applyMutation(vpcAttachment).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpcAttachment vpcAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVpnGatewayResponse model) {
            super(model);
            vpcAttachment(model.vpcAttachment);
        }

        public final VpcAttachment.Builder getVpcAttachment() {
            return vpcAttachment != null ? vpcAttachment.toBuilder() : null;
        }

        @Override
        public final Builder vpcAttachment(VpcAttachment vpcAttachment) {
            this.vpcAttachment = vpcAttachment;
            return this;
        }

        public final void setVpcAttachment(VpcAttachment.BuilderImpl vpcAttachment) {
            this.vpcAttachment = vpcAttachment != null ? vpcAttachment.build() : null;
        }

        @Override
        public AttachVpnGatewayResponse build() {
            return new AttachVpnGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
