/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.RouteOrigin;
import software.amazon.awssdk.services.ec2.model.RouteState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::destinationCidrBlock)).setter(Route.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::destinationIpv6CidrBlock)).setter(Route.setter(Builder::destinationIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").unmarshallLocationName("destinationIpv6CidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::destinationPrefixListId)).setter(Route.setter(Builder::destinationPrefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").unmarshallLocationName("destinationPrefixListId").build()}).build();
    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::egressOnlyInternetGatewayId)).setter(Route.setter(Builder::egressOnlyInternetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId").unmarshallLocationName("egressOnlyInternetGatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::gatewayId)).setter(Route.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").unmarshallLocationName("gatewayId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::instanceId)).setter(Route.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::instanceOwnerId)).setter(Route.setter(Builder::instanceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId").unmarshallLocationName("instanceOwnerId").build()}).build();
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::natGatewayId)).setter(Route.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("natGatewayId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::transitGatewayId)).setter(Route.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::localGatewayId)).setter(Route.setter(Builder::localGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").unmarshallLocationName("localGatewayId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::networkInterfaceId)).setter(Route.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::originAsString)).setter(Route.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").unmarshallLocationName("origin").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::stateAsString)).setter(Route.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Route.getter(Route::vpcPeeringConnectionId)).setter(Route.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("vpcPeeringConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_OWNER_ID_FIELD, NAT_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, ORIGIN_FIELD, STATE_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationCidrBlock;
    private final String destinationIpv6CidrBlock;
    private final String destinationPrefixListId;
    private final String egressOnlyInternetGatewayId;
    private final String gatewayId;
    private final String instanceId;
    private final String instanceOwnerId;
    private final String natGatewayId;
    private final String transitGatewayId;
    private final String localGatewayId;
    private final String networkInterfaceId;
    private final String origin;
    private final String state;
    private final String vpcPeeringConnectionId;

    private Route(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.natGatewayId = builder.natGatewayId;
        this.transitGatewayId = builder.transitGatewayId;
        this.localGatewayId = builder.localGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.origin = builder.origin;
        this.state = builder.state;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public String destinationPrefixListId() {
        return this.destinationPrefixListId;
    }

    public String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceOwnerId() {
        return this.instanceOwnerId;
    }

    public String natGatewayId() {
        return this.natGatewayId;
    }

    public String transitGatewayId() {
        return this.transitGatewayId;
    }

    public String localGatewayId() {
        return this.localGatewayId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public RouteOrigin origin() {
        return RouteOrigin.fromValue(this.origin);
    }

    public String originAsString() {
        return this.origin;
    }

    public RouteState state() {
        return RouteState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route)obj;
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock()) && Objects.equals(this.destinationPrefixListId(), other.destinationPrefixListId()) && Objects.equals(this.egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceOwnerId(), other.instanceOwnerId()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.localGatewayId(), other.localGatewayId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"Route").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).add("DestinationPrefixListId", (Object)this.destinationPrefixListId()).add("EgressOnlyInternetGatewayId", (Object)this.egressOnlyInternetGatewayId()).add("GatewayId", (Object)this.gatewayId()).add("InstanceId", (Object)this.instanceId()).add("InstanceOwnerId", (Object)this.instanceOwnerId()).add("NatGatewayId", (Object)this.natGatewayId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("LocalGatewayId", (Object)this.localGatewayId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("Origin", (Object)this.originAsString()).add("State", (Object)this.stateAsString()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "DestinationPrefixListId": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixListId()));
            }
            case "EgressOnlyInternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGatewayId()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.instanceOwnerId()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "LocalGatewayId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String destinationIpv6CidrBlock;
        private String destinationPrefixListId;
        private String egressOnlyInternetGatewayId;
        private String gatewayId;
        private String instanceId;
        private String instanceOwnerId;
        private String natGatewayId;
        private String transitGatewayId;
        private String localGatewayId;
        private String networkInterfaceId;
        private String origin;
        private String state;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.destinationPrefixListId(model.destinationPrefixListId);
            this.egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            this.gatewayId(model.gatewayId);
            this.instanceId(model.instanceId);
            this.instanceOwnerId(model.instanceOwnerId);
            this.natGatewayId(model.natGatewayId);
            this.transitGatewayId(model.transitGatewayId);
            this.localGatewayId(model.localGatewayId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.origin(model.origin);
            this.state(model.state);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceOwnerId() {
            return this.instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getLocalGatewayId() {
            return this.localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOrigin() {
            return this.origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(RouteOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        public Route build() {
            return new Route(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route> {
        public Builder destinationCidrBlock(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder destinationPrefixListId(String var1);

        public Builder egressOnlyInternetGatewayId(String var1);

        public Builder gatewayId(String var1);

        public Builder instanceId(String var1);

        public Builder instanceOwnerId(String var1);

        public Builder natGatewayId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder localGatewayId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder origin(String var1);

        public Builder origin(RouteOrigin var1);

        public Builder state(String var1);

        public Builder state(RouteState var1);

        public Builder vpcPeeringConnectionId(String var1);
    }
}

