/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateAndOverridesResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateAndOverridesResponse> {
    private static final SdkField<FleetLaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LaunchTemplateAndOverridesResponse.getter(LaunchTemplateAndOverridesResponse::launchTemplateSpecification)).setter(LaunchTemplateAndOverridesResponse.setter(Builder::launchTemplateSpecification)).constructor(FleetLaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification").unmarshallLocationName("launchTemplateSpecification").build()}).build();
    private static final SdkField<FleetLaunchTemplateOverrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LaunchTemplateAndOverridesResponse.getter(LaunchTemplateAndOverridesResponse::overrides)).setter(LaunchTemplateAndOverridesResponse.setter(Builder::overrides)).constructor(FleetLaunchTemplateOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").unmarshallLocationName("overrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final FleetLaunchTemplateSpecification launchTemplateSpecification;
    private final FleetLaunchTemplateOverrides overrides;

    private LaunchTemplateAndOverridesResponse(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    public FleetLaunchTemplateSpecification launchTemplateSpecification() {
        return this.launchTemplateSpecification;
    }

    public FleetLaunchTemplateOverrides overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateAndOverridesResponse)) {
            return false;
        }
        LaunchTemplateAndOverridesResponse other = (LaunchTemplateAndOverridesResponse)obj;
        return Objects.equals(this.launchTemplateSpecification(), other.launchTemplateSpecification()) && Objects.equals(this.overrides(), other.overrides());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplateAndOverridesResponse").add("LaunchTemplateSpecification", (Object)this.launchTemplateSpecification()).add("Overrides", (Object)this.overrides()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateSpecification()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateAndOverridesResponse, T> g) {
        return obj -> g.apply((LaunchTemplateAndOverridesResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FleetLaunchTemplateSpecification launchTemplateSpecification;
        private FleetLaunchTemplateOverrides overrides;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateAndOverridesResponse model) {
            this.launchTemplateSpecification(model.launchTemplateSpecification);
            this.overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return this.launchTemplateSpecification != null ? this.launchTemplateSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        public final FleetLaunchTemplateOverrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(FleetLaunchTemplateOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(FleetLaunchTemplateOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public LaunchTemplateAndOverridesResponse build() {
            return new LaunchTemplateAndOverridesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateAndOverridesResponse> {
        public Builder launchTemplateSpecification(FleetLaunchTemplateSpecification var1);

        default public Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return this.launchTemplateSpecification((FleetLaunchTemplateSpecification)((FleetLaunchTemplateSpecification.Builder)FleetLaunchTemplateSpecification.builder().applyMutation(launchTemplateSpecification)).build());
        }

        public Builder overrides(FleetLaunchTemplateOverrides var1);

        default public Builder overrides(Consumer<FleetLaunchTemplateOverrides.Builder> overrides) {
            return this.overrides((FleetLaunchTemplateOverrides)((FleetLaunchTemplateOverrides.Builder)FleetLaunchTemplateOverrides.builder().applyMutation(overrides)).build());
        }
    }
}

