/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv4 address pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicIpv4Pool implements SdkPojo, Serializable, ToCopyableBuilder<PublicIpv4Pool.Builder, PublicIpv4Pool> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicIpv4Pool::poolId))
            .setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId")
                    .unmarshallLocationName("poolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicIpv4Pool::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<PublicIpv4PoolRange>> POOL_ADDRESS_RANGES_FIELD = SdkField
            .<List<PublicIpv4PoolRange>> builder(MarshallingType.LIST)
            .getter(getter(PublicIpv4Pool::poolAddressRanges))
            .setter(setter(Builder::poolAddressRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolAddressRangeSet")
                    .unmarshallLocationName("poolAddressRangeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PublicIpv4PoolRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublicIpv4PoolRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TOTAL_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PublicIpv4Pool::totalAddressCount))
            .setter(setter(Builder::totalAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAddressCount")
                    .unmarshallLocationName("totalAddressCount").build()).build();

    private static final SdkField<Integer> TOTAL_AVAILABLE_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PublicIpv4Pool::totalAvailableAddressCount))
            .setter(setter(Builder::totalAvailableAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAvailableAddressCount")
                    .unmarshallLocationName("totalAvailableAddressCount").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(PublicIpv4Pool::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD,
            DESCRIPTION_FIELD, POOL_ADDRESS_RANGES_FIELD, TOTAL_ADDRESS_COUNT_FIELD, TOTAL_AVAILABLE_ADDRESS_COUNT_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String poolId;

    private final String description;

    private final List<PublicIpv4PoolRange> poolAddressRanges;

    private final Integer totalAddressCount;

    private final Integer totalAvailableAddressCount;

    private final List<Tag> tags;

    private PublicIpv4Pool(BuilderImpl builder) {
        this.poolId = builder.poolId;
        this.description = builder.description;
        this.poolAddressRanges = builder.poolAddressRanges;
        this.totalAddressCount = builder.totalAddressCount;
        this.totalAvailableAddressCount = builder.totalAvailableAddressCount;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the address pool.
     * </p>
     * 
     * @return The ID of the address pool.
     */
    public String poolId() {
        return poolId;
    }

    /**
     * <p>
     * A description of the address pool.
     * </p>
     * 
     * @return A description of the address pool.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the PoolAddressRanges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPoolAddressRanges() {
        return poolAddressRanges != null && !(poolAddressRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The address ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPoolAddressRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The address ranges.
     */
    public List<PublicIpv4PoolRange> poolAddressRanges() {
        return poolAddressRanges;
    }

    /**
     * <p>
     * The total number of addresses.
     * </p>
     * 
     * @return The total number of addresses.
     */
    public Integer totalAddressCount() {
        return totalAddressCount;
    }

    /**
     * <p>
     * The total number of available addresses.
     * </p>
     * 
     * @return The total number of available addresses.
     */
    public Integer totalAvailableAddressCount() {
        return totalAvailableAddressCount;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags for the address pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags for the address pool.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(poolAddressRanges());
        hashCode = 31 * hashCode + Objects.hashCode(totalAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalAvailableAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicIpv4Pool)) {
            return false;
        }
        PublicIpv4Pool other = (PublicIpv4Pool) obj;
        return Objects.equals(poolId(), other.poolId()) && Objects.equals(description(), other.description())
                && Objects.equals(poolAddressRanges(), other.poolAddressRanges())
                && Objects.equals(totalAddressCount(), other.totalAddressCount())
                && Objects.equals(totalAvailableAddressCount(), other.totalAvailableAddressCount())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PublicIpv4Pool").add("PoolId", poolId()).add("Description", description())
                .add("PoolAddressRanges", poolAddressRanges()).add("TotalAddressCount", totalAddressCount())
                .add("TotalAvailableAddressCount", totalAvailableAddressCount()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PoolAddressRanges":
            return Optional.ofNullable(clazz.cast(poolAddressRanges()));
        case "TotalAddressCount":
            return Optional.ofNullable(clazz.cast(totalAddressCount()));
        case "TotalAvailableAddressCount":
            return Optional.ofNullable(clazz.cast(totalAvailableAddressCount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicIpv4Pool, T> g) {
        return obj -> g.apply((PublicIpv4Pool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicIpv4Pool> {
        /**
         * <p>
         * The ID of the address pool.
         * </p>
         * 
         * @param poolId
         *        The ID of the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * A description of the address pool.
         * </p>
         * 
         * @param description
         *        A description of the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The address ranges.
         * </p>
         * 
         * @param poolAddressRanges
         *        The address ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolAddressRanges(Collection<PublicIpv4PoolRange> poolAddressRanges);

        /**
         * <p>
         * The address ranges.
         * </p>
         * 
         * @param poolAddressRanges
         *        The address ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolAddressRanges(PublicIpv4PoolRange... poolAddressRanges);

        /**
         * <p>
         * The address ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PublicIpv4PoolRange>.Builder} avoiding the
         * need to create one manually via {@link List<PublicIpv4PoolRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PublicIpv4PoolRange>.Builder#build()} is called immediately
         * and its result is passed to {@link #poolAddressRanges(List<PublicIpv4PoolRange>)}.
         * 
         * @param poolAddressRanges
         *        a consumer that will call methods on {@link List<PublicIpv4PoolRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #poolAddressRanges(List<PublicIpv4PoolRange>)
         */
        Builder poolAddressRanges(Consumer<PublicIpv4PoolRange.Builder>... poolAddressRanges);

        /**
         * <p>
         * The total number of addresses.
         * </p>
         * 
         * @param totalAddressCount
         *        The total number of addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAddressCount(Integer totalAddressCount);

        /**
         * <p>
         * The total number of available addresses.
         * </p>
         * 
         * @param totalAvailableAddressCount
         *        The total number of available addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAvailableAddressCount(Integer totalAvailableAddressCount);

        /**
         * <p>
         * Any tags for the address pool.
         * </p>
         * 
         * @param tags
         *        Any tags for the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags for the address pool.
         * </p>
         * 
         * @param tags
         *        Any tags for the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags for the address pool.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String poolId;

        private String description;

        private List<PublicIpv4PoolRange> poolAddressRanges = DefaultSdkAutoConstructList.getInstance();

        private Integer totalAddressCount;

        private Integer totalAvailableAddressCount;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublicIpv4Pool model) {
            poolId(model.poolId);
            description(model.description);
            poolAddressRanges(model.poolAddressRanges);
            totalAddressCount(model.totalAddressCount);
            totalAvailableAddressCount(model.totalAvailableAddressCount);
            tags(model.tags);
        }

        public final String getPoolId() {
            return poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<PublicIpv4PoolRange.Builder> getPoolAddressRanges() {
            return poolAddressRanges != null ? poolAddressRanges.stream().map(PublicIpv4PoolRange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder poolAddressRanges(Collection<PublicIpv4PoolRange> poolAddressRanges) {
            this.poolAddressRanges = PublicIpv4PoolRangeSetCopier.copy(poolAddressRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolAddressRanges(PublicIpv4PoolRange... poolAddressRanges) {
            poolAddressRanges(Arrays.asList(poolAddressRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolAddressRanges(Consumer<PublicIpv4PoolRange.Builder>... poolAddressRanges) {
            poolAddressRanges(Stream.of(poolAddressRanges).map(c -> PublicIpv4PoolRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPoolAddressRanges(Collection<PublicIpv4PoolRange.BuilderImpl> poolAddressRanges) {
            this.poolAddressRanges = PublicIpv4PoolRangeSetCopier.copyFromBuilder(poolAddressRanges);
        }

        public final Integer getTotalAddressCount() {
            return totalAddressCount;
        }

        @Override
        public final Builder totalAddressCount(Integer totalAddressCount) {
            this.totalAddressCount = totalAddressCount;
            return this;
        }

        public final void setTotalAddressCount(Integer totalAddressCount) {
            this.totalAddressCount = totalAddressCount;
        }

        public final Integer getTotalAvailableAddressCount() {
            return totalAvailableAddressCount;
        }

        @Override
        public final Builder totalAvailableAddressCount(Integer totalAvailableAddressCount) {
            this.totalAvailableAddressCount = totalAvailableAddressCount;
            return this;
        }

        public final void setTotalAvailableAddressCount(Integer totalAvailableAddressCount) {
            this.totalAvailableAddressCount = totalAvailableAddressCount;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public PublicIpv4Pool build() {
            return new PublicIpv4Pool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
