/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficMirrorTargetResponse extends Ec2Response implements
        ToCopyableBuilder<CreateTrafficMirrorTargetResponse.Builder, CreateTrafficMirrorTargetResponse> {
    private static final SdkField<TrafficMirrorTarget> TRAFFIC_MIRROR_TARGET_FIELD = SdkField
            .<TrafficMirrorTarget> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateTrafficMirrorTargetResponse::trafficMirrorTarget))
            .setter(setter(Builder::trafficMirrorTarget))
            .constructor(TrafficMirrorTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTarget")
                    .unmarshallLocationName("trafficMirrorTarget").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficMirrorTargetResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_TARGET_FIELD,
            CLIENT_TOKEN_FIELD));

    private final TrafficMirrorTarget trafficMirrorTarget;

    private final String clientToken;

    private CreateTrafficMirrorTargetResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorTarget = builder.trafficMirrorTarget;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the Traffic Mirror target.
     * </p>
     * 
     * @return Information about the Traffic Mirror target.
     */
    public TrafficMirrorTarget trafficMirrorTarget() {
        return trafficMirrorTarget;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorTarget());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorTargetResponse)) {
            return false;
        }
        CreateTrafficMirrorTargetResponse other = (CreateTrafficMirrorTargetResponse) obj;
        return Objects.equals(trafficMirrorTarget(), other.trafficMirrorTarget())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTrafficMirrorTargetResponse").add("TrafficMirrorTarget", trafficMirrorTarget())
                .add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorTarget":
            return Optional.ofNullable(clazz.cast(trafficMirrorTarget()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorTargetResponse, T> g) {
        return obj -> g.apply((CreateTrafficMirrorTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficMirrorTargetResponse> {
        /**
         * <p>
         * Information about the Traffic Mirror target.
         * </p>
         * 
         * @param trafficMirrorTarget
         *        Information about the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorTarget(TrafficMirrorTarget trafficMirrorTarget);

        /**
         * <p>
         * Information about the Traffic Mirror target.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficMirrorTarget.Builder} avoiding the need
         * to create one manually via {@link TrafficMirrorTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficMirrorTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficMirrorTarget(TrafficMirrorTarget)}.
         * 
         * @param trafficMirrorTarget
         *        a consumer that will call methods on {@link TrafficMirrorTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficMirrorTarget(TrafficMirrorTarget)
         */
        default Builder trafficMirrorTarget(Consumer<TrafficMirrorTarget.Builder> trafficMirrorTarget) {
            return trafficMirrorTarget(TrafficMirrorTarget.builder().applyMutation(trafficMirrorTarget).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TrafficMirrorTarget trafficMirrorTarget;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorTargetResponse model) {
            super(model);
            trafficMirrorTarget(model.trafficMirrorTarget);
            clientToken(model.clientToken);
        }

        public final TrafficMirrorTarget.Builder getTrafficMirrorTarget() {
            return trafficMirrorTarget != null ? trafficMirrorTarget.toBuilder() : null;
        }

        @Override
        public final Builder trafficMirrorTarget(TrafficMirrorTarget trafficMirrorTarget) {
            this.trafficMirrorTarget = trafficMirrorTarget;
            return this;
        }

        public final void setTrafficMirrorTarget(TrafficMirrorTarget.BuilderImpl trafficMirrorTarget) {
            this.trafficMirrorTarget = trafficMirrorTarget != null ? trafficMirrorTarget.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateTrafficMirrorTargetResponse build() {
            return new CreateTrafficMirrorTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
