/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.HostReservation;
import software.amazon.awssdk.services.ec2.model.HostReservationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHostReservationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeHostReservationsResponse> {
    private static final SdkField<List<HostReservation>> HOST_RESERVATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeHostReservationsResponse.getter(DescribeHostReservationsResponse::hostReservationSet)).setter(DescribeHostReservationsResponse.setter(Builder::hostReservationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostReservationSet").unmarshallLocationName("hostReservationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeHostReservationsResponse.getter(DescribeHostReservationsResponse::nextToken)).setter(DescribeHostReservationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_RESERVATION_SET_FIELD, NEXT_TOKEN_FIELD));
    private final List<HostReservation> hostReservationSet;
    private final String nextToken;

    private DescribeHostReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.hostReservationSet = builder.hostReservationSet;
        this.nextToken = builder.nextToken;
    }

    public boolean hasHostReservationSet() {
        return this.hostReservationSet != null && !(this.hostReservationSet instanceof SdkAutoConstructList);
    }

    public List<HostReservation> hostReservationSet() {
        return this.hostReservationSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostReservationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsResponse)) {
            return false;
        }
        DescribeHostReservationsResponse other = (DescribeHostReservationsResponse)((Object)obj);
        return Objects.equals(this.hostReservationSet(), other.hostReservationSet()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeHostReservationsResponse").add("HostReservationSet", this.hostReservationSet()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostReservationSet": {
                return Optional.ofNullable(clazz.cast(this.hostReservationSet()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostReservationsResponse, T> g) {
        return obj -> g.apply((DescribeHostReservationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<HostReservation> hostReservationSet = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsResponse model) {
            super(model);
            this.hostReservationSet(model.hostReservationSet);
            this.nextToken(model.nextToken);
        }

        public final Collection<HostReservation.Builder> getHostReservationSet() {
            return this.hostReservationSet != null ? (Collection)this.hostReservationSet.stream().map(HostReservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationSet(HostReservation ... hostReservationSet) {
            this.hostReservationSet(Arrays.asList(hostReservationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationSet(Consumer<HostReservation.Builder> ... hostReservationSet) {
            this.hostReservationSet(Stream.of(hostReservationSet).map(c -> (HostReservation)((HostReservation.Builder)HostReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHostReservationSet(Collection<HostReservation.BuilderImpl> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copyFromBuilder(hostReservationSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostReservationsResponse build() {
            return new DescribeHostReservationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHostReservationsResponse> {
        public Builder hostReservationSet(Collection<HostReservation> var1);

        public Builder hostReservationSet(HostReservation ... var1);

        public Builder hostReservationSet(Consumer<HostReservation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

