/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the result of the purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Purchase implements SdkPojo, Serializable, ToCopyableBuilder<Purchase.Builder, Purchase> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Purchase::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Purchase::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration")
                    .unmarshallLocationName("duration").build()).build();

    private static final SdkField<List<String>> HOST_ID_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Purchase::hostIdSet))
            .setter(setter(Builder::hostIdSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIdSet")
                    .unmarshallLocationName("hostIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> HOST_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Purchase::hostReservationId))
            .setter(setter(Builder::hostReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostReservationId")
                    .unmarshallLocationName("hostReservationId").build()).build();

    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Purchase::hourlyPrice))
            .setter(setter(Builder::hourlyPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice")
                    .unmarshallLocationName("hourlyPrice").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Purchase::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("instanceFamily").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Purchase::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption")
                    .unmarshallLocationName("paymentOption").build()).build();

    private static final SdkField<String> UPFRONT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Purchase::upfrontPrice))
            .setter(setter(Builder::upfrontPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontPrice")
                    .unmarshallLocationName("upfrontPrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            DURATION_FIELD, HOST_ID_SET_FIELD, HOST_RESERVATION_ID_FIELD, HOURLY_PRICE_FIELD, INSTANCE_FAMILY_FIELD,
            PAYMENT_OPTION_FIELD, UPFRONT_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final Integer duration;

    private final List<String> hostIdSet;

    private final String hostReservationId;

    private final String hourlyPrice;

    private final String instanceFamily;

    private final String paymentOption;

    private final String upfrontPrice;

    private Purchase(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    /**
     * <p>
     * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The duration of the reservation's term in seconds.
     * </p>
     * 
     * @return The duration of the reservation's term in seconds.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * Returns true if the HostIdSet property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHostIdSet() {
        return hostIdSet != null && !(hostIdSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts associated with the reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHostIdSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts associated with the reservation.
     */
    public List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The ID of the reservation.
     * </p>
     * 
     * @return The ID of the reservation.
     */
    public String hostReservationId() {
        return hostReservationId;
    }

    /**
     * <p>
     * The hourly price of the reservation per hour.
     * </p>
     * 
     * @return The hourly price of the reservation per hour.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance family on the Dedicated Host that the reservation can be associated with.
     * </p>
     * 
     * @return The instance family on the Dedicated Host that the reservation can be associated with.
     */
    public String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The payment option for the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the reservation.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option for the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the reservation.
     * @see PaymentOption
     */
    public String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The upfront price of the reservation.
     * </p>
     * 
     * @return The upfront price of the reservation.
     */
    public String upfrontPrice() {
        return upfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Purchase)) {
            return false;
        }
        Purchase other = (Purchase) obj;
        return Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(duration(), other.duration()) && Objects.equals(hostIdSet(), other.hostIdSet())
                && Objects.equals(hostReservationId(), other.hostReservationId())
                && Objects.equals(hourlyPrice(), other.hourlyPrice()) && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(upfrontPrice(), other.upfrontPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Purchase").add("CurrencyCode", currencyCodeAsString()).add("Duration", duration())
                .add("HostIdSet", hostIdSet()).add("HostReservationId", hostReservationId()).add("HourlyPrice", hourlyPrice())
                .add("InstanceFamily", instanceFamily()).add("PaymentOption", paymentOptionAsString())
                .add("UpfrontPrice", upfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "HostIdSet":
            return Optional.ofNullable(clazz.cast(hostIdSet()));
        case "HostReservationId":
            return Optional.ofNullable(clazz.cast(hostReservationId()));
        case "HourlyPrice":
            return Optional.ofNullable(clazz.cast(hourlyPrice()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "UpfrontPrice":
            return Optional.ofNullable(clazz.cast(upfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Purchase, T> g) {
        return obj -> g.apply((Purchase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Purchase> {
        /**
         * <p>
         * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The duration of the reservation's term in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the reservation's term in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The ID of the reservation.
         * </p>
         * 
         * @param hostReservationId
         *        The ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationId(String hostReservationId);

        /**
         * <p>
         * The hourly price of the reservation per hour.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price of the reservation per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance family on the Dedicated Host that the reservation can be associated with.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family on the Dedicated Host that the reservation can be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The payment option for the reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option for the reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The upfront price of the reservation.
         * </p>
         * 
         * @param upfrontPrice
         *        The upfront price of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPrice(String upfrontPrice);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private List<String> hostIdSet = DefaultSdkAutoConstructList.getInstance();

        private String hostReservationId;

        private String hourlyPrice;

        private String instanceFamily;

        private String paymentOption;

        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(Purchase model) {
            currencyCode(model.currencyCode);
            duration(model.duration);
            hostIdSet(model.hostIdSet);
            hostReservationId(model.hostReservationId);
            hourlyPrice(model.hourlyPrice);
            instanceFamily(model.instanceFamily);
            paymentOption(model.paymentOption);
            upfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCodeAsString() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Collection<String> getHostIdSet() {
            return hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        public final String getHostReservationId() {
            return hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getPaymentOptionAsString() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getUpfrontPrice() {
            return upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        public Purchase build() {
            return new Purchase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
