/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTrafficMirrorSessionRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyTrafficMirrorSessionRequest.Builder, ModifyTrafficMirrorSessionRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTrafficMirrorSessionRequest::trafficMirrorSessionId))
            .setter(setter(Builder::trafficMirrorSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSessionId")
                    .unmarshallLocationName("TrafficMirrorSessionId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTrafficMirrorSessionRequest::trafficMirrorTargetId))
            .setter(setter(Builder::trafficMirrorTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId")
                    .unmarshallLocationName("TrafficMirrorTargetId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTrafficMirrorSessionRequest::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("TrafficMirrorFilterId").build()).build();

    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyTrafficMirrorSessionRequest::packetLength))
            .setter(setter(Builder::packetLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength")
                    .unmarshallLocationName("PacketLength").build()).build();

    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyTrafficMirrorSessionRequest::sessionNumber))
            .setter(setter(Builder::sessionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber")
                    .unmarshallLocationName("SessionNumber").build()).build();

    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyTrafficMirrorSessionRequest::virtualNetworkId))
            .setter(setter(Builder::virtualNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId")
                    .unmarshallLocationName("VirtualNetworkId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTrafficMirrorSessionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<String>> REMOVE_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyTrafficMirrorSessionRequest::removeFieldsAsStrings))
            .setter(setter(Builder::removeFieldsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveField")
                    .unmarshallLocationName("RemoveField").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_SESSION_ID_FIELD, TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, PACKET_LENGTH_FIELD,
            SESSION_NUMBER_FIELD, VIRTUAL_NETWORK_ID_FIELD, DESCRIPTION_FIELD, REMOVE_FIELDS_FIELD));

    private final String trafficMirrorSessionId;

    private final String trafficMirrorTargetId;

    private final String trafficMirrorFilterId;

    private final Integer packetLength;

    private final Integer sessionNumber;

    private final Integer virtualNetworkId;

    private final String description;

    private final List<String> removeFields;

    private ModifyTrafficMirrorSessionRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorSessionId = builder.trafficMirrorSessionId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.removeFields = builder.removeFields;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror session.
     * </p>
     * 
     * @return The ID of the Traffic Mirror session.
     */
    public String trafficMirrorSessionId() {
        return trafficMirrorSessionId;
    }

    /**
     * <p>
     * The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection
     * with the source.
     * </p>
     * 
     * @return The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering
     *         connection with the source.
     */
    public String trafficMirrorTargetId() {
        return trafficMirrorTargetId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter.
     */
    public String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set
     * this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that
     * meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the
     * entire packet.
     * </p>
     * 
     * @return The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset,
     *         set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first
     *         100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you
     *         want to mirror the entire packet.
     */
    public Integer packetLength() {
        return packetLength;
    }

    /**
     * <p>
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple
     * sessions. The first session with a matching filter is the one that mirrors the packets.
     * </p>
     * <p>
     * Valid values are 1-32766.
     * </p>
     * 
     * @return The session number determines the order in which sessions are evaluated when an interface is used by
     *         multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
     *         <p>
     *         Valid values are 1-32766.
     */
    public Integer sessionNumber() {
        return sessionNumber;
    }

    /**
     * <p>
     * The virtual network ID of the Traffic Mirror session.
     * </p>
     * 
     * @return The virtual network ID of the Traffic Mirror session.
     */
    public Integer virtualNetworkId() {
        return virtualNetworkId;
    }

    /**
     * <p>
     * The description to assign to the Traffic Mirror session.
     * </p>
     * 
     * @return The description to assign to the Traffic Mirror session.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The properties that you want to remove from the Traffic Mirror session.
     * </p>
     * <p>
     * When you remove a property from a Traffic Mirror session, the property is set to the default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The properties that you want to remove from the Traffic Mirror session.</p>
     *         <p>
     *         When you remove a property from a Traffic Mirror session, the property is set to the default.
     */
    public List<TrafficMirrorSessionField> removeFields() {
        return TrafficMirrorSessionFieldListCopier.copyStringToEnum(removeFields);
    }

    /**
     * Returns true if the RemoveFields property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRemoveFields() {
        return removeFields != null && !(removeFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties that you want to remove from the Traffic Mirror session.
     * </p>
     * <p>
     * When you remove a property from a Traffic Mirror session, the property is set to the default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The properties that you want to remove from the Traffic Mirror session.</p>
     *         <p>
     *         When you remove a property from a Traffic Mirror session, the property is set to the default.
     */
    public List<String> removeFieldsAsStrings() {
        return removeFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(removeFieldsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorSessionRequest)) {
            return false;
        }
        ModifyTrafficMirrorSessionRequest other = (ModifyTrafficMirrorSessionRequest) obj;
        return Objects.equals(trafficMirrorSessionId(), other.trafficMirrorSessionId())
                && Objects.equals(trafficMirrorTargetId(), other.trafficMirrorTargetId())
                && Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(packetLength(), other.packetLength()) && Objects.equals(sessionNumber(), other.sessionNumber())
                && Objects.equals(virtualNetworkId(), other.virtualNetworkId())
                && Objects.equals(description(), other.description())
                && Objects.equals(removeFieldsAsStrings(), other.removeFieldsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyTrafficMirrorSessionRequest").add("TrafficMirrorSessionId", trafficMirrorSessionId())
                .add("TrafficMirrorTargetId", trafficMirrorTargetId()).add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("PacketLength", packetLength()).add("SessionNumber", sessionNumber())
                .add("VirtualNetworkId", virtualNetworkId()).add("Description", description())
                .add("RemoveFields", removeFieldsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorSessionId":
            return Optional.ofNullable(clazz.cast(trafficMirrorSessionId()));
        case "TrafficMirrorTargetId":
            return Optional.ofNullable(clazz.cast(trafficMirrorTargetId()));
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "PacketLength":
            return Optional.ofNullable(clazz.cast(packetLength()));
        case "SessionNumber":
            return Optional.ofNullable(clazz.cast(sessionNumber()));
        case "VirtualNetworkId":
            return Optional.ofNullable(clazz.cast(virtualNetworkId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RemoveFields":
            return Optional.ofNullable(clazz.cast(removeFieldsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorSessionRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyTrafficMirrorSessionRequest> {
        /**
         * <p>
         * The ID of the Traffic Mirror session.
         * </p>
         * 
         * @param trafficMirrorSessionId
         *        The ID of the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorSessionId(String trafficMirrorSessionId);

        /**
         * <p>
         * The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection
         * with the source.
         * </p>
         * 
         * @param trafficMirrorTargetId
         *        The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering
         *        connection with the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorTargetId(String trafficMirrorTargetId);

        /**
         * <p>
         * The ID of the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set
         * this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes
         * that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror
         * the entire packet.
         * </p>
         * 
         * @param packetLength
         *        The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a
         *        subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then
         *        the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this
         *        parameter when you want to mirror the entire packet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetLength(Integer packetLength);

        /**
         * <p>
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple
         * sessions. The first session with a matching filter is the one that mirrors the packets.
         * </p>
         * <p>
         * Valid values are 1-32766.
         * </p>
         * 
         * @param sessionNumber
         *        The session number determines the order in which sessions are evaluated when an interface is used by
         *        multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
         *        <p>
         *        Valid values are 1-32766.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionNumber(Integer sessionNumber);

        /**
         * <p>
         * The virtual network ID of the Traffic Mirror session.
         * </p>
         * 
         * @param virtualNetworkId
         *        The virtual network ID of the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNetworkId(Integer virtualNetworkId);

        /**
         * <p>
         * The description to assign to the Traffic Mirror session.
         * </p>
         * 
         * @param description
         *        The description to assign to the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFieldsWithStrings(Collection<String> removeFields);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFieldsWithStrings(String... removeFields);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFields(Collection<TrafficMirrorSessionField> removeFields);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFields(TrafficMirrorSessionField... removeFields);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trafficMirrorSessionId;

        private String trafficMirrorTargetId;

        private String trafficMirrorFilterId;

        private Integer packetLength;

        private Integer sessionNumber;

        private Integer virtualNetworkId;

        private String description;

        private List<String> removeFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorSessionRequest model) {
            super(model);
            trafficMirrorSessionId(model.trafficMirrorSessionId);
            trafficMirrorTargetId(model.trafficMirrorTargetId);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            packetLength(model.packetLength);
            sessionNumber(model.sessionNumber);
            virtualNetworkId(model.virtualNetworkId);
            description(model.description);
            removeFieldsWithStrings(model.removeFields);
        }

        public final String getTrafficMirrorSessionId() {
            return trafficMirrorSessionId;
        }

        @Override
        public final Builder trafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
            return this;
        }

        public final void setTrafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
        }

        public final String getTrafficMirrorTargetId() {
            return trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final Integer getPacketLength() {
            return packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        public final Integer getSessionNumber() {
            return sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        public final Integer getVirtualNetworkId() {
            return virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getRemoveFieldsAsStrings() {
            return removeFields;
        }

        @Override
        public final Builder removeFieldsWithStrings(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFieldsWithStrings(String... removeFields) {
            removeFieldsWithStrings(Arrays.asList(removeFields));
            return this;
        }

        @Override
        public final Builder removeFields(Collection<TrafficMirrorSessionField> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copyEnumToString(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFields(TrafficMirrorSessionField... removeFields) {
            removeFields(Arrays.asList(removeFields));
            return this;
        }

        public final void setRemoveFieldsWithStrings(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorSessionRequest build() {
            return new ModifyTrafficMirrorSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
