/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDefaultCreditSpecificationRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyDefaultCreditSpecificationRequest.Builder, ModifyDefaultCreditSpecificationRequest> {
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDefaultCreditSpecificationRequest::instanceFamilyAsString))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("InstanceFamily").build()).build();

    private static final SdkField<String> CPU_CREDITS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyDefaultCreditSpecificationRequest::cpuCredits))
            .setter(setter(Builder::cpuCredits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuCredits")
                    .unmarshallLocationName("CpuCredits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FAMILY_FIELD,
            CPU_CREDITS_FIELD));

    private final String instanceFamily;

    private final String cpuCredits;

    private ModifyDefaultCreditSpecificationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceFamily = builder.instanceFamily;
        this.cpuCredits = builder.cpuCredits;
    }

    /**
     * <p>
     * The instance family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFamily}
     * will return {@link UnlimitedSupportedInstanceFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instanceFamilyAsString}.
     * </p>
     * 
     * @return The instance family.
     * @see UnlimitedSupportedInstanceFamily
     */
    public UnlimitedSupportedInstanceFamily instanceFamily() {
        return UnlimitedSupportedInstanceFamily.fromValue(instanceFamily);
    }

    /**
     * <p>
     * The instance family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFamily}
     * will return {@link UnlimitedSupportedInstanceFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instanceFamilyAsString}.
     * </p>
     * 
     * @return The instance family.
     * @see UnlimitedSupportedInstanceFamily
     */
    public String instanceFamilyAsString() {
        return instanceFamily;
    }

    /**
     * <p>
     * The credit option for CPU usage of the instance family.
     * </p>
     * <p>
     * Valid Values: <code>standard</code> | <code>unlimited</code>
     * </p>
     * 
     * @return The credit option for CPU usage of the instance family.</p>
     *         <p>
     *         Valid Values: <code>standard</code> | <code>unlimited</code>
     */
    public String cpuCredits() {
        return cpuCredits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCredits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDefaultCreditSpecificationRequest)) {
            return false;
        }
        ModifyDefaultCreditSpecificationRequest other = (ModifyDefaultCreditSpecificationRequest) obj;
        return Objects.equals(instanceFamilyAsString(), other.instanceFamilyAsString())
                && Objects.equals(cpuCredits(), other.cpuCredits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyDefaultCreditSpecificationRequest").add("InstanceFamily", instanceFamilyAsString())
                .add("CpuCredits", cpuCredits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamilyAsString()));
        case "CpuCredits":
            return Optional.ofNullable(clazz.cast(cpuCredits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDefaultCreditSpecificationRequest, T> g) {
        return obj -> g.apply((ModifyDefaultCreditSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyDefaultCreditSpecificationRequest> {
        /**
         * <p>
         * The instance family.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family.
         * @see UnlimitedSupportedInstanceFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlimitedSupportedInstanceFamily
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The instance family.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family.
         * @see UnlimitedSupportedInstanceFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlimitedSupportedInstanceFamily
         */
        Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily);

        /**
         * <p>
         * The credit option for CPU usage of the instance family.
         * </p>
         * <p>
         * Valid Values: <code>standard</code> | <code>unlimited</code>
         * </p>
         * 
         * @param cpuCredits
         *        The credit option for CPU usage of the instance family.</p>
         *        <p>
         *        Valid Values: <code>standard</code> | <code>unlimited</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCredits(String cpuCredits);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceFamily;

        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDefaultCreditSpecificationRequest model) {
            super(model);
            instanceFamily(model.instanceFamily);
            cpuCredits(model.cpuCredits);
        }

        public final String getInstanceFamilyAsString() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public final Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily) {
            this.instanceFamily(instanceFamily == null ? null : instanceFamily.toString());
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getCpuCredits() {
            return cpuCredits;
        }

        @Override
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDefaultCreditSpecificationRequest build() {
            return new ModifyDefaultCreditSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
