/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnassignIpv6AddressesResponse extends Ec2Response implements
        ToCopyableBuilder<UnassignIpv6AddressesResponse.Builder, UnassignIpv6AddressesResponse> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UnassignIpv6AddressesResponse::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<String>> UNASSIGNED_IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UnassignIpv6AddressesResponse::unassignedIpv6Addresses))
            .setter(setter(Builder::unassignedIpv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnassignedIpv6Addresses")
                    .unmarshallLocationName("unassignedIpv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            UNASSIGNED_IPV6_ADDRESSES_FIELD));

    private final String networkInterfaceId;

    private final List<String> unassignedIpv6Addresses;

    private UnassignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.unassignedIpv6Addresses = builder.unassignedIpv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * Returns true if the UnassignedIpv6Addresses property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUnassignedIpv6Addresses() {
        return unassignedIpv6Addresses != null && !(unassignedIpv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses that have been unassigned from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnassignedIpv6Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv6 addresses that have been unassigned from the network interface.
     */
    public List<String> unassignedIpv6Addresses() {
        return unassignedIpv6Addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(unassignedIpv6Addresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesResponse)) {
            return false;
        }
        UnassignIpv6AddressesResponse other = (UnassignIpv6AddressesResponse) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(unassignedIpv6Addresses(), other.unassignedIpv6Addresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UnassignIpv6AddressesResponse").add("NetworkInterfaceId", networkInterfaceId())
                .add("UnassignedIpv6Addresses", unassignedIpv6Addresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "UnassignedIpv6Addresses":
            return Optional.ofNullable(clazz.cast(unassignedIpv6Addresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnassignIpv6AddressesResponse, T> g) {
        return obj -> g.apply((UnassignIpv6AddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IPv6 addresses that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Addresses
         *        The IPv6 addresses that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses);

        /**
         * <p>
         * The IPv6 addresses that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Addresses
         *        The IPv6 addresses that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Addresses(String... unassignedIpv6Addresses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String networkInterfaceId;

        private List<String> unassignedIpv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesResponse model) {
            super(model);
            networkInterfaceId(model.networkInterfaceId);
            unassignedIpv6Addresses(model.unassignedIpv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getUnassignedIpv6Addresses() {
            return unassignedIpv6Addresses;
        }

        @Override
        public final Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Addresses(String... unassignedIpv6Addresses) {
            unassignedIpv6Addresses(Arrays.asList(unassignedIpv6Addresses));
            return this;
        }

        public final void setUnassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
        }

        @Override
        public UnassignIpv6AddressesResponse build() {
            return new UnassignIpv6AddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
