/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the transit gateway multicast group resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayMulticastGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayMulticastGroup.Builder, TransitGatewayMulticastGroup> {
    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::groupIpAddress))
            .setter(setter(Builder::groupIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress")
                    .unmarshallLocationName("groupIpAddress").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<Boolean> GROUP_MEMBER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TransitGatewayMulticastGroup::groupMember))
            .setter(setter(Builder::groupMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMember")
                    .unmarshallLocationName("groupMember").build()).build();

    private static final SdkField<Boolean> GROUP_SOURCE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TransitGatewayMulticastGroup::groupSource))
            .setter(setter(Builder::groupSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSource")
                    .unmarshallLocationName("groupSource").build()).build();

    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::memberTypeAsString))
            .setter(setter(Builder::memberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType")
                    .unmarshallLocationName("memberType").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastGroup::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType")
                    .unmarshallLocationName("sourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IP_ADDRESS_FIELD,
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, SUBNET_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD,
            NETWORK_INTERFACE_ID_FIELD, GROUP_MEMBER_FIELD, GROUP_SOURCE_FIELD, MEMBER_TYPE_FIELD, SOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupIpAddress;

    private final String transitGatewayAttachmentId;

    private final String subnetId;

    private final String resourceId;

    private final String resourceType;

    private final String networkInterfaceId;

    private final Boolean groupMember;

    private final Boolean groupSource;

    private final String memberType;

    private final String sourceType;

    private TransitGatewayMulticastGroup(BuilderImpl builder) {
        this.groupIpAddress = builder.groupIpAddress;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.subnetId = builder.subnetId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.groupMember = builder.groupMember;
        this.groupSource = builder.groupSource;
        this.memberType = builder.memberType;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The IP address assigned to the transit gateway multicast group.
     * </p>
     * 
     * @return The IP address assigned to the transit gateway multicast group.
     */
    public String groupIpAddress() {
        return groupIpAddress;
    }

    /**
     * <p>
     * The ID of the transit gateway attachment.
     * </p>
     * 
     * @return The ID of the transit gateway attachment.
     */
    public String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource, for example a VPC attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource, for example a VPC attachment.
     * @see TransitGatewayAttachmentResourceType
     */
    public TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource, for example a VPC attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource, for example a VPC attachment.
     * @see TransitGatewayAttachmentResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the transit gateway attachment.
     * </p>
     * 
     * @return The ID of the transit gateway attachment.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Indicates that the resource is a transit gateway multicast group member.
     * </p>
     * 
     * @return Indicates that the resource is a transit gateway multicast group member.
     */
    public Boolean groupMember() {
        return groupMember;
    }

    /**
     * <p>
     * Indicates that the resource is a transit gateway multicast group member.
     * </p>
     * 
     * @return Indicates that the resource is a transit gateway multicast group member.
     */
    public Boolean groupSource() {
        return groupSource;
    }

    /**
     * <p>
     * The member type (for example, <code>static</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The member type (for example, <code>static</code>).
     * @see MembershipType
     */
    public MembershipType memberType() {
        return MembershipType.fromValue(memberType);
    }

    /**
     * <p>
     * The member type (for example, <code>static</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The member type (for example, <code>static</code>).
     * @see MembershipType
     */
    public String memberTypeAsString() {
        return memberType;
    }

    /**
     * <p>
     * The source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type.
     * @see MembershipType
     */
    public MembershipType sourceType() {
        return MembershipType.fromValue(sourceType);
    }

    /**
     * <p>
     * The source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type.
     * @see MembershipType
     */
    public String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(groupMember());
        hashCode = 31 * hashCode + Objects.hashCode(groupSource());
        hashCode = 31 * hashCode + Objects.hashCode(memberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastGroup)) {
            return false;
        }
        TransitGatewayMulticastGroup other = (TransitGatewayMulticastGroup) obj;
        return Objects.equals(groupIpAddress(), other.groupIpAddress())
                && Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(groupMember(), other.groupMember()) && Objects.equals(groupSource(), other.groupSource())
                && Objects.equals(memberTypeAsString(), other.memberTypeAsString())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayMulticastGroup").add("GroupIpAddress", groupIpAddress())
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId()).add("SubnetId", subnetId())
                .add("ResourceId", resourceId()).add("ResourceType", resourceTypeAsString())
                .add("NetworkInterfaceId", networkInterfaceId()).add("GroupMember", groupMember())
                .add("GroupSource", groupSource()).add("MemberType", memberTypeAsString())
                .add("SourceType", sourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupIpAddress":
            return Optional.ofNullable(clazz.cast(groupIpAddress()));
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "GroupMember":
            return Optional.ofNullable(clazz.cast(groupMember()));
        case "GroupSource":
            return Optional.ofNullable(clazz.cast(groupSource()));
        case "MemberType":
            return Optional.ofNullable(clazz.cast(memberTypeAsString()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastGroup, T> g) {
        return obj -> g.apply((TransitGatewayMulticastGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayMulticastGroup> {
        /**
         * <p>
         * The IP address assigned to the transit gateway multicast group.
         * </p>
         * 
         * @param groupIpAddress
         *        The IP address assigned to the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIpAddress(String groupIpAddress);

        /**
         * <p>
         * The ID of the transit gateway attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource, for example a VPC attachment.
         * </p>
         * 
         * @param resourceType
         *        The type of resource, for example a VPC attachment.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource, for example a VPC attachment.
         * </p>
         * 
         * @param resourceType
         *        The type of resource, for example a VPC attachment.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(TransitGatewayAttachmentResourceType resourceType);

        /**
         * <p>
         * The ID of the transit gateway attachment.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Indicates that the resource is a transit gateway multicast group member.
         * </p>
         * 
         * @param groupMember
         *        Indicates that the resource is a transit gateway multicast group member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupMember(Boolean groupMember);

        /**
         * <p>
         * Indicates that the resource is a transit gateway multicast group member.
         * </p>
         * 
         * @param groupSource
         *        Indicates that the resource is a transit gateway multicast group member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupSource(Boolean groupSource);

        /**
         * <p>
         * The member type (for example, <code>static</code>).
         * </p>
         * 
         * @param memberType
         *        The member type (for example, <code>static</code>).
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder memberType(String memberType);

        /**
         * <p>
         * The member type (for example, <code>static</code>).
         * </p>
         * 
         * @param memberType
         *        The member type (for example, <code>static</code>).
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder memberType(MembershipType memberType);

        /**
         * <p>
         * The source type.
         * </p>
         * 
         * @param sourceType
         *        The source type.
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source type.
         * </p>
         * 
         * @param sourceType
         *        The source type.
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder sourceType(MembershipType sourceType);
    }

    static final class BuilderImpl implements Builder {
        private String groupIpAddress;

        private String transitGatewayAttachmentId;

        private String subnetId;

        private String resourceId;

        private String resourceType;

        private String networkInterfaceId;

        private Boolean groupMember;

        private Boolean groupSource;

        private String memberType;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastGroup model) {
            groupIpAddress(model.groupIpAddress);
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            subnetId(model.subnetId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            networkInterfaceId(model.networkInterfaceId);
            groupMember(model.groupMember);
            groupSource(model.groupSource);
            memberType(model.memberType);
            sourceType(model.sourceType);
        }

        public final String getGroupIpAddress() {
            return groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Boolean getGroupMember() {
            return groupMember;
        }

        @Override
        public final Builder groupMember(Boolean groupMember) {
            this.groupMember = groupMember;
            return this;
        }

        public final void setGroupMember(Boolean groupMember) {
            this.groupMember = groupMember;
        }

        public final Boolean getGroupSource() {
            return groupSource;
        }

        @Override
        public final Builder groupSource(Boolean groupSource) {
            this.groupSource = groupSource;
            return this;
        }

        public final void setGroupSource(Boolean groupSource) {
            this.groupSource = groupSource;
        }

        public final String getMemberTypeAsString() {
            return memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MembershipType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        public final String getSourceTypeAsString() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(MembershipType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public TransitGatewayMulticastGroup build() {
            return new TransitGatewayMulticastGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
