/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic Graphics accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticGpus implements SdkPojo, Serializable, ToCopyableBuilder<ElasticGpus.Builder, ElasticGpus> {
    private static final SdkField<String> ELASTIC_GPU_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpus::elasticGpuId))
            .setter(setter(Builder::elasticGpuId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuId")
                    .unmarshallLocationName("elasticGpuId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpus::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> ELASTIC_GPU_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpus::elasticGpuType))
            .setter(setter(Builder::elasticGpuType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuType")
                    .unmarshallLocationName("elasticGpuType").build()).build();

    private static final SdkField<ElasticGpuHealth> ELASTIC_GPU_HEALTH_FIELD = SdkField
            .<ElasticGpuHealth> builder(MarshallingType.SDK_POJO)
            .getter(getter(ElasticGpus::elasticGpuHealth))
            .setter(setter(Builder::elasticGpuHealth))
            .constructor(ElasticGpuHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuHealth")
                    .unmarshallLocationName("elasticGpuHealth").build()).build();

    private static final SdkField<String> ELASTIC_GPU_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpus::elasticGpuStateAsString))
            .setter(setter(Builder::elasticGpuState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuState")
                    .unmarshallLocationName("elasticGpuState").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpus::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ElasticGpus::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_GPU_ID_FIELD,
            AVAILABILITY_ZONE_FIELD, ELASTIC_GPU_TYPE_FIELD, ELASTIC_GPU_HEALTH_FIELD, ELASTIC_GPU_STATE_FIELD,
            INSTANCE_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String elasticGpuId;

    private final String availabilityZone;

    private final String elasticGpuType;

    private final ElasticGpuHealth elasticGpuHealth;

    private final String elasticGpuState;

    private final String instanceId;

    private final List<Tag> tags;

    private ElasticGpus(BuilderImpl builder) {
        this.elasticGpuId = builder.elasticGpuId;
        this.availabilityZone = builder.availabilityZone;
        this.elasticGpuType = builder.elasticGpuType;
        this.elasticGpuHealth = builder.elasticGpuHealth;
        this.elasticGpuState = builder.elasticGpuState;
        this.instanceId = builder.instanceId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Elastic Graphics accelerator.
     * </p>
     * 
     * @return The ID of the Elastic Graphics accelerator.
     */
    public String elasticGpuId() {
        return elasticGpuId;
    }

    /**
     * <p>
     * The Availability Zone in the which the Elastic Graphics accelerator resides.
     * </p>
     * 
     * @return The Availability Zone in the which the Elastic Graphics accelerator resides.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The type of Elastic Graphics accelerator.
     * </p>
     * 
     * @return The type of Elastic Graphics accelerator.
     */
    public String elasticGpuType() {
        return elasticGpuType;
    }

    /**
     * <p>
     * The status of the Elastic Graphics accelerator.
     * </p>
     * 
     * @return The status of the Elastic Graphics accelerator.
     */
    public ElasticGpuHealth elasticGpuHealth() {
        return elasticGpuHealth;
    }

    /**
     * <p>
     * The state of the Elastic Graphics accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elasticGpuState}
     * will return {@link ElasticGpuState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #elasticGpuStateAsString}.
     * </p>
     * 
     * @return The state of the Elastic Graphics accelerator.
     * @see ElasticGpuState
     */
    public ElasticGpuState elasticGpuState() {
        return ElasticGpuState.fromValue(elasticGpuState);
    }

    /**
     * <p>
     * The state of the Elastic Graphics accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elasticGpuState}
     * will return {@link ElasticGpuState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #elasticGpuStateAsString}.
     * </p>
     * 
     * @return The state of the Elastic Graphics accelerator.
     * @see ElasticGpuState
     */
    public String elasticGpuStateAsString() {
        return elasticGpuState;
    }

    /**
     * <p>
     * The ID of the instance to which the Elastic Graphics accelerator is attached.
     * </p>
     * 
     * @return The ID of the instance to which the Elastic Graphics accelerator is attached.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the Elastic Graphics accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the Elastic Graphics accelerator.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuType());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuHealth());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticGpus)) {
            return false;
        }
        ElasticGpus other = (ElasticGpus) obj;
        return Objects.equals(elasticGpuId(), other.elasticGpuId())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(elasticGpuType(), other.elasticGpuType())
                && Objects.equals(elasticGpuHealth(), other.elasticGpuHealth())
                && Objects.equals(elasticGpuStateAsString(), other.elasticGpuStateAsString())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ElasticGpus").add("ElasticGpuId", elasticGpuId()).add("AvailabilityZone", availabilityZone())
                .add("ElasticGpuType", elasticGpuType()).add("ElasticGpuHealth", elasticGpuHealth())
                .add("ElasticGpuState", elasticGpuStateAsString()).add("InstanceId", instanceId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuId":
            return Optional.ofNullable(clazz.cast(elasticGpuId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ElasticGpuType":
            return Optional.ofNullable(clazz.cast(elasticGpuType()));
        case "ElasticGpuHealth":
            return Optional.ofNullable(clazz.cast(elasticGpuHealth()));
        case "ElasticGpuState":
            return Optional.ofNullable(clazz.cast(elasticGpuStateAsString()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticGpus, T> g) {
        return obj -> g.apply((ElasticGpus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticGpus> {
        /**
         * <p>
         * The ID of the Elastic Graphics accelerator.
         * </p>
         * 
         * @param elasticGpuId
         *        The ID of the Elastic Graphics accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuId(String elasticGpuId);

        /**
         * <p>
         * The Availability Zone in the which the Elastic Graphics accelerator resides.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in the which the Elastic Graphics accelerator resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The type of Elastic Graphics accelerator.
         * </p>
         * 
         * @param elasticGpuType
         *        The type of Elastic Graphics accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuType(String elasticGpuType);

        /**
         * <p>
         * The status of the Elastic Graphics accelerator.
         * </p>
         * 
         * @param elasticGpuHealth
         *        The status of the Elastic Graphics accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuHealth(ElasticGpuHealth elasticGpuHealth);

        /**
         * <p>
         * The status of the Elastic Graphics accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticGpuHealth.Builder} avoiding the need to
         * create one manually via {@link ElasticGpuHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticGpuHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #elasticGpuHealth(ElasticGpuHealth)}.
         * 
         * @param elasticGpuHealth
         *        a consumer that will call methods on {@link ElasticGpuHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuHealth(ElasticGpuHealth)
         */
        default Builder elasticGpuHealth(Consumer<ElasticGpuHealth.Builder> elasticGpuHealth) {
            return elasticGpuHealth(ElasticGpuHealth.builder().applyMutation(elasticGpuHealth).build());
        }

        /**
         * <p>
         * The state of the Elastic Graphics accelerator.
         * </p>
         * 
         * @param elasticGpuState
         *        The state of the Elastic Graphics accelerator.
         * @see ElasticGpuState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticGpuState
         */
        Builder elasticGpuState(String elasticGpuState);

        /**
         * <p>
         * The state of the Elastic Graphics accelerator.
         * </p>
         * 
         * @param elasticGpuState
         *        The state of the Elastic Graphics accelerator.
         * @see ElasticGpuState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticGpuState
         */
        Builder elasticGpuState(ElasticGpuState elasticGpuState);

        /**
         * <p>
         * The ID of the instance to which the Elastic Graphics accelerator is attached.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to which the Elastic Graphics accelerator is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The tags assigned to the Elastic Graphics accelerator.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Elastic Graphics accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the Elastic Graphics accelerator.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Elastic Graphics accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the Elastic Graphics accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String elasticGpuId;

        private String availabilityZone;

        private String elasticGpuType;

        private ElasticGpuHealth elasticGpuHealth;

        private String elasticGpuState;

        private String instanceId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticGpus model) {
            elasticGpuId(model.elasticGpuId);
            availabilityZone(model.availabilityZone);
            elasticGpuType(model.elasticGpuType);
            elasticGpuHealth(model.elasticGpuHealth);
            elasticGpuState(model.elasticGpuState);
            instanceId(model.instanceId);
            tags(model.tags);
        }

        public final String getElasticGpuId() {
            return elasticGpuId;
        }

        @Override
        public final Builder elasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
            return this;
        }

        public final void setElasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getElasticGpuType() {
            return elasticGpuType;
        }

        @Override
        public final Builder elasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
            return this;
        }

        public final void setElasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
        }

        public final ElasticGpuHealth.Builder getElasticGpuHealth() {
            return elasticGpuHealth != null ? elasticGpuHealth.toBuilder() : null;
        }

        @Override
        public final Builder elasticGpuHealth(ElasticGpuHealth elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth;
            return this;
        }

        public final void setElasticGpuHealth(ElasticGpuHealth.BuilderImpl elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth != null ? elasticGpuHealth.build() : null;
        }

        public final String getElasticGpuStateAsString() {
            return elasticGpuState;
        }

        @Override
        public final Builder elasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
            return this;
        }

        @Override
        public final Builder elasticGpuState(ElasticGpuState elasticGpuState) {
            this.elasticGpuState(elasticGpuState == null ? null : elasticGpuState.toString());
            return this;
        }

        public final void setElasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ElasticGpus build() {
            return new ElasticGpus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
