/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchTemplateVersionRequest extends Ec2Request implements
        ToCopyableBuilder<CreateLaunchTemplateVersionRequest.Builder, CreateLaunchTemplateVersionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateVersionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateVersionRequest::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId")
                    .unmarshallLocationName("LaunchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateVersionRequest::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("LaunchTemplateName").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateVersionRequest::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersion")
                    .unmarshallLocationName("SourceVersion").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateVersionRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription")
                    .unmarshallLocationName("VersionDescription").build()).build();

    private static final SdkField<RequestLaunchTemplateData> LAUNCH_TEMPLATE_DATA_FIELD = SdkField
            .<RequestLaunchTemplateData> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateLaunchTemplateVersionRequest::launchTemplateData))
            .setter(setter(Builder::launchTemplateData))
            .constructor(RequestLaunchTemplateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData")
                    .unmarshallLocationName("LaunchTemplateData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_TEMPLATE_NAME_FIELD, SOURCE_VERSION_FIELD, VERSION_DESCRIPTION_FIELD,
            LAUNCH_TEMPLATE_DATA_FIELD));

    private final String clientToken;

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final String sourceVersion;

    private final String versionDescription;

    private final RequestLaunchTemplateData launchTemplateData;

    private CreateLaunchTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.sourceVersion = builder.sourceVersion;
        this.versionDescription = builder.versionDescription;
        this.launchTemplateData = builder.launchTemplateData;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * <p>
     * Constraint: Maximum 128 ASCII characters.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.</p>
     *         <p>
     *         Constraint: Maximum 128 ASCII characters.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the launch template. You must specify either the launch template ID or launch template name in the
     * request.
     * </p>
     * 
     * @return The ID of the launch template. You must specify either the launch template ID or launch template name in
     *         the request.
     */
    public String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template. You must specify either the launch template ID or launch template name in the
     * request.
     * </p>
     * 
     * @return The name of the launch template. You must specify either the launch template ID or launch template name
     *         in the request.
     */
    public String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The version number of the launch template version on which to base the new version. The new version inherits the
     * same launch parameters as the source version, except for parameters that you specify in
     * <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a new
     * version unless they are explicitly included.
     * </p>
     * 
     * @return The version number of the launch template version on which to base the new version. The new version
     *         inherits the same launch parameters as the source version, except for parameters that you specify in
     *         <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating
     *         a new version unless they are explicitly included.
     */
    public String sourceVersion() {
        return sourceVersion;
    }

    /**
     * <p>
     * A description for the version of the launch template.
     * </p>
     * 
     * @return A description for the version of the launch template.
     */
    public String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The information for the launch template.
     * </p>
     * 
     * @return The information for the launch template.
     */
    public RequestLaunchTemplateData launchTemplateData() {
        return launchTemplateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateVersionRequest)) {
            return false;
        }
        CreateLaunchTemplateVersionRequest other = (CreateLaunchTemplateVersionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName())
                && Objects.equals(sourceVersion(), other.sourceVersion())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(launchTemplateData(), other.launchTemplateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLaunchTemplateVersionRequest").add("ClientToken", clientToken())
                .add("LaunchTemplateId", launchTemplateId()).add("LaunchTemplateName", launchTemplateName())
                .add("SourceVersion", sourceVersion()).add("VersionDescription", versionDescription())
                .add("LaunchTemplateData", launchTemplateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "SourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "LaunchTemplateData":
            return Optional.ofNullable(clazz.cast(launchTemplateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateVersionRequest, T> g) {
        return obj -> g.apply((CreateLaunchTemplateVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateLaunchTemplateVersionRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * <p>
         * Constraint: Maximum 128 ASCII characters.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.</p>
         *        <p>
         *        Constraint: Maximum 128 ASCII characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the launch template. You must specify either the launch template ID or launch template name in the
         * request.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template. You must specify either the launch template ID or launch template name
         *        in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template. You must specify either the launch template ID or launch template name in
         * the request.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template. You must specify either the launch template ID or launch template
         *        name in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The version number of the launch template version on which to base the new version. The new version inherits
         * the same launch parameters as the source version, except for parameters that you specify in
         * <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a
         * new version unless they are explicitly included.
         * </p>
         * 
         * @param sourceVersion
         *        The version number of the launch template version on which to base the new version. The new version
         *        inherits the same launch parameters as the source version, except for parameters that you specify in
         *        <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when
         *        creating a new version unless they are explicitly included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         * <p>
         * A description for the version of the launch template.
         * </p>
         * 
         * @param versionDescription
         *        A description for the version of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The information for the launch template.
         * </p>
         * 
         * @param launchTemplateData
         *        The information for the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateData(RequestLaunchTemplateData launchTemplateData);

        /**
         * <p>
         * The information for the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link RequestLaunchTemplateData.Builder} avoiding the
         * need to create one manually via {@link RequestLaunchTemplateData#builder()}.
         *
         * When the {@link Consumer} completes, {@link RequestLaunchTemplateData.Builder#build()} is called immediately
         * and its result is passed to {@link #launchTemplateData(RequestLaunchTemplateData)}.
         * 
         * @param launchTemplateData
         *        a consumer that will call methods on {@link RequestLaunchTemplateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateData(RequestLaunchTemplateData)
         */
        default Builder launchTemplateData(Consumer<RequestLaunchTemplateData.Builder> launchTemplateData) {
            return launchTemplateData(RequestLaunchTemplateData.builder().applyMutation(launchTemplateData).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String launchTemplateId;

        private String launchTemplateName;

        private String sourceVersion;

        private String versionDescription;

        private RequestLaunchTemplateData launchTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateVersionRequest model) {
            super(model);
            clientToken(model.clientToken);
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            sourceVersion(model.sourceVersion);
            versionDescription(model.versionDescription);
            launchTemplateData(model.launchTemplateData);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        public final RequestLaunchTemplateData.Builder getLaunchTemplateData() {
            return launchTemplateData != null ? launchTemplateData.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateData(RequestLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final void setLaunchTemplateData(RequestLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchTemplateVersionRequest build() {
            return new CreateLaunchTemplateVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
