/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetRequest extends Ec2Request implements
        ToCopyableBuilder<CreateFleetRequest.Builder, CreateFleetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFleetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<SpotOptionsRequest> SPOT_OPTIONS_FIELD = SdkField
            .<SpotOptionsRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFleetRequest::spotOptions))
            .setter(setter(Builder::spotOptions))
            .constructor(SpotOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions")
                    .unmarshallLocationName("SpotOptions").build()).build();

    private static final SdkField<OnDemandOptionsRequest> ON_DEMAND_OPTIONS_FIELD = SdkField
            .<OnDemandOptionsRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFleetRequest::onDemandOptions))
            .setter(setter(Builder::onDemandOptions))
            .constructor(OnDemandOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandOptions")
                    .unmarshallLocationName("OnDemandOptions").build()).build();

    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFleetRequest::excessCapacityTerminationPolicyAsString))
            .setter(setter(Builder::excessCapacityTerminationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy")
                    .unmarshallLocationName("ExcessCapacityTerminationPolicy").build()).build();

    private static final SdkField<List<FleetLaunchTemplateConfigRequest>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField
            .<List<FleetLaunchTemplateConfigRequest>> builder(MarshallingType.LIST)
            .getter(getter(CreateFleetRequest::launchTemplateConfigs))
            .setter(setter(Builder::launchTemplateConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfigs")
                    .unmarshallLocationName("LaunchTemplateConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FleetLaunchTemplateConfigRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetLaunchTemplateConfigRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<TargetCapacitySpecificationRequest> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField
            .<TargetCapacitySpecificationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFleetRequest::targetCapacitySpecification))
            .setter(setter(Builder::targetCapacitySpecification))
            .constructor(TargetCapacitySpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification")
                    .unmarshallLocationName("TargetCapacitySpecification").build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateFleetRequest::terminateInstancesWithExpiration))
            .setter(setter(Builder::terminateInstancesWithExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstancesWithExpiration")
                    .unmarshallLocationName("TerminateInstancesWithExpiration").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFleetRequest::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateFleetRequest::validFrom))
            .setter(setter(Builder::validFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom")
                    .unmarshallLocationName("ValidFrom").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateFleetRequest::validUntil))
            .setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil")
                    .unmarshallLocationName("ValidUntil").build()).build();

    private static final SdkField<Boolean> REPLACE_UNHEALTHY_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateFleetRequest::replaceUnhealthyInstances))
            .setter(setter(Builder::replaceUnhealthyInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceUnhealthyInstances")
                    .unmarshallLocationName("ReplaceUnhealthyInstances").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateFleetRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            SPOT_OPTIONS_FIELD, ON_DEMAND_OPTIONS_FIELD, EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD,
            TARGET_CAPACITY_SPECIFICATION_FIELD, TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD, TYPE_FIELD, VALID_FROM_FIELD,
            VALID_UNTIL_FIELD, REPLACE_UNHEALTHY_INSTANCES_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String clientToken;

    private final SpotOptionsRequest spotOptions;

    private final OnDemandOptionsRequest onDemandOptions;

    private final String excessCapacityTerminationPolicy;

    private final List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs;

    private final TargetCapacitySpecificationRequest targetCapacitySpecification;

    private final Boolean terminateInstancesWithExpiration;

    private final String type;

    private final Instant validFrom;

    private final Instant validUntil;

    private final Boolean replaceUnhealthyInstances;

    private final List<TagSpecification> tagSpecifications;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.spotOptions = builder.spotOptions;
        this.onDemandOptions = builder.onDemandOptions;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     * </p>
     * 
     * @return Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    public SpotOptionsRequest spotOptions() {
        return spotOptions;
    }

    /**
     * <p>
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     * </p>
     * 
     * @return Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    public OnDemandOptionsRequest onDemandOptions() {
        return onDemandOptions;
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     * decreased below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     * decreased below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * Returns true if the LaunchTemplateConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLaunchTemplateConfigs() {
        return launchTemplateConfigs != null && !(launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration for the EC2 Fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchTemplateConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration for the EC2 Fleet.
     */
    public List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs() {
        return launchTemplateConfigs;
    }

    /**
     * <p>
     * The number of units to request.
     * </p>
     * 
     * @return The number of units to request.
     */
    public TargetCapacitySpecificationRequest targetCapacitySpecification() {
        return targetCapacitySpecification;
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    public Boolean terminateInstancesWithExpiration() {
        return terminateInstancesWithExpiration;
    }

    /**
     * <p>
     * The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired capacity, and
     * maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value of <code>instant</code>
     * places a synchronous one-time request, and returns errors for any instances that could not be launched. A value
     * of <code>request</code> places an asynchronous one-time request without maintaining capacity or submitting
     * requests in alternative capacity pools if capacity is unavailable. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
     * >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired
     *         capacity, and maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value of
     *         <code>instant</code> places a synchronous one-time request, and returns errors for any instances that
     *         could not be launched. A value of <code>request</code> places an asynchronous one-time request without
     *         maintaining capacity or submitting requests in alternative capacity pools if capacity is unavailable. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
     *         >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @see FleetType
     */
    public FleetType type() {
        return FleetType.fromValue(type);
    }

    /**
     * <p>
     * The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired capacity, and
     * maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value of <code>instant</code>
     * places a synchronous one-time request, and returns errors for any instances that could not be launched. A value
     * of <code>request</code> places an asynchronous one-time request without maintaining capacity or submitting
     * requests in alternative capacity pools if capacity is unavailable. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
     * >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired
     *         capacity, and maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value of
     *         <code>instant</code> places a synchronous one-time request, and returns errors for any instances that
     *         could not be launched. A value of <code>request</code> places an asynchronous one-time request without
     *         maintaining capacity or submitting requests in alternative capacity pools if capacity is unavailable. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
     *         >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @see FleetType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The start date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request
     * immediately.
     * </p>
     * 
     * @return The start date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
     *         request immediately.
     */
    public Instant validFrom() {
        return validFrom;
    }

    /**
     * <p>
     * The end date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are
     * placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     * </p>
     * 
     * @return The end date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests
     *         are placed or able to fulfill the request. If no value is specified, the request remains until you cancel
     *         it.
     */
    public Instant validUntil() {
        return validUntil;
    }

    /**
     * <p>
     * Indicates whether EC2 Fleet should replace unhealthy instances.
     * </p>
     * 
     * @return Indicates whether EC2 Fleet should replace unhealthy instances.
     */
    public Boolean replaceUnhealthyInstances() {
        return replaceUnhealthyInstances;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair for tagging the EC2 Fleet request on creation. The value for <code>ResourceType</code> must be
     * <code>fleet</code>, otherwise the fleet request fails. To tag instances at launch, specify the tags in the <a
     * href
     * ="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch
     * template</a>. For information about tagging after launch, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
     * Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pair for tagging the EC2 Fleet request on creation. The value for <code>ResourceType</code>
     *         must be <code>fleet</code>, otherwise the fleet request fails. To tag instances at launch, specify the
     *         tags in the <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
     *         >launch template</a>. For information about tagging after launch, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
     *         Resources</a>.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandOptions());
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(spotOptions(), other.spotOptions())
                && Objects.equals(onDemandOptions(), other.onDemandOptions())
                && Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString())
                && Objects.equals(launchTemplateConfigs(), other.launchTemplateConfigs())
                && Objects.equals(targetCapacitySpecification(), other.targetCapacitySpecification())
                && Objects.equals(terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(validFrom(), other.validFrom())
                && Objects.equals(validUntil(), other.validUntil())
                && Objects.equals(replaceUnhealthyInstances(), other.replaceUnhealthyInstances())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFleetRequest").add("ClientToken", clientToken()).add("SpotOptions", spotOptions())
                .add("OnDemandOptions", onDemandOptions())
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString())
                .add("LaunchTemplateConfigs", launchTemplateConfigs())
                .add("TargetCapacitySpecification", targetCapacitySpecification())
                .add("TerminateInstancesWithExpiration", terminateInstancesWithExpiration()).add("Type", typeAsString())
                .add("ValidFrom", validFrom()).add("ValidUntil", validUntil())
                .add("ReplaceUnhealthyInstances", replaceUnhealthyInstances()).add("TagSpecifications", tagSpecifications())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SpotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        case "OnDemandOptions":
            return Optional.ofNullable(clazz.cast(onDemandOptions()));
        case "ExcessCapacityTerminationPolicy":
            return Optional.ofNullable(clazz.cast(excessCapacityTerminationPolicyAsString()));
        case "LaunchTemplateConfigs":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigs()));
        case "TargetCapacitySpecification":
            return Optional.ofNullable(clazz.cast(targetCapacitySpecification()));
        case "TerminateInstancesWithExpiration":
            return Optional.ofNullable(clazz.cast(terminateInstancesWithExpiration()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ValidFrom":
            return Optional.ofNullable(clazz.cast(validFrom()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        case "ReplaceUnhealthyInstances":
            return Optional.ofNullable(clazz.cast(replaceUnhealthyInstances()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         * </p>
         * 
         * @param spotOptions
         *        Describes the configuration of Spot Instances in an EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(SpotOptionsRequest spotOptions);

        /**
         * <p>
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotOptionsRequest.Builder} avoiding the need to
         * create one manually via {@link SpotOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotOptionsRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #spotOptions(SpotOptionsRequest)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on {@link SpotOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(SpotOptionsRequest)
         */
        default Builder spotOptions(Consumer<SpotOptionsRequest.Builder> spotOptions) {
            return spotOptions(SpotOptionsRequest.builder().applyMutation(spotOptions).build());
        }

        /**
         * <p>
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * </p>
         * 
         * @param onDemandOptions
         *        Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandOptions(OnDemandOptionsRequest onDemandOptions);

        /**
         * <p>
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link OnDemandOptionsRequest.Builder} avoiding the
         * need to create one manually via {@link OnDemandOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnDemandOptionsRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #onDemandOptions(OnDemandOptionsRequest)}.
         * 
         * @param onDemandOptions
         *        a consumer that will call methods on {@link OnDemandOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandOptions(OnDemandOptionsRequest)
         */
        default Builder onDemandOptions(Consumer<OnDemandOptionsRequest.Builder> onDemandOptions) {
            return onDemandOptions(OnDemandOptionsRequest.builder().applyMutation(onDemandOptions).build());
        }

        /**
         * <p>
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
         * decreased below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet
         *        is decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
         * decreased below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet
         *        is decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The configuration for the EC2 Fleet.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The configuration for the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs);

        /**
         * <p>
         * The configuration for the EC2 Fleet.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The configuration for the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest... launchTemplateConfigs);

        /**
         * <p>
         * The configuration for the EC2 Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FleetLaunchTemplateConfigRequest>.Builder}
         * avoiding the need to create one manually via {@link List<FleetLaunchTemplateConfigRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetLaunchTemplateConfigRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #launchTemplateConfigs(List<FleetLaunchTemplateConfigRequest>)}.
         * 
         * @param launchTemplateConfigs
         *        a consumer that will call methods on {@link List<FleetLaunchTemplateConfigRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigs(List<FleetLaunchTemplateConfigRequest>)
         */
        Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder>... launchTemplateConfigs);

        /**
         * <p>
         * The number of units to request.
         * </p>
         * 
         * @param targetCapacitySpecification
         *        The number of units to request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification);

        /**
         * <p>
         * The number of units to request.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetCapacitySpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link TargetCapacitySpecificationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetCapacitySpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #targetCapacitySpecification(TargetCapacitySpecificationRequest)}.
         * 
         * @param targetCapacitySpecification
         *        a consumer that will call methods on {@link TargetCapacitySpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetCapacitySpecification(TargetCapacitySpecificationRequest)
         */
        default Builder targetCapacitySpecification(
                Consumer<TargetCapacitySpecificationRequest.Builder> targetCapacitySpecification) {
            return targetCapacitySpecification(TargetCapacitySpecificationRequest.builder()
                    .applyMutation(targetCapacitySpecification).build());
        }

        /**
         * <p>
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * </p>
         * 
         * @param terminateInstancesWithExpiration
         *        Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration);

        /**
         * <p>
         * The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired capacity,
         * and maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value of
         * <code>instant</code> places a synchronous one-time request, and returns errors for any instances that could
         * not be launched. A value of <code>request</code> places an asynchronous one-time request without maintaining
         * capacity or submitting requests in alternative capacity pools if capacity is unavailable. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
         * >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired
         *        capacity, and maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value
         *        of <code>instant</code> places a synchronous one-time request, and returns errors for any instances
         *        that could not be launched. A value of <code>request</code> places an asynchronous one-time request
         *        without maintaining capacity or submitting requests in alternative capacity pools if capacity is
         *        unavailable. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
         *        >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired capacity,
         * and maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value of
         * <code>instant</code> places a synchronous one-time request, and returns errors for any instances that could
         * not be launched. A value of <code>request</code> places an asynchronous one-time request without maintaining
         * capacity or submitting requests in alternative capacity pools if capacity is unavailable. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
         * >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired
         *        capacity, and maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value
         *        of <code>instant</code> places a synchronous one-time request, and returns errors for any instances
         *        that could not be launched. A value of <code>request</code> places an asynchronous one-time request
         *        without maintaining capacity or submitting requests in alternative capacity pools if capacity is
         *        unavailable. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type"
         *        >EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(FleetType type);

        /**
         * <p>
         * The start date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
         * request immediately.
         * </p>
         * 
         * @param validFrom
         *        The start date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling
         *        the request immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFrom(Instant validFrom);

        /**
         * <p>
         * The end date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are
         * placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
         * </p>
         * 
         * @param validUntil
         *        The end date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet
         *        requests are placed or able to fulfill the request. If no value is specified, the request remains
         *        until you cancel it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * Indicates whether EC2 Fleet should replace unhealthy instances.
         * </p>
         * 
         * @param replaceUnhealthyInstances
         *        Indicates whether EC2 Fleet should replace unhealthy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances);

        /**
         * <p>
         * The key-value pair for tagging the EC2 Fleet request on creation. The value for <code>ResourceType</code>
         * must be <code>fleet</code>, otherwise the fleet request fails. To tag instances at launch, specify the tags
         * in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         * >launch template</a>. For information about tagging after launch, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         * Resources</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The key-value pair for tagging the EC2 Fleet request on creation. The value for
         *        <code>ResourceType</code> must be <code>fleet</code>, otherwise the fleet request fails. To tag
         *        instances at launch, specify the tags in the <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         *        >launch template</a>. For information about tagging after launch, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The key-value pair for tagging the EC2 Fleet request on creation. The value for <code>ResourceType</code>
         * must be <code>fleet</code>, otherwise the fleet request fails. To tag instances at launch, specify the tags
         * in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         * >launch template</a>. For information about tagging after launch, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         * Resources</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The key-value pair for tagging the EC2 Fleet request on creation. The value for
         *        <code>ResourceType</code> must be <code>fleet</code>, otherwise the fleet request fails. To tag
         *        instances at launch, specify the tags in the <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         *        >launch template</a>. For information about tagging after launch, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The key-value pair for tagging the EC2 Fleet request on creation. The value for <code>ResourceType</code>
         * must be <code>fleet</code>, otherwise the fleet request fails. To tag instances at launch, specify the tags
         * in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         * >launch template</a>. For information about tagging after launch, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         * Resources</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private SpotOptionsRequest spotOptions;

        private OnDemandOptionsRequest onDemandOptions;

        private String excessCapacityTerminationPolicy;

        private List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();

        private TargetCapacitySpecificationRequest targetCapacitySpecification;

        private Boolean terminateInstancesWithExpiration;

        private String type;

        private Instant validFrom;

        private Instant validUntil;

        private Boolean replaceUnhealthyInstances;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            clientToken(model.clientToken);
            spotOptions(model.spotOptions);
            onDemandOptions(model.onDemandOptions);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            launchTemplateConfigs(model.launchTemplateConfigs);
            targetCapacitySpecification(model.targetCapacitySpecification);
            terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            type(model.type);
            validFrom(model.validFrom);
            validUntil(model.validUntil);
            replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final SpotOptionsRequest.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptionsRequest spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final void setSpotOptions(SpotOptionsRequest.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        public final OnDemandOptionsRequest.Builder getOnDemandOptions() {
            return onDemandOptions != null ? onDemandOptions.toBuilder() : null;
        }

        @Override
        public final Builder onDemandOptions(OnDemandOptionsRequest onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        public final void setOnDemandOptions(OnDemandOptionsRequest.BuilderImpl onDemandOptions) {
            this.onDemandOptions = onDemandOptions != null ? onDemandOptions.build() : null;
        }

        public final String getExcessCapacityTerminationPolicyAsString() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy
                    .toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Collection<FleetLaunchTemplateConfigRequest.Builder> getLaunchTemplateConfigs() {
            return launchTemplateConfigs != null ? launchTemplateConfigs.stream()
                    .map(FleetLaunchTemplateConfigRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest... launchTemplateConfigs) {
            launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder>... launchTemplateConfigs) {
            launchTemplateConfigs(Stream.of(launchTemplateConfigs)
                    .map(c -> FleetLaunchTemplateConfigRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final TargetCapacitySpecificationRequest.Builder getTargetCapacitySpecification() {
            return targetCapacitySpecification != null ? targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(
                TargetCapacitySpecificationRequest.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
