/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseSpecificationListRequestCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacementRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequestListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestLaunchTemplateData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestLaunchTemplateData> {
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::kernelId)).setter(RequestLaunchTemplateData.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("KernelId").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::ebsOptimized)).setter(RequestLaunchTemplateData.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("EbsOptimized").build()}).build();
    private static final SdkField<LaunchTemplateIamInstanceProfileSpecificationRequest> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::iamInstanceProfile)).setter(RequestLaunchTemplateData.setter(Builder::iamInstanceProfile)).constructor(LaunchTemplateIamInstanceProfileSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("IamInstanceProfile").build()}).build();
    private static final SdkField<List<LaunchTemplateBlockDeviceMappingRequest>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::blockDeviceMappings)).setter(RequestLaunchTemplateData.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build(), ListTrait.builder().memberLocationName("BlockDeviceMapping").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateBlockDeviceMappingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::networkInterfaces)).setter(RequestLaunchTemplateData.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface").unmarshallLocationName("NetworkInterface").build(), ListTrait.builder().memberLocationName("InstanceNetworkInterfaceSpecification").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceNetworkInterfaceSpecification").unmarshallLocationName("InstanceNetworkInterfaceSpecification").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::imageId)).setter(RequestLaunchTemplateData.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::instanceTypeAsString)).setter(RequestLaunchTemplateData.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::keyName)).setter(RequestLaunchTemplateData.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build();
    private static final SdkField<LaunchTemplatesMonitoringRequest> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::monitoring)).setter(RequestLaunchTemplateData.setter(Builder::monitoring)).constructor(LaunchTemplatesMonitoringRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("Monitoring").build()}).build();
    private static final SdkField<LaunchTemplatePlacementRequest> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::placement)).setter(RequestLaunchTemplateData.setter(Builder::placement)).constructor(LaunchTemplatePlacementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("Placement").build()}).build();
    private static final SdkField<String> RAM_DISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::ramDiskId)).setter(RequestLaunchTemplateData.setter(Builder::ramDiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamDiskId").unmarshallLocationName("RamDiskId").build()}).build();
    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::disableApiTermination)).setter(RequestLaunchTemplateData.setter(Builder::disableApiTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination").unmarshallLocationName("DisableApiTermination").build()}).build();
    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::instanceInitiatedShutdownBehaviorAsString)).setter(RequestLaunchTemplateData.setter(Builder::instanceInitiatedShutdownBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior").unmarshallLocationName("InstanceInitiatedShutdownBehavior").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::userData)).setter(RequestLaunchTemplateData.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("UserData").build()}).build();
    private static final SdkField<List<LaunchTemplateTagSpecificationRequest>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::tagSpecifications)).setter(RequestLaunchTemplateData.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("LaunchTemplateTagSpecificationRequest").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateTagSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateTagSpecificationRequest").unmarshallLocationName("LaunchTemplateTagSpecificationRequest").build()}).build()).build()}).build();
    private static final SdkField<List<ElasticGpuSpecification>> ELASTIC_GPU_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::elasticGpuSpecifications)).setter(RequestLaunchTemplateData.setter(Builder::elasticGpuSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification").unmarshallLocationName("ElasticGpuSpecification").build(), ListTrait.builder().memberLocationName("ElasticGpuSpecification").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticGpuSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification").unmarshallLocationName("ElasticGpuSpecification").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateElasticInferenceAccelerator>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::elasticInferenceAccelerators)).setter(RequestLaunchTemplateData.setter(Builder::elasticInferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAccelerator").unmarshallLocationName("ElasticInferenceAccelerator").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateElasticInferenceAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::securityGroupIds)).setter(RequestLaunchTemplateData.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::securityGroups)).setter(RequestLaunchTemplateData.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("SecurityGroup").build(), ListTrait.builder().memberLocationName("SecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("SecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<LaunchTemplateInstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::instanceMarketOptions)).setter(RequestLaunchTemplateData.setter(Builder::instanceMarketOptions)).constructor(LaunchTemplateInstanceMarketOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions").unmarshallLocationName("InstanceMarketOptions").build()}).build();
    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::creditSpecification)).setter(RequestLaunchTemplateData.setter(Builder::creditSpecification)).constructor(CreditSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification").unmarshallLocationName("CreditSpecification").build()}).build();
    private static final SdkField<LaunchTemplateCpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::cpuOptions)).setter(RequestLaunchTemplateData.setter(Builder::cpuOptions)).constructor(LaunchTemplateCpuOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").unmarshallLocationName("CpuOptions").build()}).build();
    private static final SdkField<LaunchTemplateCapacityReservationSpecificationRequest> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::capacityReservationSpecification)).setter(RequestLaunchTemplateData.setter(Builder::capacityReservationSpecification)).constructor(LaunchTemplateCapacityReservationSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").unmarshallLocationName("CapacityReservationSpecification").build()}).build();
    private static final SdkField<List<LaunchTemplateLicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::licenseSpecifications)).setter(RequestLaunchTemplateData.setter(Builder::licenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecification").unmarshallLocationName("LicenseSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateLicenseConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<LaunchTemplateHibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::hibernationOptions)).setter(RequestLaunchTemplateData.setter(Builder::hibernationOptions)).constructor(LaunchTemplateHibernationOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").unmarshallLocationName("HibernationOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_ID_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, NETWORK_INTERFACES_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAM_DISK_ID_FIELD, DISABLE_API_TERMINATION_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, USER_DATA_FIELD, TAG_SPECIFICATIONS_FIELD, ELASTIC_GPU_SPECIFICATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, SECURITY_GROUP_IDS_FIELD, SECURITY_GROUPS_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD, LICENSE_SPECIFICATIONS_FIELD, HIBERNATION_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kernelId;
    private final Boolean ebsOptimized;
    private final LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
    private final List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings;
    private final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces;
    private final String imageId;
    private final String instanceType;
    private final String keyName;
    private final LaunchTemplatesMonitoringRequest monitoring;
    private final LaunchTemplatePlacementRequest placement;
    private final String ramDiskId;
    private final Boolean disableApiTermination;
    private final String instanceInitiatedShutdownBehavior;
    private final String userData;
    private final List<LaunchTemplateTagSpecificationRequest> tagSpecifications;
    private final List<ElasticGpuSpecification> elasticGpuSpecifications;
    private final List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
    private final CreditSpecificationRequest creditSpecification;
    private final LaunchTemplateCpuOptionsRequest cpuOptions;
    private final LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;
    private final List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications;
    private final LaunchTemplateHibernationOptionsRequest hibernationOptions;

    private RequestLaunchTemplateData(BuilderImpl builder) {
        this.kernelId = builder.kernelId;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.networkInterfaces = builder.networkInterfaces;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramDiskId = builder.ramDiskId;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.userData = builder.userData;
        this.tagSpecifications = builder.tagSpecifications;
        this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.hibernationOptions = builder.hibernationOptions;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces() {
        return this.networkInterfaces;
    }

    public String imageId() {
        return this.imageId;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String keyName() {
        return this.keyName;
    }

    public LaunchTemplatesMonitoringRequest monitoring() {
        return this.monitoring;
    }

    public LaunchTemplatePlacementRequest placement() {
        return this.placement;
    }

    public String ramDiskId() {
        return this.ramDiskId;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public String instanceInitiatedShutdownBehaviorAsString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String userData() {
        return this.userData;
    }

    public boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplateTagSpecificationRequest> tagSpecifications() {
        return this.tagSpecifications;
    }

    public boolean hasElasticGpuSpecifications() {
        return this.elasticGpuSpecifications != null && !(this.elasticGpuSpecifications instanceof SdkAutoConstructList);
    }

    public List<ElasticGpuSpecification> elasticGpuSpecifications() {
        return this.elasticGpuSpecifications;
    }

    public boolean hasElasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators != null && !(this.elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public CreditSpecificationRequest creditSpecification() {
        return this.creditSpecification;
    }

    public LaunchTemplateCpuOptionsRequest cpuOptions() {
        return this.cpuOptions;
    }

    public LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    public boolean hasLicenseSpecifications() {
        return this.licenseSpecifications != null && !(this.licenseSpecifications instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications() {
        return this.licenseSpecifications;
    }

    public LaunchTemplateHibernationOptionsRequest hibernationOptions() {
        return this.hibernationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticInferenceAccelerators());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.hibernationOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestLaunchTemplateData)) {
            return false;
        }
        RequestLaunchTemplateData other = (RequestLaunchTemplateData)obj;
        return Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramDiskId(), other.ramDiskId()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.elasticGpuSpecifications(), other.elasticGpuSpecifications()) && Objects.equals(this.elasticInferenceAccelerators(), other.elasticInferenceAccelerators()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.instanceMarketOptions(), other.instanceMarketOptions()) && Objects.equals(this.creditSpecification(), other.creditSpecification()) && Objects.equals(this.cpuOptions(), other.cpuOptions()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification()) && Objects.equals(this.licenseSpecifications(), other.licenseSpecifications()) && Objects.equals(this.hibernationOptions(), other.hibernationOptions());
    }

    public String toString() {
        return ToString.builder((String)"RequestLaunchTemplateData").add("KernelId", (Object)this.kernelId()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("NetworkInterfaces", this.networkInterfaces()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KeyName", (Object)this.keyName()).add("Monitoring", (Object)this.monitoring()).add("Placement", (Object)this.placement()).add("RamDiskId", (Object)this.ramDiskId()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehaviorAsString()).add("UserData", (Object)this.userData()).add("TagSpecifications", this.tagSpecifications()).add("ElasticGpuSpecifications", this.elasticGpuSpecifications()).add("ElasticInferenceAccelerators", this.elasticInferenceAccelerators()).add("SecurityGroupIds", this.securityGroupIds()).add("SecurityGroups", this.securityGroups()).add("InstanceMarketOptions", (Object)this.instanceMarketOptions()).add("CreditSpecification", (Object)this.creditSpecification()).add("CpuOptions", (Object)this.cpuOptions()).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).add("LicenseSpecifications", this.licenseSpecifications()).add("HibernationOptions", (Object)this.hibernationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamDiskId": {
                return Optional.ofNullable(clazz.cast(this.ramDiskId()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehaviorAsString()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ElasticGpuSpecifications": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuSpecifications()));
            }
            case "ElasticInferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.elasticInferenceAccelerators()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "InstanceMarketOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMarketOptions()));
            }
            case "CreditSpecification": {
                return Optional.ofNullable(clazz.cast(this.creditSpecification()));
            }
            case "CpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
            case "LicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.licenseSpecifications()));
            }
            case "HibernationOptions": {
                return Optional.ofNullable(clazz.cast(this.hibernationOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestLaunchTemplateData, T> g) {
        return obj -> g.apply((RequestLaunchTemplateData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kernelId;
        private Boolean ebsOptimized;
        private LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
        private List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private String instanceType;
        private String keyName;
        private LaunchTemplatesMonitoringRequest monitoring;
        private LaunchTemplatePlacementRequest placement;
        private String ramDiskId;
        private Boolean disableApiTermination;
        private String instanceInitiatedShutdownBehavior;
        private String userData;
        private List<LaunchTemplateTagSpecificationRequest> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<ElasticGpuSpecification> elasticGpuSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
        private CreditSpecificationRequest creditSpecification;
        private LaunchTemplateCpuOptionsRequest cpuOptions;
        private LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;
        private List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateHibernationOptionsRequest hibernationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestLaunchTemplateData model) {
            this.kernelId(model.kernelId);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.networkInterfaces(model.networkInterfaces);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.ramDiskId(model.ramDiskId);
            this.disableApiTermination(model.disableApiTermination);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.userData(model.userData);
            this.tagSpecifications(model.tagSpecifications);
            this.elasticGpuSpecifications(model.elasticGpuSpecifications);
            this.elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            this.securityGroupIds(model.securityGroupIds);
            this.securityGroups(model.securityGroups);
            this.instanceMarketOptions(model.instanceMarketOptions);
            this.creditSpecification(model.creditSpecification);
            this.cpuOptions(model.cpuOptions);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
            this.licenseSpecifications(model.licenseSpecifications);
            this.hibernationOptions(model.hibernationOptions);
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final LaunchTemplateIamInstanceProfileSpecificationRequest.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final Collection<LaunchTemplateBlockDeviceMappingRequest.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(LaunchTemplateBlockDeviceMappingRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (LaunchTemplateBlockDeviceMappingRequest)((LaunchTemplateBlockDeviceMappingRequest.Builder)LaunchTemplateBlockDeviceMappingRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest)((LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder)LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceTypeAsString() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final LaunchTemplatesMonitoringRequest.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(LaunchTemplatesMonitoringRequest monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(LaunchTemplatesMonitoringRequest.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final LaunchTemplatePlacementRequest.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(LaunchTemplatePlacementRequest placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(LaunchTemplatePlacementRequest.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamDiskId() {
            return this.ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final String getInstanceInitiatedShutdownBehaviorAsString() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Collection<LaunchTemplateTagSpecificationRequest.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(LaunchTemplateTagSpecificationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(LaunchTemplateTagSpecificationRequest ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (LaunchTemplateTagSpecificationRequest)((LaunchTemplateTagSpecificationRequest.Builder)LaunchTemplateTagSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<LaunchTemplateTagSpecificationRequest.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copyFromBuilder(tagSpecifications);
        }

        public final Collection<ElasticGpuSpecification.Builder> getElasticGpuSpecifications() {
            return this.elasticGpuSpecifications != null ? (Collection)this.elasticGpuSpecifications.stream().map(ElasticGpuSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copy(elasticGpuSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(ElasticGpuSpecification ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Arrays.asList(elasticGpuSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder> ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Stream.of(elasticGpuSpecifications).map(c -> (ElasticGpuSpecification)((ElasticGpuSpecification.Builder)ElasticGpuSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuSpecifications(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copyFromBuilder(elasticGpuSpecifications);
        }

        public final Collection<LaunchTemplateElasticInferenceAccelerator.Builder> getElasticInferenceAccelerators() {
            return this.elasticInferenceAccelerators != null ? (Collection)this.elasticInferenceAccelerators.stream().map(LaunchTemplateElasticInferenceAccelerator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier.copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAccelerator ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(Consumer<LaunchTemplateElasticInferenceAccelerator.Builder> ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators).map(c -> (LaunchTemplateElasticInferenceAccelerator)((LaunchTemplateElasticInferenceAccelerator.Builder)LaunchTemplateElasticInferenceAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier.copyFromBuilder(elasticInferenceAccelerators);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        public final LaunchTemplateInstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return this.instanceMarketOptions != null ? this.instanceMarketOptions.toBuilder() : null;
        }

        @Override
        public final Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return this.creditSpecification != null ? this.creditSpecification.toBuilder() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        public final LaunchTemplateCpuOptionsRequest.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        @Override
        public final Builder cpuOptions(LaunchTemplateCpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final void setCpuOptions(LaunchTemplateCpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        public final LaunchTemplateCapacityReservationSpecificationRequest.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final void setCapacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        public final Collection<LaunchTemplateLicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            return this.licenseSpecifications != null ? (Collection)this.licenseSpecifications.stream().map(LaunchTemplateLicenseConfigurationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest ... licenseSpecifications) {
            this.licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfigurationRequest.Builder> ... licenseSpecifications) {
            this.licenseSpecifications(Stream.of(licenseSpecifications).map(c -> (LaunchTemplateLicenseConfigurationRequest)((LaunchTemplateLicenseConfigurationRequest.Builder)LaunchTemplateLicenseConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier.copyFromBuilder(licenseSpecifications);
        }

        public final LaunchTemplateHibernationOptionsRequest.Builder getHibernationOptions() {
            return this.hibernationOptions != null ? this.hibernationOptions.toBuilder() : null;
        }

        @Override
        public final Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final void setHibernationOptions(LaunchTemplateHibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        public RequestLaunchTemplateData build() {
            return new RequestLaunchTemplateData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestLaunchTemplateData> {
        public Builder kernelId(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest var1);

        default public Builder iamInstanceProfile(Consumer<LaunchTemplateIamInstanceProfileSpecificationRequest.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((LaunchTemplateIamInstanceProfileSpecificationRequest)((LaunchTemplateIamInstanceProfileSpecificationRequest.Builder)LaunchTemplateIamInstanceProfileSpecificationRequest.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> var1);

        public Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest ... var1);

        public Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder> ... var1);

        public Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> var1);

        public Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest ... var1);

        public Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder keyName(String var1);

        public Builder monitoring(LaunchTemplatesMonitoringRequest var1);

        default public Builder monitoring(Consumer<LaunchTemplatesMonitoringRequest.Builder> monitoring) {
            return this.monitoring((LaunchTemplatesMonitoringRequest)((LaunchTemplatesMonitoringRequest.Builder)LaunchTemplatesMonitoringRequest.builder().applyMutation(monitoring)).build());
        }

        public Builder placement(LaunchTemplatePlacementRequest var1);

        default public Builder placement(Consumer<LaunchTemplatePlacementRequest.Builder> placement) {
            return this.placement((LaunchTemplatePlacementRequest)((LaunchTemplatePlacementRequest.Builder)LaunchTemplatePlacementRequest.builder().applyMutation(placement)).build());
        }

        public Builder ramDiskId(String var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder userData(String var1);

        public Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> var1);

        public Builder tagSpecifications(LaunchTemplateTagSpecificationRequest ... var1);

        public Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder> ... var1);

        public Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> var1);

        public Builder elasticGpuSpecifications(ElasticGpuSpecification ... var1);

        public Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder> ... var1);

        public Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator> var1);

        public Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAccelerator ... var1);

        public Builder elasticInferenceAccelerators(Consumer<LaunchTemplateElasticInferenceAccelerator.Builder> ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest var1);

        default public Builder instanceMarketOptions(Consumer<LaunchTemplateInstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return this.instanceMarketOptions((LaunchTemplateInstanceMarketOptionsRequest)((LaunchTemplateInstanceMarketOptionsRequest.Builder)LaunchTemplateInstanceMarketOptionsRequest.builder().applyMutation(instanceMarketOptions)).build());
        }

        public Builder creditSpecification(CreditSpecificationRequest var1);

        default public Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return this.creditSpecification((CreditSpecificationRequest)((CreditSpecificationRequest.Builder)CreditSpecificationRequest.builder().applyMutation(creditSpecification)).build());
        }

        public Builder cpuOptions(LaunchTemplateCpuOptionsRequest var1);

        default public Builder cpuOptions(Consumer<LaunchTemplateCpuOptionsRequest.Builder> cpuOptions) {
            return this.cpuOptions((LaunchTemplateCpuOptionsRequest)((LaunchTemplateCpuOptionsRequest.Builder)LaunchTemplateCpuOptionsRequest.builder().applyMutation(cpuOptions)).build());
        }

        public Builder capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest var1);

        default public Builder capacityReservationSpecification(Consumer<LaunchTemplateCapacityReservationSpecificationRequest.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((LaunchTemplateCapacityReservationSpecificationRequest)((LaunchTemplateCapacityReservationSpecificationRequest.Builder)LaunchTemplateCapacityReservationSpecificationRequest.builder().applyMutation(capacityReservationSpecification)).build());
        }

        public Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> var1);

        public Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest ... var1);

        public Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfigurationRequest.Builder> ... var1);

        public Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest var1);

        default public Builder hibernationOptions(Consumer<LaunchTemplateHibernationOptionsRequest.Builder> hibernationOptions) {
            return this.hibernationOptions((LaunchTemplateHibernationOptionsRequest)((LaunchTemplateHibernationOptionsRequest.Builder)LaunchTemplateHibernationOptionsRequest.builder().applyMutation(hibernationOptions)).build());
        }
    }
}

