/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CidrAuthorizationContext;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionByoipCidrRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ProvisionByoipCidrRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::cidr)).setter(ProvisionByoipCidrRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<CidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::cidrAuthorizationContext)).setter(ProvisionByoipCidrRequest.setter(Builder::cidrAuthorizationContext)).constructor(CidrAuthorizationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext").unmarshallLocationName("CidrAuthorizationContext").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::description)).setter(ProvisionByoipCidrRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, CIDR_AUTHORIZATION_CONTEXT_FIELD, DESCRIPTION_FIELD));
    private final String cidr;
    private final CidrAuthorizationContext cidrAuthorizationContext;
    private final String description;

    private ProvisionByoipCidrRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
        this.description = builder.description;
    }

    public String cidr() {
        return this.cidr;
    }

    public CidrAuthorizationContext cidrAuthorizationContext() {
        return this.cidrAuthorizationContext;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrAuthorizationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionByoipCidrRequest)) {
            return false;
        }
        ProvisionByoipCidrRequest other = (ProvisionByoipCidrRequest)((Object)obj);
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.cidrAuthorizationContext(), other.cidrAuthorizationContext()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"ProvisionByoipCidrRequest").add("Cidr", (Object)this.cidr()).add("CidrAuthorizationContext", (Object)this.cidrAuthorizationContext()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "CidrAuthorizationContext": {
                return Optional.ofNullable(clazz.cast(this.cidrAuthorizationContext()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionByoipCidrRequest, T> g) {
        return obj -> g.apply((ProvisionByoipCidrRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String cidr;
        private CidrAuthorizationContext cidrAuthorizationContext;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionByoipCidrRequest model) {
            super(model);
            this.cidr(model.cidr);
            this.cidrAuthorizationContext(model.cidrAuthorizationContext);
            this.description(model.description);
        }

        public final String getCidr() {
            return this.cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public final CidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return this.cidrAuthorizationContext != null ? this.cidrAuthorizationContext.toBuilder() : null;
        }

        @Override
        public final Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        public final void setCidrAuthorizationContext(CidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionByoipCidrRequest build() {
            return new ProvisionByoipCidrRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionByoipCidrRequest> {
        public Builder cidr(String var1);

        public Builder cidrAuthorizationContext(CidrAuthorizationContext var1);

        default public Builder cidrAuthorizationContext(Consumer<CidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return this.cidrAuthorizationContext((CidrAuthorizationContext)((CidrAuthorizationContext.Builder)CidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext)).build());
        }

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

